/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.util.StringTokenizer;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.models.obj.ObjLoader;
import org.newdawn.render.models.obj.ObjModel;
import org.newdawn.render.particles.ParticleEngine;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.effect.ParticleEffect;
import org.newdawn.tilt.effect.ParticleProvider;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.tilt.util.FastTrig;
import org.newdawn.util.Log;

public class Teleport
extends MapElement
implements ParticleEffect {
    private static ObjModel model;
    private static Sound noise;
    private static Texture texture;
    private float x;
    private float y;
    private Shape shape;
    private String data;
    private int list;
    private int tube;
    private GlobalEmitter emitter;
    private float ang;
    private int nextParticle;
    private int teleportCountdown;
    private int id;

    public static void init() throws IOException {
        model = ObjLoader.loadObj((String)"res/teleport.obj");
        noise = SoundStore.get().getOgg("res/sounds/teleport.ogg");
        texture = TextureLoader.get().getTextureLinear("res/teleport.tga");
    }

    public Teleport(Map map, String data, float x, float y) throws IOException {
        this.x = x;
        this.y = y;
        this.data = data;
        StringTokenizer tokens = new StringTokenizer(data, ",");
        tokens.nextToken();
        this.id = Integer.parseInt(tokens.nextToken());
        this.shape = new Circle(x, y, 0.0f);
    }

    public int getID() {
        return this.id;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public Body getBody() {
        return null;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void createImpl() {
        this.ang = (float)(Math.random() * Math.PI * 2.0);
    }

    public void destroy() {
    }

    public void renderImpl(int delta, boolean reflection) {
        if (reflection) {
            return;
        }
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        Map.render(texture, model, null, false);
        GL11.glRotatef((float)-45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-this.x), (float)(-this.y), (float)0.0f);
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
        if (this.emitter == null) {
            this.emitter = emitter;
            emitter.addEffect(this);
        }
    }

    public boolean hit(Ball ball, float depth) {
        if (ball.getLastTeleport() != this) {
            ball.teleport(this);
            this.teleportCountdown = 1000;
            noise.playAsSoundEffect(1.0f, 0.2f);
        }
        return true;
    }

    public MapElement copy(Map map) {
        try {
            return new Teleport(map, this.data, this.x, this.y);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public void update(ParticleProvider provider, ParticleEngine engine, int delta) {
        this.nextParticle -= delta;
        if (this.teleportCountdown > 0) {
            this.teleportCountdown -= delta;
        }
        if (this.nextParticle <= 0) {
            float yo;
            float xo;
            this.nextParticle = 50;
            boolean num = true;
            int p = provider.getParticle(this, 400);
            if (p != -1) {
                this.ang += (float)delta * 0.02f;
                xo = (float)(FastTrig.sin(this.ang) * (double)0.6f);
                yo = (float)(FastTrig.cos(this.ang) * (double)0.6f);
                engine.setPos(p, this.x + xo, this.y + yo, 0.1f);
                engine.setSize(p, 0.15f);
                engine.setColor(p, 1.0f, 1.0f, 1.0f, 1.0f);
                engine.setVelocity(p, 0.0f, 0.0f, 0.0f);
            }
            if ((p = provider.getParticle(this, 400)) != -1) {
                xo = (float)(FastTrig.sin((double)this.ang + Math.PI) * (double)0.6f);
                yo = (float)(FastTrig.cos((double)this.ang + Math.PI) * (double)0.6f);
                engine.setPos(p, this.x + xo, this.y + yo, 0.1f);
                engine.setSize(p, 0.15f);
                engine.setColor(p, 1.0f, 1.0f, 1.0f, 1.0f);
                engine.setVelocity(p, 0.0f, 0.0f, 0.0f);
            }
        }
    }

    public void updateParticle(int index, int delta, ParticleEngine engine, int life) {
        engine.adjustColor(index, 0.0f, 0.0f, (float)(-delta) * 0.004f, (float)(-delta) * 0.001f);
        engine.adjustSize(index, (float)(-delta) * 2.0E-4f);
    }

    public boolean finished() {
        return false;
    }
}

