/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.models.obj.ObjLoader;
import org.newdawn.render.models.obj.ObjModel;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.Block;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.util.Log;

public class Switch
extends MapElement {
    public static final int RED = 1;
    public static final int BLUE = 2;
    private static Sound click;
    private static ObjModel model;
    private static Texture blueTexture;
    private static Texture blueTextureOn;
    private static Texture redTexture;
    private static Texture redTextureOn;
    private static Texture particle;
    private Shape bounds;
    private float rad = 0.4f;
    private float top = 0.6f;
    private float bottom = 0.0f;
    private float x;
    private float y;
    private Map map;
    private boolean pressed;
    private Texture texture;
    private Texture textureOn;
    private Body body;
    private int type;
    private ArrayList blocks = new ArrayList();

    static void init() throws IOException {
        click = SoundStore.get().getOgg("res/sounds/switchclick2.ogg");
        model = ObjLoader.loadObj((String)"res/switch.obj");
        blueTexture = TextureLoader.get().getTextureLinear("res/blueswitch.tga");
        blueTextureOn = TextureLoader.get().getTextureLinear("res/blueswitch-on.tga");
        redTexture = TextureLoader.get().getTextureLinear("res/redswitch.tga");
        redTextureOn = TextureLoader.get().getTextureLinear("res/redswitch-on.tga");
        particle = TextureLoader.get().getTextureLinear("res/particle1.tga");
    }

    public Switch(Map map, float x, float y, int type) throws IOException {
        this.x = x;
        this.y = y;
        this.map = map;
        this.type = type;
        String typeName = "";
        if (type == 1) {
            typeName = "red";
            this.texture = redTexture;
            this.textureOn = redTextureOn;
        }
        if (type == 2) {
            typeName = "blue";
            this.texture = blueTexture;
            this.textureOn = blueTextureOn;
        }
        this.bounds = new Circle(x, y, this.rad);
        this.body = new Body(this.bounds);
    }

    public Body getBody() {
        return this.body;
    }

    public void createImpl() {
    }

    public void destroy() {
    }

    public Shape getShape() {
        return this.bounds;
    }

    public void renderImpl(int delta, boolean reflection) {
        Texture.bindNone();
        if (reflection) {
            if (!this.pressed) {
                GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
                model.render();
                GL11.glTranslatef((float)(-this.x), (float)(-this.y), (float)0.0f);
            }
            return;
        }
        float size = 1.0f;
        GL11.glEnable((int)3042);
        if (!this.pressed) {
            this.texture.bind();
            GL11.glColor4f((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
        } else {
            particle.bind();
            if (this.type == 1) {
                GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.8f);
            }
            if (this.type == 2) {
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)1.0f, (float)0.8f);
            }
            GL11.glBegin((int)7);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.x - size), (float)(this.y - size), (float)0.01f);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.x + size), (float)(this.y - size), (float)0.01f);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.x + size), (float)(this.y + size), (float)0.01f);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.x - size), (float)(this.y + size), (float)0.01f);
            GL11.glEnd();
            GL11.glBlendFunc((int)1, (int)771);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.textureOn.bind();
        }
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        model.render();
        GL11.glTranslatef((float)(-this.x), (float)(-this.y), (float)0.0f);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3042);
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
    }

    public boolean hit(Ball ball, float depth) {
        if (!this.pressed) {
            this.pressed = true;
            click.playAsSoundEffect(0.7f, 0.8f);
            this.map.getElements(Block.class, this.blocks);
            for (int i = 0; i < this.blocks.size(); ++i) {
                Block block = (Block)this.blocks.get(i);
                if (block.getType() == 3 && this.type == 1) {
                    block.setTargetZ(2.0f);
                }
                if (block.getType() != 4 || this.type != 2) continue;
                block.setTargetZ(2.0f);
            }
        }
        return false;
    }

    public MapElement copy(Map map) {
        try {
            return new Switch(map, this.x, this.y, this.type);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }
}

