/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.util.StringTokenizer;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.models.obj.ObjLoader;
import org.newdawn.render.models.obj.ObjModel;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.util.Log;

public class Stud
extends MapElement {
    private static Texture texture;
    private static ObjModel model;
    private Circle bounds;
    private float x;
    private float y;
    private int list;
    private Body body;
    private Map map;
    private String id;
    private float rad = 0.4f;

    public static void init() throws IOException {
        texture = TextureLoader.get().getTextureLinear("res/metal.tga");
        model = ObjLoader.loadObj((String)"res/ball.obj");
    }

    public Stud(Map map, float x, float y, String id) throws IOException {
        StringTokenizer tokens = new StringTokenizer(id, ",");
        tokens.nextToken();
        if (tokens.hasMoreTokens()) {
            this.rad = Float.parseFloat(tokens.nextToken());
        }
        this.bounds = new Circle(x, y, this.rad);
        this.x = x;
        this.y = y;
        this.map = map;
        this.id = id;
        this.body = new Body(this.bounds);
    }

    public Body getBody() {
        return this.body;
    }

    public void createImpl() {
    }

    public void destroy() {
    }

    public Shape getShape() {
        return this.bounds;
    }

    public void renderImpl(int delta, boolean reflection) {
        float scale;
        texture.bind();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        if (this.rad != 0.4f) {
            scale = this.rad / 0.4f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
        }
        model.render();
        if (this.rad != 0.4f) {
            scale = this.rad / 0.4f;
            GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        }
        GL11.glTranslatef((float)(-this.x), (float)(-this.y), (float)0.0f);
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
    }

    public boolean hit(Ball other, float depth) {
        return false;
    }

    public MapElement copy(Map map) {
        try {
            return new Stud(map, this.x, this.y, this.id);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }
}

