/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.render.util.Color;
import org.newdawn.render.window.LWJGLWindow;
import org.newdawn.state.GameState;
import org.newdawn.state.StateBasedGame;
import org.newdawn.state.transitions.FadeInTransition;
import org.newdawn.state.transitions.FadeOutTransition;
import org.newdawn.state.transitions.Transition;

public class SplashState
implements GameState {
    public static final int ID = 10;
    private LWJGLWindow window;
    private Texture logo;
    private int dawnTimeout = 100;
    private float fade;
    private float rot = 0.0f;
    private float finFade;
    private int timeout;

    public SplashState(LWJGLWindow window) {
        this.window = window;
    }

    public void init(StateBasedGame game) throws IOException {
        this.logo = TextureLoader.get().getTextureLinear("res/nd-splash.tga");
    }

    private void renderRectangle(float x, float y, float width, float height, float alpha) {
        GL11.glBegin((int)7);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glEnd();
    }

    public void reinit(StateBasedGame game) throws IOException {
    }

    public void render(StateBasedGame game, int delta) {
        this.window.enterOrtho(600, 600);
        int xp = (this.window.getWidth() - 600) / 2;
        int yp = (this.window.getHeight() - 600) / 2;
        Texture.bindNone();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.renderRectangle(-xp, -yp, 601 + xp * 2, 601 + yp * 2, 1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.logo.bind();
        this.renderRectangle(190.0f, 140.0f, 256.0f, 512.0f, 1.0f);
        Texture.bindNone();
        this.renderRectangle(0.0f, 0.0f, 600.0f, 358.0f, 1.0f - this.rot);
        this.renderRectangle(0.0f, 358.0f, 600.0f, 600.0f, 1.0f - this.fade);
        this.renderRectangle(0.0f, 0.0f, 600.0f, 600.0f, this.finFade);
        this.window.leaveOrtho();
    }

    public void update(StateBasedGame game, int delta) {
        if (this.rot >= 1.0f) {
            this.fade += 0.001f * (float)delta;
            if (this.fade > 1.0f) {
                this.fade = 1.0f;
            }
        }
        this.rot += 0.001f * (float)delta;
        if (this.rot > 1.0f) {
            this.rot = 1.0f;
        }
        if (this.fade >= 1.0f) {
            this.timeout += delta;
            if (this.timeout > 1500) {
                this.finFade += 0.001f * (float)delta;
                if (this.finFade >= 1.0f) {
                    this.finFade = 1.0f;
                    game.changeToState(2, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
                }
            }
        }
    }

    public void enterState(StateBasedGame game) {
        this.fade = 0.0f;
    }

    public void leaveState(StateBasedGame game) {
    }
}

