/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.models.obj.ObjLoader;
import org.newdawn.render.models.obj.ObjModel;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.AABox;
import org.newdawn.tilt.geom.CollisionResult;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.util.Log;

public class Spikes
extends MapElement {
    private static ObjModel model;
    private static ObjModel model2;
    private static final float LIFE = 500.0f;
    private static Texture texture;
    private static Sound snap;
    private float x;
    private float y;
    private String data;
    private Map map;
    private Body body;
    private Body bodyOut;
    private float tx;
    private float ty;
    private boolean blast;
    private int id;
    private GlobalEmitter emitter;
    private boolean init;
    private boolean created;
    private boolean off = true;
    private Shape blockBounds;
    private AABox outerBounds;
    private float ang;
    private boolean spikesOut;
    private int timer;
    private CollisionResult result = new CollisionResult();
    private ArrayList balls = new ArrayList();

    public static void init() throws IOException {
        snap = SoundStore.get().getOgg("res/sounds/snap.ogg");
        model = ObjLoader.loadObj((String)"res/spikes.obj");
        model2 = ObjLoader.loadObj((String)"res/spikesin.obj");
        texture = TextureLoader.get().getTextureLinear("res/metal.tga");
    }

    public Spikes(Map map, float x, float y, String data) throws IOException {
        this.x = x;
        this.y = y;
        this.data = data;
        this.map = map;
        this.ang = 0.0f;
        StringTokenizer tokens = new StringTokenizer(data, ",");
        tokens.nextToken();
        if (tokens.hasMoreTokens()) {
            this.ang = Float.parseFloat(tokens.nextToken());
        }
        if (tokens.hasMoreTokens()) {
            this.timer = Integer.parseInt(tokens.nextToken());
        }
        this.blockBounds = new AABox(x - 0.3f, y - 0.3f, 0.6f, 0.6f);
        if (this.ang == 0.0f) {
            this.outerBounds = new AABox(x + 0.3f, y - 0.2f, 0.6f, 0.4f);
        }
        if (this.ang == 180.0f) {
            this.outerBounds = new AABox(x - 0.9f, y - 0.2f, 0.6f, 0.4f);
        }
        if (this.ang == 90.0f) {
            this.outerBounds = new AABox(x - 0.2f, y + 0.3f, 0.4f, 0.6f);
        }
        if (this.ang == 270.0f) {
            this.outerBounds = new AABox(x - 0.2f, y - 0.9f, 0.4f, 0.6f);
        }
        this.body = new Body(this.blockBounds);
        this.bodyOut = new Body(this.outerBounds);
        map.addBody(this.bodyOut, this);
        this.bodyOut.setActive(false);
    }

    public Body getBody() {
        return this.body;
    }

    public Shape getShape() {
        return this.body.getShape();
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int getID() {
        return this.id;
    }

    public void createImpl() {
    }

    public void destroy() {
    }

    public void renderImpl(int delta, boolean reflection) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        GL11.glRotatef((float)this.ang, (float)0.0f, (float)0.0f, (float)1.0f);
        if (this.spikesOut) {
            Map.render(texture, model, null, !reflection, 1.03f);
        } else {
            Map.render(texture, model2, null, !reflection, 1.03f);
        }
        GL11.glPopMatrix();
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
        boolean justOut = false;
        this.timer -= delta;
        if (this.timer < 0) {
            snap.playAsSoundEffect(2.0f, 0.5f);
            this.spikesOut = !this.spikesOut;
            this.timer = 1500;
            justOut = this.spikesOut;
            this.bodyOut.setActive(this.spikesOut);
        }
        if (justOut) {
            this.map.getElements(Ball.class, this.balls);
            for (int i = 0; i < this.balls.size(); ++i) {
                Ball ball = (Ball)this.balls.get(i);
                this.result.missed();
                this.outerBounds.collides(0.0f, 0.0f, ball.getShape(), false, this.result);
                if (!this.result.collided()) continue;
                ball.pop();
            }
        }
    }

    public boolean hit(Ball ball, float depth) {
        return false;
    }

    public MapElement copy(Map map) {
        try {
            return new Spikes(map, this.x, this.y, this.data);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public boolean finished() {
        return false;
    }
}

