/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.util.StringTokenizer;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.models.obj.ObjLoader;
import org.newdawn.render.models.obj.ObjModel;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;

public class ShrinkToken
extends MapElement {
    private static ObjModel model;
    private static Sound collect;
    private static Texture texture;
    private Circle bounds;
    private float x;
    private float y;
    private float zrot;
    private Map map;
    private Body body;
    private int effectLength = 10000;

    public static void init() throws IOException {
        model = ObjLoader.loadObj((String)"res/shrink.obj");
        collect = SoundStore.get().getOgg("res/sounds/shrink.ogg");
        texture = TextureLoader.get().getTextureLinear("res/shrink.tga");
    }

    public ShrinkToken(Map map, float x, float y, String id) {
        this.bounds = new Circle(x, y, 0.4f);
        this.x = x;
        this.y = y;
        this.zrot = (float)(Math.random() * 30.0);
        this.map = map;
        this.body = new Body(this.bounds);
        StringTokenizer tokens = new StringTokenizer(id, ",");
        tokens.nextToken();
        if (tokens.hasMoreTokens()) {
            this.effectLength = Integer.parseInt(tokens.nextToken());
        }
    }

    public Body getBody() {
        return this.body;
    }

    public void createImpl() {
    }

    public void destroy() {
    }

    public Shape getShape() {
        return this.bounds;
    }

    public void renderImpl(int delta, boolean reflection) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.5f);
        GL11.glRotatef((float)this.zrot, (float)0.0f, (float)0.0f, (float)1.0f);
        Map.render(texture, model, null, !reflection);
        GL11.glPopMatrix();
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
        this.zrot += (float)delta * 0.1f;
    }

    public boolean hit(Ball ball, float depth) {
        collect.playAsSoundEffect(1.0f, 1.0f);
        this.map.removeItem(this);
        ball.shrink(this.effectLength);
        return true;
    }

    public MapElement copy(Map map) {
        return new ShrinkToken(map, this.x, this.y, "shrink," + this.effectLength);
    }
}

