/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.render.util.Color;
import org.newdawn.render.window.LWJGLWindow;
import org.newdawn.state.GameState;
import org.newdawn.state.StateBasedGame;
import org.newdawn.state.transitions.FadeInTransition;
import org.newdawn.state.transitions.FadeOutTransition;
import org.newdawn.state.transitions.Transition;
import org.newdawn.tilt.MouseOverArea;
import org.newdawn.tilt.MouseOverGroup;
import org.newdawn.tilt.SharedUI;
import org.newdawn.tilt.TiltController;

public class SettingsState
implements GameState {
    public static final int ID = 7;
    private LWJGLWindow window;
    private Texture title;
    private Texture check;
    private Texture uncheck;
    private Texture back;
    private Texture controls;
    private Texture video;
    private Texture audio;
    private MouseOverArea backArea;
    private MouseOverArea controlsArea;
    private MouseOverArea videoArea;
    private MouseOverArea audioArea;
    private MouseOverGroup group;
    private int selected;
    private Color gray = new Color(0.0f, 0.0f, 0.0f, 0.5f);

    public SettingsState(LWJGLWindow window) {
        this.window = window;
    }

    private void renderRectangle(float x, float y, float width, float height) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glEnd();
    }

    public void init(StateBasedGame game) throws IOException {
        this.title = TextureLoader.get().getTextureLinear("res/settings.tga");
        this.back = TextureLoader.get().getTextureLinear("res/backtomenu.tga");
        this.check = TextureLoader.get().getTextureLinear("res/check.tga");
        this.uncheck = TextureLoader.get().getTextureLinear("res/uncheck.tga");
        this.controls = TextureLoader.get().getTextureLinear("res/controlssetup.tga");
        this.video = TextureLoader.get().getTextureLinear("res/displaysetup.tga");
        this.audio = TextureLoader.get().getTextureLinear("res/audiosetup.tga");
        this.backArea = new MouseOverArea(this.window, 200.0f, 540.0f, 200.0f, 50.0f);
        this.videoArea = new MouseOverArea(this.window, 180.0f, 140.0f, 240.0f, 50.0f);
        this.audioArea = new MouseOverArea(this.window, 180.0f, 235.0f, 240.0f, 50.0f);
        this.controlsArea = new MouseOverArea(this.window, 180.0f, 320.0f, 240.0f, 50.0f);
        this.group = new MouseOverGroup("settings");
        this.group.addArea(this.videoArea);
        this.group.addArea(this.audioArea);
        this.group.addArea(this.controlsArea);
        this.group.addArea(this.backArea);
    }

    public void reinit(StateBasedGame game) throws IOException {
    }

    public void render(StateBasedGame game, int delta) {
        this.window.enterOrtho(600, 600);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.title.bind();
        this.renderRectangle(174.0f, -15.0f, 256.0f, 128.0f);
        float col = 0.75f + this.backArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.back.bind();
        this.renderRectangle(174.0f, 540.0f, 256.0f, 64.0f);
        col = 0.75f + this.videoArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.video.bind();
        this.renderRectangle(174.0f, 150.0f, 256.0f, 128.0f);
        col = 0.75f + this.audioArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.audio.bind();
        this.renderRectangle(174.0f, 215.0f, 256.0f, 128.0f);
        col = 0.75f + this.controlsArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.controls.bind();
        this.renderRectangle(174.0f, 300.0f, 256.0f, 128.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        this.window.leaveOrtho();
    }

    private void drawString(int y, String text) {
        int x = (600 - SharedUI.smallFontO.getWidth(text)) / 2;
        SharedUI.smallFontO.drawString(x + 3, y + 3, text, this.gray);
        SharedUI.smallFontO.drawString(x, y, text, Color.white);
    }

    public void update(StateBasedGame game, int delta) {
        int oldSelected = this.selected;
        this.selected = 0;
        if (this.backArea.considerMouse(delta)) {
            this.selected = 1;
        }
        if (this.videoArea.considerMouse(delta)) {
            this.selected = 2;
        }
        if (this.audioArea.considerMouse(delta)) {
            this.selected = 3;
        }
        if (this.controlsArea.considerMouse(delta)) {
            this.selected = 4;
        }
        if (oldSelected != this.selected && this.selected != 0) {
            SharedUI.playOver();
        }
        this.group.update();
        if (TiltController.buttonPressed()) {
            this.selectOption(game);
        }
        while (Mouse.next()) {
            if (Mouse.getEventButton() < 0 || !Mouse.getEventButtonState()) continue;
            this.selectOption(game);
        }
    }

    private void selectOption(StateBasedGame game) {
        if (this.selected == 1) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            game.changeToState(2, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
            return;
        }
        if (this.selected == 2) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            game.changeToState(22, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
            return;
        }
        if (this.selected == 3) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            game.changeToState(23, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
            return;
        }
        if (this.selected == 4) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            game.changeToState(21, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
            return;
        }
    }

    public void enterState(StateBasedGame game) {
        Mouse.setGrabbed((boolean)false);
        this.group.reset();
    }

    public void leaveState(StateBasedGame game) {
    }
}

