/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.AABox;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.util.Log;

public class Roof
extends MapElement {
    private static Texture crate;
    private AABox box;
    private AABox hitarea;
    private Texture texture;
    private float h;
    private int list;
    private Body body;
    private Map map;

    public static void init() throws IOException {
        crate = TextureLoader.get().getTextureLinear("res/crate.tga");
    }

    public Roof(Map map, float x, float y, float width, float height, float h) throws IOException {
        this.box = new AABox(x, y, width, height);
        this.hitarea = new AABox(10000.0f, 10000.0f, 0.0f, 0.0f);
        this.map = map;
        this.h = h;
        this.texture = crate;
        this.body = new Body(this.box);
    }

    public void createImpl() {
        this.list = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.list, (int)4864);
        this.renderBox(this.box, this.h);
        GL11.glEndList();
    }

    public void destroy() {
        GL11.glDeleteLists((int)this.list, (int)1);
    }

    public Shape getShape() {
        return this.hitarea;
    }

    public void renderBox(AABox box, float h) {
        float top = 0.9f;
        float scaleu = 1.0f / box.getWidth();
        float scalev = 1.0f / box.getHeight();
        float scalez = 0.5f / h;
        GL11.glBegin((int)7);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)box.getX(), (float)box.getY(), (float)(top + h));
        GL11.glTexCoord2f((float)(box.getWidth() * scaleu), (float)0.0f);
        GL11.glVertex3f((float)box.getX2(), (float)box.getY(), (float)(top + h));
        GL11.glTexCoord2f((float)(box.getWidth() * scaleu), (float)(box.getHeight() * scalev));
        GL11.glVertex3f((float)box.getX2(), (float)box.getY2(), (float)(top + h));
        GL11.glTexCoord2f((float)0.0f, (float)(box.getHeight() * scalev));
        GL11.glVertex3f((float)box.getX(), (float)box.getY2(), (float)(top + h));
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)box.getX(), (float)box.getY(), (float)top);
        GL11.glTexCoord2f((float)0.0f, (float)(box.getHeight() * scalev));
        GL11.glVertex3f((float)box.getX(), (float)box.getY2(), (float)top);
        GL11.glTexCoord2f((float)(box.getWidth() * scaleu), (float)(box.getHeight() * scalev));
        GL11.glVertex3f((float)box.getX2(), (float)box.getY2(), (float)top);
        GL11.glTexCoord2f((float)(box.getWidth() * scaleu), (float)0.0f);
        GL11.glVertex3f((float)box.getX2(), (float)box.getY(), (float)top);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)((box.getX() + 1.0f) * scaleu), (float)(h * scalez));
        GL11.glVertex3f((float)box.getX(), (float)box.getY(), (float)(top + h));
        GL11.glTexCoord2f((float)((box.getX() + 1.0f) * scaleu), (float)0.0f);
        GL11.glVertex3f((float)box.getX(), (float)box.getY(), (float)top);
        GL11.glTexCoord2f((float)((box.getX2() + 1.0f) * scaleu), (float)0.0f);
        GL11.glVertex3f((float)box.getX2(), (float)box.getY(), (float)top);
        GL11.glTexCoord2f((float)((box.getX2() + 1.0f) * scaleu), (float)(h * scalez));
        GL11.glVertex3f((float)box.getX2(), (float)box.getY(), (float)(top + h));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)((box.getX() + 1.0f) * scaleu), (float)(h * scalez));
        GL11.glVertex3f((float)box.getX(), (float)box.getY2(), (float)(top + h));
        GL11.glTexCoord2f((float)((box.getX2() + 1.0f) * scaleu), (float)(h * scalez));
        GL11.glVertex3f((float)box.getX2(), (float)box.getY2(), (float)(top + h));
        GL11.glTexCoord2f((float)((box.getX2() + 1.0f) * scaleu), (float)0.0f);
        GL11.glVertex3f((float)box.getX2(), (float)box.getY2(), (float)top);
        GL11.glTexCoord2f((float)((box.getX() + 1.0f) * scaleu), (float)0.0f);
        GL11.glVertex3f((float)box.getX(), (float)box.getY2(), (float)top);
        GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)((box.getY() + 1.0f) * scalev), (float)(h * scalez));
        GL11.glVertex3f((float)box.getX(), (float)box.getY(), (float)(top + h));
        GL11.glTexCoord2f((float)((box.getY2() + 1.0f) * scalev), (float)(h * scalez));
        GL11.glVertex3f((float)box.getX(), (float)box.getY2(), (float)(top + h));
        GL11.glTexCoord2f((float)((box.getY2() + 1.0f) * scalev), (float)0.0f);
        GL11.glVertex3f((float)box.getX(), (float)box.getY2(), (float)top);
        GL11.glTexCoord2f((float)((box.getY() + 1.0f) * scalev), (float)0.0f);
        GL11.glVertex3f((float)box.getX(), (float)box.getY(), (float)top);
        GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)((box.getY() + 1.0f) * scalev), (float)(h * scalez));
        GL11.glVertex3f((float)box.getX2(), (float)box.getY(), (float)(top + h));
        GL11.glTexCoord2f((float)((box.getY() + 1.0f) * scalev), (float)0.0f);
        GL11.glVertex3f((float)box.getX2(), (float)box.getY(), (float)top);
        GL11.glTexCoord2f((float)((box.getY2() + 1.0f) * scalev), (float)0.0f);
        GL11.glVertex3f((float)box.getX2(), (float)box.getY2(), (float)top);
        GL11.glTexCoord2f((float)((box.getY2() + 1.0f) * scalev), (float)(h * scalez));
        GL11.glVertex3f((float)box.getX2(), (float)box.getY2(), (float)(top + h));
        GL11.glEnd();
    }

    public void renderImpl(int delta, boolean reflection) {
        this.texture.bind();
        GL11.glCallList((int)this.list);
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
    }

    public boolean hit(Ball other, float depth) {
        return false;
    }

    public MapElement copy(Map map) {
        try {
            return new Roof(map, this.box.getX(), this.box.getY(), this.box.getWidth(), this.box.getHeight(), this.h);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public Body getBody() {
        return null;
    }
}

