/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.util.StringTokenizer;
import org.lwjgl.Sys;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.newdawn.glui.components.Component;
import org.newdawn.glui.components.ComponentListener;
import org.newdawn.glui.components.Panel;
import org.newdawn.glui.components.RelativeLayout;
import org.newdawn.glui.components.Screen;
import org.newdawn.glui.components.TextField;
import org.newdawn.glui.font.Font;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.render.util.Color;
import org.newdawn.render.window.LWJGLWindow;
import org.newdawn.state.GameState;
import org.newdawn.state.StateBasedGame;
import org.newdawn.state.transitions.FadeInTransition;
import org.newdawn.state.transitions.FadeOutTransition;
import org.newdawn.state.transitions.Transition;
import org.newdawn.tilt.Configuration;
import org.newdawn.tilt.MouseOverArea;
import org.newdawn.tilt.MouseOverGroup;
import org.newdawn.tilt.SharedUI;
import org.newdawn.tilt.TiltController;
import org.newdawn.tilt.reg.PostConnection;
import org.newdawn.tilt.reg.PostListener;
import org.newdawn.tilt.util.FastTrig;

public class RegisterState
implements GameState,
PostListener {
    public static final int ID = 67;
    private static String AUTH_URL = "http://www.tiltilation.com/register.php";
    private static String BUY_URL = "http://www.tiltilation.com/buy.php";
    private LWJGLWindow window;
    private Texture title;
    private Texture check;
    private Texture uncheck;
    private Texture back;
    private Texture getKey;
    private Texture enterKey;
    private Texture okKey;
    private Texture paste;
    private MouseOverArea backArea;
    private MouseOverArea getKeyArea;
    private MouseOverArea okKeyArea;
    private MouseOverArea pasteArea;
    private MouseOverGroup group;
    private int selected;
    private RegTextField field1;
    private RegTextField field2;
    private RegTextField field3;
    private RegTextField field4;
    private Screen screen;
    private boolean r;
    private boolean g;
    private String register;
    private String message;
    private float ang;
    private boolean failed;
    private String n;
    private String m;
    private String k;
    private Color gray = new Color(0.0f, 0.0f, 0.0f, 0.4f);

    public RegisterState(LWJGLWindow window) {
        this.window = window;
    }

    private void renderRectangle(float x, float y, float width, float height) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glEnd();
    }

    public void init(StateBasedGame game) throws IOException {
        this.title = TextureLoader.get().getTextureLinear("res/register.tga");
        this.back = TextureLoader.get().getTextureLinear("res/backtomenu.tga");
        this.check = TextureLoader.get().getTextureLinear("res/check.tga");
        this.uncheck = TextureLoader.get().getTextureLinear("res/uncheck.tga");
        this.getKey = TextureLoader.get().getTextureLinear("res/getkey.tga");
        this.enterKey = TextureLoader.get().getTextureLinear("res/enterkey.tga");
        this.okKey = TextureLoader.get().getTextureLinear("res/ok.tga");
        this.paste = TextureLoader.get().getTextureLinear("res/paste.tga");
        this.backArea = new MouseOverArea(this.window, 200.0f, 540.0f, 200.0f, 50.0f);
        this.okKeyArea = new MouseOverArea(this.window, 430.0f, 420.0f, 200.0f, 60.0f);
        this.pasteArea = new MouseOverArea(this.window, 30.0f, 420.0f, 200.0f, 80.0f);
        this.getKeyArea = new MouseOverArea(this.window, 140.0f, 150.0f, 300.0f, 50.0f);
        this.group = new MouseOverGroup("settings");
        this.group.addArea(this.getKeyArea);
        this.group.addArea(this.pasteArea);
        this.group.addArea(this.okKeyArea);
        this.group.addArea(this.backArea);
        this.createGUI();
    }

    public void createGUI() {
        this.screen = new Screen(this.window, (Font)SharedUI.fixedBigFontO);
        Panel panel = new Panel(this.screen, 600, 600);
        this.screen.add((Component)panel, RelativeLayout.CENTER, 0, 0);
        this.field4 = new RegTextField(4, 4, null);
        this.field4.setPadding(3, 1);
        this.field4.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        this.field4.setBorder(new Color(0.0f, 0.0f, 0.0f, 1.0f));
        this.field3 = new RegTextField(4, 4, this.field4);
        this.field3.setPadding(3, 1);
        this.field3.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        this.field3.setBorder(new Color(0.0f, 0.0f, 0.0f, 1.0f));
        this.field2 = new RegTextField(4, 4, this.field3);
        this.field2.setPadding(3, 1);
        this.field2.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        this.field2.setBorder(new Color(0.0f, 0.0f, 0.0f, 1.0f));
        this.field1 = new RegTextField(4, 4, this.field2);
        this.field1.setPadding(3, 1);
        this.field1.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        this.field1.setBorder(new Color(0.0f, 0.0f, 0.0f, 1.0f));
        panel.add((Component)this.field1, RelativeLayout.TOP_LEFT, 70, 370);
        panel.add((Component)this.field2, RelativeLayout.TOP_LEFT, 190, 370);
        panel.add((Component)this.field3, RelativeLayout.TOP_LEFT, 310, 370);
        panel.add((Component)this.field4, RelativeLayout.TOP_LEFT, 430, 370);
        this.field4.addListener(new ComponentListener(){

            public void componentActivated(Component source) {
                RegisterState.this.activate();
            }
        });
    }

    public void activate() {
        this.k = this.field1.getText() + "-" + this.field2.getText() + "-" + this.field3.getText() + "-" + this.field4.getText();
        String id = Configuration.prefs.getString("id", "");
        this.g = true;
        this.message = "Registering..";
        PostConnection connection = new PostConnection(AUTH_URL, this);
        connection.addAttribute("key", this.k);
        connection.addAttribute("osname", System.getProperty("os.name"));
        connection.addAttribute("id", id);
        connection.post();
    }

    public void reinit(StateBasedGame game) throws IOException {
    }

    public void render(StateBasedGame game, int delta) {
        String text;
        float col;
        this.window.enterOrtho(600, 600);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.title.bind();
        this.renderRectangle(205.0f, 10.0f, 256.0f, 128.0f);
        if (!this.r && !this.g) {
            this.enterKey.bind();
            this.renderRectangle(125.0f, 280.0f, 512.0f, 128.0f);
            col = 0.75f + this.okKeyArea.getValue();
            GL11.glColor3f((float)col, (float)col, (float)col);
            this.okKey.bind();
            this.renderRectangle(430.0f, 420.0f, 256.0f, 64.0f);
            col = 0.75f + this.getKeyArea.getValue();
            GL11.glColor3f((float)col, (float)col, (float)col);
            this.getKey.bind();
            this.renderRectangle(145.0f, 150.0f, 512.0f, 128.0f);
            col = 0.75f + this.pasteArea.getValue();
            GL11.glColor3f((float)col, (float)col, (float)col);
            this.paste.bind();
            this.renderRectangle(30.0f, 410.0f, 256.0f, 128.0f);
        }
        if (this.g && !this.r) {
            text = this.message;
            int yp = (int)(FastTrig.sin(this.ang) * 15.0);
            int xp = (600 - SharedUI.bigFontO.getWidth(text)) / 2;
            SharedUI.bigFontO.drawString(xp + 3, 283 + yp, text, this.gray);
            SharedUI.bigFontO.drawString(xp, 280 + yp, text, Color.white);
        }
        if (this.r) {
            text = "Registered To";
            int xp = (600 - SharedUI.bigFontO.getWidth(text)) / 2;
            SharedUI.bigFontO.drawString(xp + 3, 203, text, this.gray);
            SharedUI.bigFontO.drawString(xp, 200, text, Color.white);
            text = this.n;
            xp = (600 - SharedUI.smallFontO.getWidth(text)) / 2;
            SharedUI.smallFontO.drawString(xp + 3, 273, text, this.gray);
            SharedUI.smallFontO.drawString(xp, 270, text, Color.white);
            text = this.m;
            xp = (600 - SharedUI.smallFontO.getWidth(text)) / 2;
            SharedUI.smallFontO.drawString(xp + 3, 303, text, this.gray);
            SharedUI.smallFontO.drawString(xp, 300, text, Color.white);
            text = this.k;
            xp = (600 - SharedUI.smallFontO.getWidth(text)) / 2;
            SharedUI.smallFontO.drawString(xp + 3, 333, text, this.gray);
            SharedUI.smallFontO.drawString(xp, 330, text, Color.white);
            text = "Thanks for your Support!";
            xp = (600 - SharedUI.bigFontO.getWidth(text)) / 2;
            SharedUI.bigFontO.drawString(xp + 3, 413, text, this.gray);
            SharedUI.bigFontO.drawString(xp, 410, text, Color.white);
        }
        col = 0.75f + this.backArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.back.bind();
        this.renderRectangle(185.0f, 540.0f, 256.0f, 64.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        this.window.leaveOrtho();
        if (!this.r && !this.g) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.screen.render(delta);
            GL11.glDisable((int)3042);
        }
    }

    private void drawString(int y, String text) {
        int x = (600 - SharedUI.smallFontO.getWidth(text)) / 2;
        SharedUI.smallFontO.drawString(x + 3, y + 3, text, this.gray);
        SharedUI.smallFontO.drawString(x, y, text, Color.white);
    }

    public void update(StateBasedGame game, int delta) {
        if (!this.failed) {
            this.ang += (float)delta * 0.005f;
        }
        int oldSelected = this.selected;
        this.selected = 0;
        boolean validKey = this.field1.getText().length() == 4;
        validKey &= this.field2.getText().length() == 4;
        validKey &= this.field3.getText().length() == 4;
        validKey &= this.field4.getText().length() == 4;
        if (this.backArea.considerMouse(delta)) {
            this.selected = 3;
        }
        if (!this.r && !this.g) {
            if (validKey && this.okKeyArea.considerMouse(delta)) {
                this.selected = 2;
            }
            if (this.getKeyArea.considerMouse(delta)) {
                this.selected = 1;
            }
            if (this.pasteArea.considerMouse(delta)) {
                this.selected = 10;
            }
        }
        if (oldSelected != this.selected && this.selected != 0) {
            SharedUI.playOver();
        }
        this.group.update();
        if (TiltController.buttonPressed()) {
            this.selectOption(game);
        }
        while (Mouse.next()) {
            if (Mouse.getEventButton() < 0 || !Mouse.getEventButtonState()) continue;
            this.selectOption(game);
        }
        if (!this.r && !this.g) {
            this.screen.update(delta);
        }
    }

    private boolean checkClipboard() {
        StringTokenizer tokens;
        String clip = Sys.getClipboard();
        if (clip == null) {
            return false;
        }
        if (!clip.equals("") && (tokens = new StringTokenizer(clip, "-")).countTokens() == 4) {
            String[] values = new String[4];
            for (int i = 0; i < 4; ++i) {
                String token = tokens.nextToken();
                try {
                    Integer.parseInt(token);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (token.length() != 4) {
                    return false;
                }
                values[i] = token;
            }
            this.field1.setText(values[0]);
            this.field2.setText(values[1]);
            this.field3.setText(values[2]);
            this.field4.setText(values[3]);
            this.screen.clearKeyFocus();
            return true;
        }
        return false;
    }

    private void selectOption(StateBasedGame game) {
        if (this.selected == 1) {
            Sys.openURL((String)BUY_URL);
            return;
        }
        if (this.selected == 2) {
            this.activate();
            return;
        }
        if (this.selected == 10 && !this.checkClipboard()) {
            SharedUI.dud.playAsSoundEffect(1.0f, 1.0f);
        }
        if (this.selected == 3) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            game.changeToState(2, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
            return;
        }
    }

    public void enterState(StateBasedGame game) {
        Mouse.setGrabbed((boolean)false);
        this.group.reset();
        this.screen.setKeyFocus((Component)this.field1);
        this.r = Configuration.prefs.data.get("r3") != null;
        this.g = false;
        this.k = Configuration.prefs.getString("r3", null);
        this.n = Configuration.prefs.getString("r1", null);
        this.m = Configuration.prefs.getString("r2", null);
        this.field1.setText("");
        this.field2.setText("");
        this.field3.setText("");
        this.field4.setText("");
    }

    public void leaveState(StateBasedGame game) {
    }

    public void failed() {
        this.failed = true;
        this.message = "Failed to Register";
    }

    public void reportLine(String line) {
        if (this.n == null) {
            this.n = line;
        } else if (this.m == null) {
            this.m = line;
        } else {
            this.r = true;
            Configuration.prefs.putString("r3", this.k);
            Configuration.prefs.putString("r1", this.n);
            Configuration.prefs.putString("r2", this.m);
            Configuration.prefs.putString("webname", line);
            Configuration.prefs.save();
        }
        this.message = "Success!";
    }

    public class RegTextField
    extends TextField {
        private RegTextField next;

        public RegTextField(int visibleLength, int totalLength, RegTextField next) {
            super(visibleLength, totalLength);
            this.next = next;
        }

        public boolean validateCharacter(char c) {
            if (!Character.isDigit(c)) {
                return false;
            }
            boolean result = super.validateCharacter(c);
            if (result && this.getText().length() == 3 && this.next != null) {
                RegisterState.this.screen.setKeyFocus((Component)this.next);
            }
            return result;
        }
    }
}

