/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.newdawn.util.Log;

public class Prefs {
    public HashMap data = new HashMap();
    private File file;
    public static File levels;
    public static File score;
    public static File time;
    public static File test;
    private HashMap longs = new HashMap();
    private HashMap floats = new HashMap();
    private HashMap integers = new HashMap();

    public Prefs() {
        this.file = new File(System.getProperty("user.home"));
        this.file = new File(this.file, ".tiltilation");
        this.file.mkdirs();
        levels = this.file = new File(this.file, "userdat.dat");
        score = this.file;
        time = this.file;
        test = this.file;
        this.load();
        if (this.getLong("id", 0L) == 0L) {
            this.putLong("id", this.file.getAbsolutePath().hashCode());
        }
        if (this.getLong("id", 0L) != (long)this.file.getAbsolutePath().hashCode()) {
            Log.log((String)"Removing 1");
            this.data.remove("r1");
            this.data.remove("r2");
            this.save();
            this.data.remove("r3");
            this.save();
            System.exit(0);
        }
    }

    public void save() {
        try {
            FileOutputStream fout = new FileOutputStream(this.file);
            DataOutputStream dout = new DataOutputStream(fout);
            dout.writeInt(this.data.keySet().size());
            Iterator keys = this.data.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                dout.writeUTF(this.encode(key));
                dout.writeUTF(this.encode((String)this.data.get(key)));
            }
            dout.close();
            fout.close();
        }
        catch (IOException e) {
            Log.log((String)"Failed to save configuration.");
            Log.log((Throwable)e);
        }
    }

    public void load() {
        this.longs.clear();
        this.floats.clear();
        this.integers.clear();
        try {
            FileInputStream fin = new FileInputStream(this.file);
            DataInputStream din = new DataInputStream(fin);
            int size = din.readInt();
            for (int i = 0; i < size; ++i) {
                String key = din.readUTF();
                String value = din.readUTF();
                this.data.put(this.decode(key), this.decode(value));
            }
            din.close();
            fin.close();
        }
        catch (FileNotFoundException e) {
            Log.log((String)"No configuration - creating empty");
            this.save();
        }
        catch (IOException e) {
            Log.log((String)"Failed to load configuration.");
            Log.log((Throwable)e);
        }
    }

    public void putInt(String key, int value) {
        this.data.put(key, "" + value);
        this.save();
        this.integers.put(key, new Integer(value));
    }

    public void putLong(String key, long value) {
        this.data.put(key, "" + value);
        this.save();
        this.longs.put(key, new Long(value));
    }

    public void putFloat(String key, float value) {
        this.data.put(key, "" + value);
        this.save();
        this.floats.put(key, new Float(value));
    }

    public void putString(String key, String value) {
        this.data.put(key, value);
        this.save();
    }

    public String getString(String key, String def) {
        String value = (String)this.data.get(key);
        if (value == null) {
            return def;
        }
        return value;
    }

    public int getInt(String key, int def) {
        Integer temp = (Integer)this.integers.get(key);
        if (temp == null) {
            String result = (String)this.data.get(key);
            if (result == null) {
                return def;
            }
            temp = Integer.valueOf(result);
            this.integers.put(key, temp);
        }
        return temp;
    }

    public long getLong(String key, long def) {
        Long temp = (Long)this.longs.get(key);
        if (temp == null) {
            String result = (String)this.data.get(key);
            if (result == null) {
                return def;
            }
            temp = Long.valueOf(result);
            this.longs.put(key, temp);
        }
        return temp;
    }

    public float getFloat(String key, float def) {
        Float temp = (Float)this.floats.get(key);
        if (temp == null) {
            String result = (String)this.data.get(key);
            if (result == null) {
                return def;
            }
            temp = Float.valueOf(result);
            this.floats.put(key, temp);
        }
        return temp.floatValue();
    }

    public String encode(String str) {
        String result = "";
        for (int i = 0; i < str.length(); ++i) {
            result = result + (char)(str.charAt(i) + 10);
        }
        return result;
    }

    public String decode(String str) {
        String result = "";
        for (int i = 0; i < str.length(); ++i) {
            result = result + (char)(str.charAt(i) - 10);
        }
        return result;
    }
}

