/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.models.obj.ObjLoader;
import org.newdawn.render.models.obj.ObjModel;
import org.newdawn.render.particles.ParticleEngine;
import org.newdawn.render.texture.Texture;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.effect.ParticleEffect;
import org.newdawn.tilt.effect.ParticleProvider;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.tilt.util.FastTrig;
import org.newdawn.util.Log;

public class PowerPill
extends MapElement
implements ParticleEffect {
    private static ObjModel model;
    private static Sound collect;
    private Circle bounds;
    private float x;
    private float y;
    private int list;
    private Body body;
    private Map map;
    private String id;
    private float rad = 0.25f;
    private boolean done;
    private GlobalEmitter emitter;

    public static void init() throws IOException {
        collect = SoundStore.get().getOgg("res/sounds/collect.ogg");
        model = ObjLoader.loadObj((String)"res/ball.obj");
    }

    public PowerPill(Map map, float x, float y, String id) throws IOException {
        this.bounds = new Circle(x, y, this.rad);
        this.x = x;
        this.y = y;
        this.map = map;
        this.id = id;
        this.body = new Body(this.bounds);
    }

    public Body getBody() {
        return this.body;
    }

    public void createImpl() {
    }

    public void destroy() {
    }

    public Shape getShape() {
        return this.bounds;
    }

    public void renderImpl(int delta, boolean reflection) {
        Texture.bindNone();
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.4f);
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.4f);
        float scale = this.rad / 0.4f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        model.render();
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        GL11.glTranslatef((float)(-this.x), (float)(-this.y), (float)-0.4f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
        if (this.emitter == null) {
            this.emitter = emitter;
            emitter.addEffect(this);
        }
    }

    public boolean hit(Ball other, float depth) {
        other.powerOn();
        this.map.removeItem(this);
        collect.playAsSoundEffect(1.5f, 1.0f);
        this.done = true;
        return true;
    }

    public MapElement copy(Map map) {
        try {
            return new PowerPill(map, this.x, this.y, this.id);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public void update(ParticleProvider provider, ParticleEngine engine, int delta) {
        for (int i = 0; i < 1; ++i) {
            int p = provider.getParticle(this, 600);
            if (p == -1) continue;
            float ang = (float)(Math.random() * Math.PI * 2.0);
            float rad = (float)Math.random() * 0.3f;
            float x = this.bounds.getX() + (float)(FastTrig.cos(ang) * (double)rad);
            float y = this.bounds.getY() + (float)(FastTrig.sin(ang) * (double)rad);
            engine.setPos(p, x, y, (float)(Math.random() * (double)0.35f));
            engine.setSize(p, 0.06f);
            engine.setColor(p, 1.0f, 1.0f, 1.0f, 1.0f);
            engine.setVelocity(p, 0.0f, 0.0f, 1.0f);
        }
    }

    public void updateParticle(int index, int delta, ParticleEngine engine, int life) {
        engine.adjustColor(index, 0.0f, 0.0f, -0.05f, -0.01f);
    }

    public boolean finished() {
        return this.done;
    }
}

