/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.models.obj.ObjLoader;
import org.newdawn.render.models.obj.ObjModel;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.util.Log;

public class Peg
extends MapElement {
    private static ObjModel model;
    private static final float LIFE = 500.0f;
    private static Texture metal;
    private static Texture redwall;
    private static Texture bluewall;
    private static Texture yellowwall;
    private float x;
    private float y;
    private String data;
    private Map map;
    private Body body;
    private int id;
    private Texture texture;

    public static void init() throws IOException {
        model = ObjLoader.loadObj((String)"res/leccy.obj");
        metal = TextureLoader.get().getTextureLinear("res/metal.tga");
        redwall = TextureLoader.get().getTextureLinear("res/redpeg.tga");
        bluewall = TextureLoader.get().getTextureLinear("res/bluepeg.tga");
        yellowwall = TextureLoader.get().getTextureLinear("res/yellowpeg.tga");
    }

    public Peg(Map map, float x, float y, String data) throws IOException {
        this.x = x;
        this.y = y;
        this.data = data;
        this.map = map;
        this.texture = metal;
        if (data.endsWith("yellow")) {
            this.texture = yellowwall;
        }
        if (data.endsWith("red")) {
            this.texture = redwall;
        }
        if (data.endsWith("blue")) {
            this.texture = bluewall;
        }
        this.body = new Body(new Circle(x, y, 0.1f));
    }

    public Body getBody() {
        return this.body;
    }

    public Shape getShape() {
        return this.body.getShape();
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int getID() {
        return this.id;
    }

    public void createImpl() {
    }

    public void destroy() {
    }

    public void renderImpl(int delta, boolean reflection) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        Map.render(this.texture, model, null, !reflection);
        GL11.glPopMatrix();
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
    }

    public boolean hit(Ball ball, float depth) {
        return false;
    }

    public MapElement copy(Map map) {
        try {
            return new Peg(map, this.x, this.y, this.data);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public boolean finished() {
        return false;
    }
}

