/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.AABox;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;

public class OneWayTile
extends MapElement {
    private static Texture texture;
    private static final int UP = 1;
    private static final int DOWN = 2;
    private static final int LEFT = 3;
    private static final int RIGHT = 4;
    private AABox bounds;
    private float x;
    private float y;
    private Map map;
    private Ball ball;
    private String id;
    private float x1;
    private float y1;
    private float width;
    private float height;
    private float ux;
    private float vx;
    private float uy;
    private float vy;
    private int type;

    public static void init() throws IOException {
        texture = TextureLoader.get().getTextureLinear("res/oneway.tga");
    }

    public OneWayTile(Map map, float x1, float y1, float width, float height, String id) {
        this.bounds = new AABox(x1 + 0.1f, y1 + 0.1f, width - 0.2f, height - 0.2f);
        this.x1 = x1;
        this.width = width;
        this.y1 = y1;
        this.height = height;
        this.x = x1;
        this.y = y1;
        this.id = id;
        this.map = map;
        this.type = 1;
        this.ux = -1.0f;
        this.uy = 0.0f;
        this.vx = 0.0f;
        this.vy = -1.0f;
        if ("down".equals(id)) {
            this.type = 2;
            this.ux = 1.0f;
            this.uy = 0.0f;
            this.vx = 0.0f;
            this.vy = 1.0f;
        }
        if ("right".equals(id)) {
            this.type = 4;
            this.ux = 0.0f;
            this.uy = -1.0f;
            this.vx = -1.0f;
            this.vy = 0.0f;
        }
        if ("left".equals(id)) {
            this.type = 3;
            this.ux = 0.0f;
            this.uy = 1.0f;
            this.vx = 1.0f;
            this.vy = 0.0f;
        }
    }

    public Body getBody() {
        return null;
    }

    public void createImpl() {
    }

    public void destroy() {
    }

    public Shape getShape() {
        return this.bounds;
    }

    public void renderImpl(int delta, boolean reflection) {
        if (reflection) {
            return;
        }
        float size = 0.5f;
        float size2 = size + 0.1f;
        float z = 0.02f;
        float z2 = 0.1f;
        texture.bind();
        float x2 = this.x1 + this.width;
        float y2 = this.y1 + this.height;
        GL11.glBegin((int)7);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTexCoord2f((float)(this.x1 * this.ux + this.y1 * this.uy), (float)(this.x1 * this.vx + this.y1 * this.vy));
        GL11.glVertex3f((float)this.x1, (float)this.y1, (float)z);
        GL11.glTexCoord2f((float)(x2 * this.ux + this.y1 * this.uy), (float)(x2 * this.vx + this.y1 * this.vy));
        GL11.glVertex3f((float)x2, (float)this.y1, (float)z);
        GL11.glTexCoord2f((float)(x2 * this.ux + y2 * this.uy), (float)(x2 * this.vx + y2 * this.vy));
        GL11.glVertex3f((float)x2, (float)y2, (float)z);
        GL11.glTexCoord2f((float)(this.x1 * this.ux + y2 * this.uy), (float)(this.x1 * this.vx + y2 * this.vy));
        GL11.glVertex3f((float)this.x1, (float)y2, (float)z);
        GL11.glEnd();
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
    }

    private float getAdjust(float original) {
        float value = Math.abs(original) * 2.5f;
        if (value < 0.2f) {
            value = 0.2f;
        }
        if (value > 2.0f) {
            value = 2.0f;
        }
        return value;
    }

    public boolean hit(Ball ball, float depth) {
        if (this.type == 2 && ball.getVelocityY() >= 0.0f) {
            ball.adjustVelocity(0.0f, -this.getAdjust(ball.getVelocityY()));
        }
        if (this.type == 1 && ball.getVelocityY() <= 0.0f) {
            ball.adjustVelocity(0.0f, this.getAdjust(ball.getVelocityY()));
        }
        if (this.type == 3 && ball.getVelocityX() >= 0.0f) {
            ball.adjustVelocity(-this.getAdjust(ball.getVelocityX()), 0.0f);
        }
        if (this.type == 4 && ball.getVelocityX() <= 0.0f) {
            ball.adjustVelocity(this.getAdjust(ball.getVelocityX()), 0.0f);
        }
        return false;
    }

    public MapElement copy(Map map) {
        return new OneWayTile(map, this.x1, this.y1, this.width, this.height, this.id);
    }
}

