/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.particles.ParticleEngine;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.render.util.Color;
import org.newdawn.render.window.LWJGLWindow;
import org.newdawn.state.GameState;
import org.newdawn.state.StateBasedGame;
import org.newdawn.state.transitions.FadeInTransition;
import org.newdawn.state.transitions.FadeOutTransition;
import org.newdawn.state.transitions.Transition;
import org.newdawn.tilt.Configuration;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapStore;
import org.newdawn.tilt.MouseOverArea;
import org.newdawn.tilt.MouseOverGroup;
import org.newdawn.tilt.SharedUI;
import org.newdawn.tilt.Tilt;
import org.newdawn.tilt.TiltController;
import org.newdawn.tilt.effect.ParticleEffect;
import org.newdawn.tilt.reg.PostListener;
import org.newdawn.tilt.util.FastTrig;

public class NagState
implements GameState,
PostListener {
    public static final int ID = 32;
    private static final float LIMIT = 20.0f;
    private static String AUTH_URL = "http://www.tiltilation.com/register.php";
    private LWJGLWindow window;
    private Texture title;
    private Texture check;
    private Texture uncheck;
    private Texture back;
    private Texture getKey;
    private Texture enterKey;
    private Texture okKey;
    private MouseOverArea backArea;
    private MouseOverArea getKeyArea;
    private MouseOverArea okKeyArea;
    private MouseOverGroup group;
    private int selected;
    private boolean r;
    private boolean g;
    private String register;
    private String message;
    private float ang;
    private boolean failed;
    private String n;
    private String m;
    private String k;
    private Map map;
    private int x;
    private int y = 5;
    private float rx = 0.0f;
    private float ry = 0.0f;
    private boolean reflections = true;
    private int timer;
    private float jiggle = 0.0f;
    private TempEmitter emitter;
    private Color gray = new Color(0.0f, 0.0f, 0.0f, 0.5f);

    public NagState(LWJGLWindow window) {
        this.window = window;
    }

    private void renderRectangle(float x, float y, float width, float height) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glEnd();
    }

    public void init(StateBasedGame game) throws IOException {
        this.title = TextureLoader.get().getTextureLinear("res/register.tga");
        this.back = TextureLoader.get().getTextureLinear("res/menu-quit.tga");
        this.check = TextureLoader.get().getTextureLinear("res/check.tga");
        this.uncheck = TextureLoader.get().getTextureLinear("res/uncheck.tga");
        this.getKey = TextureLoader.get().getTextureLinear("res/menu-register.tga");
        this.backArea = new MouseOverArea(this.window, 200.0f, 535.0f, 200.0f, 50.0f);
        this.getKeyArea = new MouseOverArea(this.window, 140.0f, 465.0f, 300.0f, 50.0f);
        this.group = new MouseOverGroup("settings");
        this.group.addArea(this.getKeyArea);
        this.group.addArea(this.backArea);
        this.emitter = new TempEmitter();
    }

    public void reinit(StateBasedGame game) throws IOException {
    }

    public void render(StateBasedGame game, int delta) {
        this.renderMiniMap(delta);
        this.window.enterOrtho(600, 600);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        String text = "If you enjoyed playing";
        int xp = (600 - SharedUI.bigFontO.getWidth(text)) / 2;
        SharedUI.bigFontO.drawString(xp + 3, 53, text, Color.black);
        SharedUI.bigFontO.drawString(xp, 50, text, Color.white);
        text = "why not register?";
        xp = (600 - SharedUI.bigFontO.getWidth(text)) / 2;
        SharedUI.bigFontO.drawString(xp + 3, 93, text, Color.black);
        SharedUI.bigFontO.drawString(xp, 90, text, Color.white);
        text = "Loads more levels are";
        xp = (600 - SharedUI.bigFontO.getWidth(text)) / 2;
        SharedUI.bigFontO.drawString(xp + 3, 153, text, Color.black);
        SharedUI.bigFontO.drawString(xp, 150, text, Color.white);
        text = "only a few clicks away!";
        xp = (600 - SharedUI.bigFontO.getWidth(text)) / 2;
        SharedUI.bigFontO.drawString(xp + 3, 193, text, Color.black);
        SharedUI.bigFontO.drawString(xp, 190, text, Color.white);
        text = "Thanks for the support!";
        xp = (600 - SharedUI.bigFontO.getWidth(text)) / 2;
        SharedUI.bigFontO.drawString(xp + 3, 443, text, Color.black);
        SharedUI.bigFontO.drawString(xp, 440, text, Color.white);
        float col = 0.75f + this.getKeyArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.getKey.bind();
        this.renderRectangle(210.0f, 460.0f, 256.0f, 128.0f);
        col = 0.75f + this.backArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.back.bind();
        this.renderRectangle(255.0f, 530.0f, 128.0f, 128.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        this.window.leaveOrtho();
    }

    private void renderMiniMap(int delta) {
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-40.0f);
        GL11.glEnable((int)2896);
        boolean x = false;
        boolean y = false;
        float width = this.map.getMaxX() - this.map.getMinX();
        float height = this.map.getMaxY() - this.map.getMinY();
        float offsetx = -this.map.getMinX() - width / 2.0f;
        float offsety = -this.map.getMinY() - height / 2.0f;
        GL11.glRotatef((float)this.ry, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.rx, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)offsetx, (float)offsety, (float)0.0f);
        this.map.renderFloor(delta);
        if (this.reflections) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glCullFace((int)1028);
            GL11.glDepthFunc((int)518);
            this.map.renderBits(delta, true);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
        }
        GL11.glCullFace((int)1029);
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)3042);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.map.renderBits(delta, false);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.map.renderFloorOther(delta);
    }

    private void drawString(int y, String text) {
        int x = (600 - SharedUI.smallFontO.getWidth(text)) / 2;
        SharedUI.smallFontO.drawString(x + 3, y + 3, text, this.gray);
        SharedUI.smallFontO.drawString(x, y, text, Color.white);
    }

    public void nextMap() {
        if (this.map != null) {
            this.map.destroy();
        }
        ++this.x;
        while (MapStore.getMap(this.x, this.y) == null) {
            ++this.x;
            if (MapStore.getMap(this.x, this.y) != null) continue;
            ++this.y;
            if (this.y > 8) {
                this.y = 5;
            }
            this.x = 0;
        }
        this.map = MapStore.getMap(this.x, this.y).copy();
        this.map.create();
        this.timer = 6000;
    }

    public void update(StateBasedGame game, int delta) {
        this.jiggle += (float)delta * 0.0015f;
        this.rx = (float)FastTrig.cos(this.jiggle) * 20.0f;
        this.ry = (float)FastTrig.sin(this.jiggle) * 20.0f;
        this.timer -= delta;
        if (this.timer < 0) {
            this.nextMap();
        }
        int oldSelected = this.selected;
        this.selected = 0;
        if (this.backArea.considerMouse(delta)) {
            this.selected = 3;
        }
        if (this.getKeyArea.considerMouse(delta)) {
            this.selected = 1;
        }
        if (oldSelected != this.selected && this.selected != 0) {
            SharedUI.playOver();
        }
        this.map.update(this.emitter, delta, this.rx, this.ry);
        this.group.update();
        if (TiltController.buttonPressed()) {
            this.selectOption(game);
        }
        while (Mouse.next()) {
            if (Mouse.getEventButton() < 0 || !Mouse.getEventButtonState()) continue;
            this.selectOption(game);
        }
    }

    private void selectOption(StateBasedGame game) {
        if (this.selected == 1) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            game.changeToState(67, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
            return;
        }
        if (this.selected == 3) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            Tilt.exit();
            return;
        }
    }

    public void enterState(StateBasedGame game) {
        Mouse.setGrabbed((boolean)false);
        this.group.reset();
        this.nextMap();
        this.rx = (float)FastTrig.cos(this.jiggle) * 20.0f;
        this.ry = (float)FastTrig.sin(this.jiggle) * 20.0f;
    }

    public void leaveState(StateBasedGame game) {
    }

    public void failed() {
        this.failed = true;
        this.message = "Failed to Register";
    }

    public void reportLine(String line) {
        if (this.n == null) {
            this.n = line;
        } else if (this.m == null) {
            this.m = line;
        } else {
            this.r = true;
            Configuration.prefs.putString("r3", this.k);
            Configuration.prefs.putString("r1", this.n);
            Configuration.prefs.putString("r2", this.m);
            Configuration.prefs.putString("webname", line);
            Configuration.prefs.save();
        }
        this.message = "Success!";
    }

    public class TempEmitter
    extends GlobalEmitter {
        public void addEffect(ParticleEffect effect) {
        }

        public int getParticle(ParticleEffect effect, int life) {
            return 1;
        }

        public void init(ParticleEngine engine) {
        }

        public void render(int delta) {
        }

        public void reset() {
        }

        public void update(int delta, ParticleEngine engine) {
        }

        public void update(int delta) {
        }

        public void updateParticle(int i, int delta, ParticleEngine engine, int life) {
        }
    }
}

