/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.Block;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.AABox;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.tilt.physics.DynamicBody;
import org.newdawn.tilt.physics.DynamicBodyListener;
import org.newdawn.util.Log;

public class MovingBlock
extends MapElement
implements DynamicBodyListener {
    private static Sound thud;
    private static Texture texture;
    private AABox box;
    private DynamicBody body;
    private int list;
    private float x;
    private float y;
    private float width;
    private float height;
    private boolean movex;
    private boolean movey;
    private float floorFriction;
    private float h;
    private boolean stopped;
    private float lastx;
    private float lasty;
    private int timer;
    private float originalx;
    private float originaly;

    public static void init() throws IOException {
        thud = SoundStore.get().getOgg("res/sounds/thud.ogg");
        texture = TextureLoader.get().getTextureLinear("res/metal.tga");
    }

    public MovingBlock(float x, float y, float width, float height, boolean movex, boolean movey, float floorFriction, float h) throws IOException {
        this.originalx = x;
        this.originaly = y;
        this.x = x;
        this.y = y;
        this.h = h;
        this.width = width;
        this.height = height;
        this.movex = movex;
        this.movey = movey;
        this.floorFriction = floorFriction;
        float o = 0.01f;
        float o2 = o * 2.0f;
        this.box = new AABox(x + o, y + o, width - o2, height - o2);
        this.body = new DynamicBody(this.box, 0.0f, 0.0f);
        this.body.setPushable(false);
        this.body.setListener(this);
    }

    public Body getBody() {
        return this.body;
    }

    public Shape getShape() {
        return this.box;
    }

    public void createImpl() {
        this.list = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.list, (int)4864);
        AABox box = new AABox(0.0f, 0.0f, this.width, this.height);
        Block.renderBox(box, this.h);
        GL11.glEndList();
    }

    public void destroy() {
        GL11.glDeleteLists((int)this.list, (int)1);
    }

    public void renderImpl(int delta, boolean reflection) {
        texture.bind();
        GL11.glTranslatef((float)this.box.getX(), (float)this.box.getY(), (float)0.0f);
        GL11.glCallList((int)this.list);
        GL11.glTranslatef((float)(-this.box.getX()), (float)(-this.box.getY()), (float)0.0f);
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
        if (!this.movex) {
            this.body.setVelocity(0.0f, this.body.getVelocityY());
            this.body.getShape().setX(this.originalx);
        }
        if (!this.movey) {
            this.body.setVelocity(this.body.getVelocityX(), 0.0f);
            this.body.getShape().setY(this.originaly);
        }
        if (this.timer <= 0) {
            if (this.movex && Math.abs(this.body.getShape().getX() - this.lastx) > 0.005f) {
                this.stopped = false;
            }
            if (this.movey && Math.abs(this.body.getShape().getY() - this.lasty) > 0.005f) {
                this.stopped = false;
            }
        } else {
            this.timer -= delta;
        }
        this.lastx = this.body.getShape().getX();
        this.lasty = this.body.getShape().getY();
        this.body.scaleVelocity(this.floorFriction);
    }

    public boolean hit(Ball ball, float depth) {
        return false;
    }

    public MapElement copy(Map map) {
        try {
            return new MovingBlock(this.x, this.y, this.width, this.height, this.movex, this.movey, this.floorFriction, this.h);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public void hit(Body other) {
        if (this.movex && this.body.getVelocityX() == 0.0f && !this.stopped) {
            this.stopped = true;
            thud.playAsSoundEffect((float)(0.3 + Math.random() * 0.5), 0.2f);
            this.timer = 500;
        }
        if (this.movey && this.body.getVelocityY() == 0.0f && !this.stopped) {
            this.stopped = true;
            thud.playAsSoundEffect((float)(0.3 + Math.random() * 0.5), 0.2f);
            this.timer = 500;
        }
    }
}

