/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.util.ArrayList;
import org.lwjgl.input.Mouse;
import org.newdawn.tilt.MouseOverArea;
import org.newdawn.tilt.TiltController;

public class MouseOverGroup {
    private ArrayList areas = new ArrayList();
    private String name;
    private int selected;
    private boolean mouseMode = true;

    public MouseOverGroup(String name) {
        this.name = name;
    }

    public void addArea(MouseOverArea area) {
        this.areas.add(area);
    }

    public void reset() {
        this.selected = -1;
    }

    public void render() {
        for (int i = 0; i < this.areas.size(); ++i) {
            ((MouseOverArea)this.areas.get(i)).render();
        }
    }

    public void update() {
        boolean found = false;
        if (TiltController.isEnabled()) {
            for (int i = 0; i < this.areas.size(); ++i) {
                ((MouseOverArea)this.areas.get(i)).setCursorSelect(false);
                if (((MouseOverArea)this.areas.get(i)).isMouseSelected()) {
                    this.selected = i;
                    found = true;
                    this.mouseMode = true;
                }
                if (!this.mouseMode) continue;
                ((MouseOverArea)this.areas.get(i)).setCursorSelect(false);
            }
            if (TiltController.upPressed()) {
                Mouse.setCursorPosition((int)599, (int)0);
                this.mouseMode = false;
                --this.selected;
                if (this.selected < 0) {
                    this.selected = this.areas.size() - 1;
                }
            }
            if (TiltController.downPressed()) {
                Mouse.setCursorPosition((int)599, (int)0);
                this.mouseMode = false;
                ++this.selected;
                if (this.selected >= this.areas.size()) {
                    this.selected = 0;
                }
            }
            if (!this.mouseMode && this.selected != -1) {
                ((MouseOverArea)this.areas.get(this.selected)).setCursorSelect(true);
            }
        }
    }
}

