/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.window.LWJGLWindow;
import org.newdawn.tilt.geom.AABox;

public class MouseOverArea {
    private float value = 0.0f;
    private AABox box;
    private LWJGLWindow window;
    private boolean cursorSelect;
    private boolean mouseSelected;

    public MouseOverArea(LWJGLWindow window, float x, float y, float width, float height) {
        this.window = window;
        this.box = new AABox(x, y, width, height);
    }

    public void setCursorSelect(boolean cursorSelect) {
        this.cursorSelect = cursorSelect;
    }

    public boolean isMouseSelected() {
        return this.mouseSelected;
    }

    public boolean considerMouse(int delta) {
        int xp = Mouse.getX() - (this.window.getWidth() - 600) / 2;
        int yp = Mouse.getY() - (this.window.getHeight() - 600) / 2;
        this.mouseSelected = this.box.inside(xp, 600 - yp);
        if (this.box.inside(xp, 600 - yp) || this.cursorSelect) {
            this.on(delta);
            return true;
        }
        this.off(delta);
        return false;
    }

    public void clear() {
        this.value = 0.0f;
    }

    public void on(int delta) {
        this.value += (float)delta * 0.0045f;
        this.value = Math.min(0.25f, this.value);
    }

    public void off(int delta) {
        this.value -= (float)delta * 0.0045f;
        this.value = Math.max(0.0f, this.value);
    }

    public float getValue() {
        return this.value;
    }

    public void render() {
        GL11.glEnable((int)3042);
        Texture.bindNone();
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.3f);
        this.renderRectangle(this.box.getX(), this.box.getY(), this.box.getWidth(), this.box.getHeight());
        GL11.glDisable((int)3042);
    }

    private void renderRectangle(float x, float y, float width, float height) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glEnd();
    }
}

