/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.util.Properties;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.render.util.Color;
import org.newdawn.render.window.LWJGLWindow;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.state.GameState;
import org.newdawn.state.StateBasedGame;
import org.newdawn.state.transitions.FadeInTransition;
import org.newdawn.state.transitions.FadeOutTransition;
import org.newdawn.state.transitions.Transition;
import org.newdawn.tilt.Configuration;
import org.newdawn.tilt.MouseOverArea;
import org.newdawn.tilt.MouseOverGroup;
import org.newdawn.tilt.Prefs;
import org.newdawn.tilt.SharedUI;
import org.newdawn.tilt.Tilt;
import org.newdawn.tilt.TiltController;
import org.newdawn.util.Log;
import org.newdawn.util.ResourceLoader;

public class MenuState
implements GameState {
    public static final int ID = 2;
    private LWJGLWindow window;
    private Texture title;
    private Texture[] items = new Texture[5];
    private int selected;
    private MouseOverArea[] boxes = new MouseOverArea[5];
    private MouseOverGroup group;
    private String version;
    private boolean firstTime = true;
    private Sound music;
    private Color gray = new Color(0.0f, 0.0f, 0.0f, 0.5f);

    public MenuState(LWJGLWindow window) {
        this.window = window;
    }

    public void init(StateBasedGame game) throws IOException {
        this.music = SoundStore.get().getMOD("res/music/leo.mod");
        this.title = TextureLoader.get().getTextureLinear("res/menu-logo.tga");
        this.items[0] = TextureLoader.get().getTextureLinear("res/menu-newgame.tga");
        this.items[1] = TextureLoader.get().getTextureLinear("res/menu-settings.tga");
        this.items[2] = TextureLoader.get().getTextureLinear("res/menu-register.tga");
        this.items[3] = TextureLoader.get().getTextureLinear("res/menu-besttimes.tga");
        this.items[4] = TextureLoader.get().getTextureLinear("res/menu-quit.tga");
        int step = 77;
        int i = 0;
        this.boxes[0] = new MouseOverArea(this.window, 120.0f, 200 + i * step, 350.0f, 65.0f);
        i = 1;
        this.boxes[1] = new MouseOverArea(this.window, 130.0f, 200 + i * step, 310.0f, 65.0f);
        i = 2;
        this.boxes[2] = new MouseOverArea(this.window, 130.0f, 200 + i * step, 310.0f, 65.0f);
        i = 3;
        this.boxes[3] = new MouseOverArea(this.window, 130.0f, 200 + i * step, 310.0f, 65.0f);
        i = 4;
        this.boxes[4] = new MouseOverArea(this.window, 220.0f, 200 + i * step, 160.0f, 65.0f);
        this.group = new MouseOverGroup("mainmenu");
        for (i = 0; i < 5; ++i) {
            this.group.addArea(this.boxes[i]);
        }
        Properties props = new Properties();
        props.load(ResourceLoader.getResourceAsStream((String)"res/version"));
        this.version = props.getProperty("major.number") + "." + props.getProperty("minor.number");
    }

    public void reinit(StateBasedGame game) throws IOException {
    }

    public void render(StateBasedGame game, int delta) {
        this.window.enterOrtho(600, 600);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.title.bind();
        this.renderRectangle(44.0f, -50.0f, 512.0f, 256.0f);
        int i = 0;
        float value = 0.75f + this.boxes[i].getValue();
        GL11.glColor3f((float)value, (float)value, (float)value);
        this.items[i].bind();
        this.renderRectangle(200.0f, 195 + i * 70, 256.0f, 128.0f);
        i = 1;
        value = 0.75f + this.boxes[i].getValue();
        GL11.glColor3f((float)value, (float)value, (float)value);
        this.items[i].bind();
        this.renderRectangle(214.0f, 210 + i * 70, 256.0f, 128.0f);
        i = 2;
        value = 0.75f + this.boxes[i].getValue();
        GL11.glColor3f((float)value, (float)value, (float)value);
        this.items[i].bind();
        this.renderRectangle(214.0f, 215 + i * 70, 256.0f, 128.0f);
        i = 3;
        value = 0.75f + this.boxes[i].getValue();
        GL11.glColor3f((float)value, (float)value, (float)value);
        if (TiltController.ALL) {
            this.items[i].bind();
            this.renderRectangle(163.0f, 220 + i * 70, 285.0f, 70.0f);
        }
        if (!TiltController.ALL) {
            this.items[i + 1].bind();
            this.renderRectangle(254.0f, 220 + i * 70, 128.0f, 128.0f);
        }
        if (TiltController.ALL) {
            i = 4;
            value = 0.75f + this.boxes[i].getValue();
            GL11.glColor3f((float)value, (float)value, (float)value);
            this.items[i].bind();
            this.renderRectangle(254.0f, 220 + i * 70, 128.0f, 128.0f);
        }
        this.drawString(590, this.version);
        GL11.glDisable((int)3042);
        this.window.leaveOrtho();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawString(int y, String text) {
        int x = 600 - SharedUI.smallFontO.getWidth(text) - 10;
        SharedUI.smallFontO.drawString(x + 3, y + 3, text, this.gray);
        SharedUI.smallFontO.drawString(x, y, text, Color.white);
    }

    public void update(StateBasedGame game, int delta) {
        int mousey = 600 - Mouse.getY();
        int mousex = Mouse.getX();
        int oldSelected = this.selected;
        this.selected = -1;
        this.group.update();
        int val = TiltController.ALL ? 5 : 4;
        for (int i = 0; i < val; ++i) {
            if (!this.boxes[i].considerMouse(delta)) continue;
            if (i != oldSelected) {
                SharedUI.playOver();
            }
            this.selected = i;
        }
        if (TiltController.buttonPressed() && this.selected != -1) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            this.optionSelected(game, this.selected);
        }
        while (Mouse.next()) {
            if (Mouse.getEventButton() != 0 || !Mouse.getEventButtonState() || this.selected == -1) continue;
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            this.optionSelected(game, this.selected);
        }
    }

    private void optionSelected(StateBasedGame game, int option) {
        switch (option) {
            case 0: {
                game.changeToState(8, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
                break;
            }
            case 1: {
                game.changeToState(7, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
                break;
            }
            case 2: {
                game.changeToState(67, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
                break;
            }
            case 3: {
                if (TiltController.ALL) {
                    game.changeToState(76, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
                    break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                Tilt.exit();
                break;
            }
            case 4: {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Tilt.exit();
            }
        }
    }

    private void renderRectangle(float x, float y, float width, float height) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glEnd();
    }

    public void enterState(StateBasedGame game) {
        Mouse.setGrabbed((boolean)false);
        if (this.firstTime) {
            this.firstTime = false;
            this.music.playAsMusic(1.0f, 1.0f);
        }
        this.group.reset();
        if (Configuration.prefs.getLong("id", 0L) != (long)Prefs.levels.getAbsolutePath().hashCode()) {
            Configuration.remove("r1");
            Configuration.remove("r2");
            this.group.reset();
            Configuration.remove("r3");
            Log.log((String)"Losing 3");
        }
        TiltController.ALL = Configuration.prefs.getString("r3", null) != null;
    }

    public void leaveState(StateBasedGame game) {
    }
}

