/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.util.HashMap;
import org.newdawn.tilt.Configuration;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapLoader;
import org.newdawn.tilt.TiltController;
import org.newdawn.util.Log;

public class MapStore {
    private static final int EASY = 15;
    private static MapStore single;
    private static boolean override;
    private static String[][] keys;
    private HashMap maps = new HashMap();
    static /* synthetic */ Class class$org$newdawn$util$ResourceLoader;

    public static void init() throws IOException {
        for (int x = 0; x < 20; ++x) {
            for (int y = 0; y < 20; ++y) {
                String key;
                MapStore.keys[x][y] = key = "maps/level-" + x + "-" + y + ".svg";
            }
        }
        single = new MapStore();
    }

    public static void override() {
        override = false;
    }

    public static Map getMap(String ref) {
        return single.get(ref);
    }

    public static int getStarCount() {
        return single.starCount();
    }

    public static boolean hasEnoughStars(int x, int y) {
        if (x == 3 && y == 0) {
            return MapStore.getStarCount() >= 20;
        }
        if (x == 3 && y == 1) {
            return MapStore.getStarCount() >= 30;
        }
        if (x == 4 && y == 1) {
            return MapStore.getStarCount() >= 40;
        }
        if (x == 4 && y == 2) {
            return MapStore.getStarCount() >= 50;
        }
        return false;
    }

    private static boolean isDiscovered(int x, int y) {
        if (x == 3 && y == 0) {
            return Configuration.getGlobalValue("hidden1", 0.0f) != 0.0f;
        }
        if (x == 3 && y == 1) {
            return Configuration.getGlobalValue("hidden2", 0.0f) != 0.0f;
        }
        if (x == 4 && y == 1) {
            return Configuration.getGlobalValue("hidden3", 0.0f) != 0.0f;
        }
        if (x == 4 && y == 2) {
            return Configuration.getGlobalValue("hidden4", 0.0f) != 0.0f;
        }
        return false;
    }

    private static boolean isHidden(int x, int y) {
        if (x == 3 && y == 0) {
            return override;
        }
        if (x == 3 && y == 1) {
            return override;
        }
        if (x == 4 && y == 1) {
            return override;
        }
        if (x == 4 && y == 2) {
            return override;
        }
        return false;
    }

    public static boolean exists(int x, int y) {
        if (Configuration.prefs.getString("r3", null) == null && y > 4) {
            return false;
        }
        if (MapStore.isHidden(x, y)) {
            return MapStore.hasEnoughStars(x, y);
        }
        String mapName = keys[x][y];
        return MapStore.getMap(mapName) != null;
    }

    public static String getMapName(int x, int y) {
        String mapName = keys[x][y];
        return mapName;
    }

    public static Map getMap(int x, int y) {
        if (x < 0) {
            return null;
        }
        String mapName = keys[x][y];
        return MapStore.getMap(mapName);
    }

    public static boolean isAccessible(int x, int y) {
        if (!TiltController.ALL && y > 4) {
            return false;
        }
        if (x == 0 && y == 0) {
            return true;
        }
        if (MapStore.isHidden(x, y)) {
            return MapStore.isDiscovered(x, y);
        }
        if (y > 8) {
            return MapStore.isComplete(x, y - 1) || MapStore.isComplete(x + 1, y - 1);
        }
        return MapStore.isComplete(x - 1, y - 1) || MapStore.isComplete(x, y - 1);
    }

    public static boolean isComplete(int x, int y) {
        if (!TiltController.ALL && y > 4) {
            return false;
        }
        String mapName = "maps/level-" + x + "-" + y + ".svg";
        Map map = MapStore.getMap(mapName);
        if (map == null) {
            return false;
        }
        long bestTime = Configuration.getBestTime(mapName);
        return bestTime != 0L;
    }

    public static boolean isOnTarget(int x, int y) {
        if (!TiltController.ALL && y > 4) {
            return false;
        }
        String mapName = keys[x][y];
        Map map = MapStore.getMap(mapName);
        if (map == null) {
            return false;
        }
        long bestTime = Configuration.getBestTime(mapName);
        if (bestTime == 0L) {
            return false;
        }
        return map.getTargetTime() * 1000.0f >= (float)bestTime;
    }

    private MapStore() throws IOException {
        Log.log((String)"Map Store Initialised");
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 20; ++y) {
                boolean exists;
                String key = keys[x][y];
                boolean bl = exists = (class$org$newdawn$util$ResourceLoader == null ? MapStore.class$("org.newdawn.util.ResourceLoader") : class$org$newdawn$util$ResourceLoader).getClassLoader().getResourceAsStream(key) != null;
                if (!exists) continue;
                Map map = MapLoader.loadMap(key, x, y);
                this.maps.put(key, map);
            }
        }
    }

    private int starCount() {
        int count = 0;
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 20; ++y) {
                if (!MapStore.isOnTarget(x, y)) continue;
                ++count;
            }
        }
        return count;
    }

    public static void reloadMap(int x, int y) throws IOException {
        String key = keys[x][y];
        Map map = MapLoader.loadMap(key, x, y);
        MapStore.single.maps.put(key, map);
    }

    private Map get(String name) {
        return (Map)this.maps.get(name);
    }

    static {
        override = true;
        keys = new String[20][20];
    }
}

