/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.Block;
import org.newdawn.tilt.Bouncer;
import org.newdawn.tilt.Bridge;
import org.newdawn.tilt.Bumper;
import org.newdawn.tilt.CapsuleBlock;
import org.newdawn.tilt.CapsuleFloor;
import org.newdawn.tilt.CircleFloor;
import org.newdawn.tilt.CubitItem;
import org.newdawn.tilt.Cylinder;
import org.newdawn.tilt.ExitItem;
import org.newdawn.tilt.FallingBridge;
import org.newdawn.tilt.Fan;
import org.newdawn.tilt.Fence;
import org.newdawn.tilt.Floor;
import org.newdawn.tilt.FloorStyle;
import org.newdawn.tilt.Fuggle;
import org.newdawn.tilt.GravityProducer;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MovingBlock;
import org.newdawn.tilt.OneWayTile;
import org.newdawn.tilt.Peg;
import org.newdawn.tilt.PowerPill;
import org.newdawn.tilt.Roof;
import org.newdawn.tilt.ShrinkToken;
import org.newdawn.tilt.SpeedToken;
import org.newdawn.tilt.Spikes;
import org.newdawn.tilt.Stud;
import org.newdawn.tilt.Switch;
import org.newdawn.tilt.Teleport;
import org.newdawn.tilt.ToggleSwitch;
import org.newdawn.tilt.Tube;
import org.newdawn.tilt.WaitPad;
import org.newdawn.util.Log;
import org.newdawn.util.ResourceLoader;
import qdxml.DocHandler;
import qdxml.QDParser;

public class MapLoader
implements DocHandler {
    public static final float Z_SCALE_FACTOR = 1.0f;
    private static final float Z_SCALAR = 1.0f;
    private static final float SCALE = 50.0f;
    private Map map;
    private float maxX;
    private float maxY;
    private float minX;
    private float minY;
    private boolean first = true;

    public static Map loadMap(String ref, int x, int y) throws IOException {
        Map map = new MapLoader(ref, x, y).getMap();
        return map;
    }

    private MapLoader(String ref, int x, int y) throws IOException {
        try {
            this.map = new Map(x, y);
            QDParser.parse(this, new InputStreamReader(ResourceLoader.getResourceAsStream((String)ref)));
            this.map.setBounds(this.maxX, this.maxY, this.minX, this.minY);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    private String getAttribute(Hashtable attrs, String name) {
        String value = (String)attrs.get(name);
        if (value != null) {
            return value;
        }
        return (String)attrs.get("sodipodi:" + name);
    }

    private boolean hasFill(Hashtable attrs, String col) {
        String fill = this.getAttribute(attrs, "fill");
        if (col.equals(fill)) {
            return true;
        }
        String match = "fill:" + col;
        String style = this.getAttribute(attrs, "style");
        return style != null && style.indexOf(match) >= 0;
    }

    private void considerFeature(Hashtable attrs) throws IOException {
        if (this.hasFill(attrs, "#00ffff")) {
            float x = Float.parseFloat(this.getAttribute(attrs, "cx"));
            float y = Float.parseFloat(this.getAttribute(attrs, "cy"));
            String id = this.getAttribute(attrs, "id");
            x /= 50.0f;
            y /= 50.0f;
            if (id.startsWith("teleport")) {
                this.map.addItem(new Teleport(this.map, id, x, y));
            }
            if (id.startsWith("bouncer")) {
                this.map.addItem(new Bouncer(this.map, x, y, id));
            }
            if (id.startsWith("fence")) {
                this.map.addItem(new Fence(this.map, x, y, id));
            }
            if (id.startsWith("shrink")) {
                this.map.addItem(new ShrinkToken(this.map, x, y, id));
            }
            if (id.startsWith("speed")) {
                this.map.addItem(new SpeedToken(this.map, x, y, id));
            }
            if (id.startsWith("waitpad")) {
                this.map.addItem(new WaitPad(this.map, x, y));
            }
            if (id.startsWith("toggle")) {
                this.map.addItem(new ToggleSwitch(this.map, x, y, id));
            }
            if (id.startsWith("gravity")) {
                this.map.addItem(new GravityProducer(this.map, x, y, id));
            }
            if (id.startsWith("fan")) {
                this.map.addItem(new Fan(this.map, x, y, id));
            }
            if (id.startsWith("peg")) {
                this.map.addItem(new Peg(this.map, x, y, id));
            }
            if (id.startsWith("spikes")) {
                this.map.addItem(new Spikes(this.map, x, y, id));
            }
            if (id.startsWith("fuggle")) {
                this.map.addItem(new Fuggle(this.map, x, y, id));
            }
            if (id.startsWith("stud")) {
                this.map.addItem(new Stud(this.map, x, y, id));
            }
            if (id.startsWith("powerpill")) {
                this.map.addItem(new PowerPill(this.map, x, y, id));
            }
        }
    }

    private void considerExit(Hashtable attrs) throws IOException {
        if (this.hasFill(attrs, "#00ff00")) {
            float x = Float.parseFloat(this.getAttribute(attrs, "cx"));
            float y = Float.parseFloat(this.getAttribute(attrs, "cy"));
            String value = this.getAttribute(attrs, "id");
            this.map.addItem(new ExitItem(this.map, x /= 50.0f, y /= 50.0f, value));
        }
    }

    private void considerCubit(Hashtable attrs) throws IOException {
        if (this.hasFill(attrs, "#ffff00")) {
            float x = Float.parseFloat(this.getAttribute(attrs, "cx"));
            float y = Float.parseFloat(this.getAttribute(attrs, "cy"));
            this.map.addItem(new CubitItem(this.map, x /= 50.0f, y /= 50.0f));
        }
    }

    private void considerBall(Hashtable attrs) throws IOException {
        if (this.hasFill(attrs, "#ffffff")) {
            float x = Float.parseFloat(this.getAttribute(attrs, "cx"));
            float y = Float.parseFloat(this.getAttribute(attrs, "cy"));
            this.map.addItem(new Ball(this.map, x /= 50.0f, y /= 50.0f));
        }
    }

    private void considerSwitch(Hashtable attrs) throws IOException {
        float y;
        float x;
        if (this.hasFill(attrs, "#ff0000")) {
            x = Float.parseFloat(this.getAttribute(attrs, "cx"));
            y = Float.parseFloat(this.getAttribute(attrs, "cy"));
            this.map.addItem(new Switch(this.map, x /= 50.0f, y /= 50.0f, 1));
        }
        if (this.hasFill(attrs, "#0000ff")) {
            x = Float.parseFloat(this.getAttribute(attrs, "cx"));
            y = Float.parseFloat(this.getAttribute(attrs, "cy"));
            this.map.addItem(new Switch(this.map, x /= 50.0f, y /= 50.0f, 2));
        }
    }

    private void considerBarrier(Hashtable attrs) throws IOException {
        if (this.hasFill(attrs, "#000000")) {
            float x = Float.parseFloat(this.getAttribute(attrs, "cx"));
            float y = Float.parseFloat(this.getAttribute(attrs, "cy"));
            float rad = Float.parseFloat(this.getAttribute(attrs, "rx"));
            String value = this.getAttribute(attrs, "id");
            float h = 1.0f;
            if (value != null) {
                h = Float.parseFloat(value);
            }
            this.map.addItem(new Cylinder(x /= 50.0f, y /= 50.0f, rad /= 50.0f, 0.0f, h *= 1.0f));
        }
    }

    private void considerData(Hashtable attrs) throws IOException {
        if (this.hasFill(attrs, "#cccccc")) {
            String value = this.getAttribute(attrs, "id");
            if (value.startsWith("name:")) {
                this.map.setName(value.substring(6));
            }
            if (value.startsWith("task:")) {
                this.map.setObjective(value.substring(6));
            }
            if (value.startsWith("target:")) {
                this.map.setTargetTime(Float.parseFloat(value.substring(8)));
            }
            if (value.startsWith("version:")) {
                this.map.setVersion(Integer.parseInt(value.substring(9)));
            }
        }
    }

    private void considerCapsuleFloor(Hashtable attrs) throws IOException {
        if ("0.5".equals(this.getAttribute(attrs, "stroke-opacity"))) {
            float x1 = Float.parseFloat(this.getAttribute(attrs, "x1"));
            float y1 = Float.parseFloat(this.getAttribute(attrs, "y1"));
            float x2 = Float.parseFloat(this.getAttribute(attrs, "x2"));
            float y2 = Float.parseFloat(this.getAttribute(attrs, "y2"));
            float radius = Float.parseFloat(this.getAttribute(attrs, "stroke-width"));
            radius /= 2.0f;
            String data = this.getAttribute(attrs, "id");
            this.consider(x1 /= 50.0f, y1 /= 50.0f);
            this.consider(x2 /= 50.0f, y2 /= 50.0f);
            FloorStyle style = new FloorStyle("res/floors/marble.tga", 0.5f);
            float h = 0.4f;
            CapsuleFloor block = new CapsuleFloor(data, x1, y1, x2, y2, radius /= 50.0f, h *= 1.0f, style);
            this.map.addFloor(block);
        }
    }

    private void considerCircleFloor(Hashtable attrs) throws IOException {
        if (this.hasFill(attrs, "none")) {
            float x = Float.parseFloat(this.getAttribute(attrs, "cx"));
            float y = Float.parseFloat(this.getAttribute(attrs, "cy"));
            float rad = Float.parseFloat(this.getAttribute(attrs, "rx"));
            String data = this.getAttribute(attrs, "id");
            this.consider((x /= 50.0f) - (rad /= 50.0f), (y /= 50.0f) - rad);
            this.consider(x + rad, y + rad);
            FloorStyle style = new FloorStyle("res/floors/marble.tga", 0.5f);
            float h = 0.4f;
            this.map.addFloor(new CircleFloor(data, x, y, rad, h *= 1.0f, style));
        }
    }

    private void considerFloor(Hashtable attrs) throws IOException {
        if (this.hasFill(attrs, "none")) {
            float x = Float.parseFloat(this.getAttribute(attrs, "x"));
            float y = Float.parseFloat(this.getAttribute(attrs, "y"));
            float width = Float.parseFloat(this.getAttribute(attrs, "width"));
            float height = Float.parseFloat(this.getAttribute(attrs, "height"));
            String stroke = this.getAttribute(attrs, "stroke");
            String data = this.getAttribute(attrs, "id");
            this.consider(x /= 50.0f, y /= 50.0f);
            this.consider(x + (width /= 50.0f), y + (height /= 50.0f));
            if (stroke.equals("#ff0000")) {
                this.map.addItem(new Roof(this.map, x, y, width, height, 0.1f));
            } else if (stroke.equals("#0000ff")) {
                this.map.addFloor(new Bridge(data, x, y, width, height, 0.3f));
            } else if (stroke.equals("#00ffff")) {
                this.map.addFloor(new Tube(data, this.map, x, y, width, height, 0.3f));
            } else if (stroke.equals("#ffff00")) {
                this.map.addFloor(new FallingBridge(data, this.map, x, y, width, height, 0.3f));
            } else {
                FloorStyle style = new FloorStyle("res/floors/marble.tga", 0.5f);
                float h = 0.4f;
                this.map.addFloor(new Floor(data, x, y, width, height, h *= 1.0f, style, data));
            }
        }
    }

    private void considerMovingBlock(Hashtable attrs) throws IOException {
        if (this.hasFill(attrs, "#ff00ff")) {
            float x = Float.parseFloat(this.getAttribute(attrs, "x"));
            float y = Float.parseFloat(this.getAttribute(attrs, "y"));
            float width = Float.parseFloat(this.getAttribute(attrs, "width"));
            float height = Float.parseFloat(this.getAttribute(attrs, "height"));
            String id = this.getAttribute(attrs, "id");
            boolean movex = true;
            boolean movey = false;
            if (id != null && id.equals("updown")) {
                movex = false;
                movey = true;
            }
            this.consider(x /= 50.0f, y /= 50.0f);
            this.consider(x + (width /= 50.0f), y + (height /= 50.0f));
            float h = 0.4f;
            this.map.addItem(new MovingBlock(x, y, width, height, movex, movey, 0.97f, h *= 1.0f));
        }
    }

    private void considerCapsuleBlock(Hashtable attrs) throws IOException {
        if (!"0.5".equals(this.getAttribute(attrs, "stroke-opacity"))) {
            float x1 = Float.parseFloat(this.getAttribute(attrs, "x1"));
            float y1 = Float.parseFloat(this.getAttribute(attrs, "y1"));
            float x2 = Float.parseFloat(this.getAttribute(attrs, "x2"));
            float y2 = Float.parseFloat(this.getAttribute(attrs, "y2"));
            float radius = Float.parseFloat(this.getAttribute(attrs, "stroke-width"));
            radius /= 2.0f;
            this.consider(x1 /= 50.0f, y1 /= 50.0f);
            this.consider(x2 /= 50.0f, y2 /= 50.0f);
            CapsuleBlock block = new CapsuleBlock(x1, y1, x2, y2, radius /= 50.0f);
            this.map.addItem(block);
        }
    }

    private void considerWall(Hashtable attrs) throws IOException {
        String id;
        float height;
        float width;
        float y;
        float x;
        if (this.hasFill(attrs, "#00ffff")) {
            x = Float.parseFloat(this.getAttribute(attrs, "x"));
            y = Float.parseFloat(this.getAttribute(attrs, "y"));
            width = Float.parseFloat(this.getAttribute(attrs, "width"));
            height = Float.parseFloat(this.getAttribute(attrs, "height"));
            id = this.getAttribute(attrs, "id");
            this.consider(x /= 50.0f, y /= 50.0f);
            this.consider(x + (width /= 50.0f), y + (height /= 50.0f));
            this.map.addItem(new OneWayTile(this.map, x, y, width, height, id));
        }
        if (this.hasFill(attrs, "#ccffff")) {
            x = Float.parseFloat(this.getAttribute(attrs, "x"));
            y = Float.parseFloat(this.getAttribute(attrs, "y"));
            width = Float.parseFloat(this.getAttribute(attrs, "width"));
            height = Float.parseFloat(this.getAttribute(attrs, "height"));
            id = this.getAttribute(attrs, "id");
            this.consider(x /= 50.0f, y /= 50.0f);
            this.consider(x + (width /= 50.0f), y + (height /= 50.0f));
            int type = 2;
            if (width > height) {
                type = 1;
            }
            this.map.addItem(new Bumper(this.map, x + width / 2.0f, y + height / 2.0f, type, id));
        }
        if (this.hasFill(attrs, "#000000") || this.hasFill(attrs, "#ffff00") || this.hasFill(attrs, "#ff0000") || this.hasFill(attrs, "#0000ff")) {
            x = Float.parseFloat(this.getAttribute(attrs, "x"));
            y = Float.parseFloat(this.getAttribute(attrs, "y"));
            width = Float.parseFloat(this.getAttribute(attrs, "width"));
            height = Float.parseFloat(this.getAttribute(attrs, "height"));
            String value = this.getAttribute(attrs, "id");
            float h = 0.6f;
            int type = 1;
            boolean soft = false;
            if (value != null) {
                if (value.equals("soft")) {
                    soft = true;
                } else {
                    StringTokenizer tokens = new StringTokenizer(value, ",");
                    h = Float.parseFloat(tokens.nextToken());
                    String typeName = tokens.nextToken();
                    if (typeName.equals("metal")) {
                        type = 2;
                    }
                }
            } else {
                value = "";
            }
            if (this.hasFill(attrs, "#ff0000")) {
                type = 3;
            }
            if (this.hasFill(attrs, "#0000ff")) {
                type = 4;
            }
            if (this.hasFill(attrs, "#ffff00")) {
                type = 5;
            }
            this.consider(x /= 50.0f, y /= 50.0f);
            this.consider(x + (width /= 50.0f), y + (height /= 50.0f));
            this.map.addItem(new Block(this.map, x, y, width, height, h *= 1.0f, type, soft, value));
        }
    }

    private void consider(float x, float y) {
        if (this.first) {
            this.maxX = x;
            this.maxY = y;
            this.minX = x;
            this.minY = y;
            this.first = false;
            return;
        }
        this.maxX = Math.max(this.maxX, x);
        this.minX = Math.min(this.minX, x);
        this.maxY = Math.max(this.maxY, y);
        this.minY = Math.min(this.minY, y);
    }

    private Map getMap() {
        return this.map;
    }

    public void startElement(String name, Hashtable attributes) throws Exception {
        if (name.equals("rect")) {
            this.considerFloor(attributes);
            this.considerWall(attributes);
            this.considerData(attributes);
            this.considerMovingBlock(attributes);
        }
        if (name.equals("ellipse") || name.equals("path")) {
            this.considerCircleFloor(attributes);
            this.considerBarrier(attributes);
            this.considerBall(attributes);
            this.considerCubit(attributes);
            this.considerSwitch(attributes);
            this.considerExit(attributes);
            this.considerFeature(attributes);
        }
        if (name.equals("line")) {
            this.considerCapsuleBlock(attributes);
            this.considerCapsuleFloor(attributes);
        }
    }

    public void endElement(String tag) throws Exception {
    }

    public void startDocument() throws Exception {
    }

    public void endDocument() throws Exception {
    }

    public void text(String str) throws Exception {
    }
}

