/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import org.lwjgl.opengl.GL11;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.Floor;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;

public abstract class MapElement {
    public static final Shape NO_BOUNDS = new Circle(10000.0f, 10000.0f, 0.0f);
    protected float zoffset;

    public abstract Body getBody();

    public abstract Shape getShape();

    public void create(Map map) {
        Floor floor;
        if (this.getShape() != null && !(this instanceof Floor) && (floor = map.getHighestFloor(null, this.getShape())) != null) {
            this.zoffset = floor.getZ();
        }
        this.createImpl();
    }

    public abstract void createImpl();

    public abstract void destroy();

    public void render(int delta, boolean reflection) {
        float scale = reflection ? -1.0f : 1.0f;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(this.zoffset * scale));
        this.renderImpl(delta, reflection);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-this.zoffset * scale));
    }

    public void renderOther(int delta, boolean reflection) {
        float scale = reflection ? -1.0f : 1.0f;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(this.zoffset * scale));
        this.renderOtherImpl(delta, reflection);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-this.zoffset * scale));
    }

    public abstract void renderImpl(int var1, boolean var2);

    public abstract void renderOtherImpl(int var1, boolean var2);

    public abstract void update(GlobalEmitter var1, int var2, float var3, float var4);

    public abstract boolean hit(Ball var1, float var2);

    public abstract MapElement copy(Map var1);
}

