/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.util.ArrayList;
import java.util.HashMap;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.models.obj.ObjModel;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.util.Color;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.CubitItem;
import org.newdawn.tilt.ExitItem;
import org.newdawn.tilt.Floor;
import org.newdawn.tilt.Fuggle;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.Stud;
import org.newdawn.tilt.Teleport;
import org.newdawn.tilt.geom.CollisionResult;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.tilt.physics.DynamicBody;
import org.newdawn.tilt.physics.Space;
import org.newdawn.tilt.physics.SpaceListener;

public class Map
implements SpaceListener {
    private ArrayList floors = new ArrayList();
    private ArrayList items = new ArrayList();
    private ArrayList balls = new ArrayList();
    private ArrayList others = new ArrayList();
    private float maxX;
    private float maxY;
    private float minX;
    private float minY;
    private String name = "No Name";
    private String objective = "No Objective";
    private float targetTime;
    private int cubitCount = 0;
    private Space space;
    private HashMap bodies = new HashMap();
    private int version = 0;
    private Ball ball;
    private ArrayList colliders = new ArrayList();
    private ArrayList teleports = new ArrayList();
    private int locX;
    private int locY;
    private CollisionResult result = new CollisionResult();

    public Map(int locX, int locY) {
        this.space = new Space(this);
        this.locX = locX;
        this.locY = locY;
    }

    public void addBody(Body body, MapElement element) {
        this.space.add(body);
        this.bodies.put(body, element);
    }

    public int getLocX() {
        return this.locX;
    }

    public int getLocY() {
        return this.locY;
    }

    public Ball getBall() {
        return this.ball;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public String getObjective() {
        return this.objective;
    }

    public void setName(String name) {
        this.name = name;
    }

    public float getTargetTime() {
        return this.targetTime;
    }

    public void setTargetTime(float targetTime) {
        this.targetTime = targetTime;
    }

    public void setObjective(String objective) {
        this.objective = objective;
    }

    public void setBounds(float maxX, float maxY, float minX, float minY) {
        this.maxX = maxX;
        this.maxY = maxY;
        this.minX = minX;
        this.minY = minY;
        if (this.cubitCount == 0) {
            this.showExits();
        }
    }

    public float getMaxX() {
        return this.maxX;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMinY() {
        return this.minY;
    }

    private void showExits() {
        for (int i = 0; i < this.items.size(); ++i) {
            MapElement element = (MapElement)this.items.get(i);
            if (!(element instanceof ExitItem)) continue;
            ((ExitItem)element).show();
        }
    }

    public Teleport getOtherTeleport(Teleport source) {
        int id = source.getID();
        int find = (int)(Math.random() * 10.0 + 1.0);
        while (find > 0) {
            for (int i = 0; i < this.teleports.size(); ++i) {
                Teleport current = (Teleport)this.teleports.get(i);
                if (current.getID() != id || current == source || --find != 0) continue;
                return current;
            }
        }
        return null;
    }

    public void addItem(MapElement item) {
        if (item instanceof CubitItem) {
            ++this.cubitCount;
        }
        if (item instanceof Ball) {
            this.ball = (Ball)item;
            this.balls.add(item);
        }
        if (item instanceof Teleport) {
            this.teleports.add(item);
        }
        if (item.getBody() == null) {
            this.colliders.add(item);
        } else {
            this.others.add(item);
            this.bodies.put(item.getBody(), item);
            this.space.add(item.getBody());
        }
        this.items.add(item);
    }

    public void removeItem(MapElement item) {
        if (item instanceof CubitItem) {
            --this.cubitCount;
            if (this.cubitCount == 0) {
                this.showExits();
            }
        }
        this.bodies.remove(item.getBody());
        this.space.remove(item.getBody());
        this.items.remove(item);
    }

    public void addFloor(MapElement floor) {
        this.floors.add(floor);
    }

    public void removeFloor(MapElement floor) {
        this.floors.remove(floor);
    }

    public boolean ballsThroughExit() {
        for (int i = 0; i < this.balls.size(); ++i) {
            if (((Ball)this.balls.get(i)).throughExit()) continue;
            return false;
        }
        return true;
    }

    public boolean ballsFinished() {
        for (int i = 0; i < this.balls.size(); ++i) {
            if (((Ball)this.balls.get(i)).completed()) continue;
            return false;
        }
        return true;
    }

    public boolean ballsFallComplete() {
        for (int i = 0; i < this.balls.size(); ++i) {
            if (((Ball)this.balls.get(i)).completed() || !((Ball)this.balls.get(i)).fallComplete()) continue;
            return true;
        }
        return false;
    }

    public boolean ballsDead() {
        for (int i = 0; i < this.balls.size(); ++i) {
            if (((Ball)this.balls.get(i)).completed() || !((Ball)this.balls.get(i)).isDead()) continue;
            return true;
        }
        return false;
    }

    public boolean onFloor(Ball ball, Shape shape) {
        for (int i = 0; i < this.floors.size(); ++i) {
            MapElement element = (MapElement)this.floors.get(i);
            this.result.missed();
            element.getShape().collides(0.0f, 0.0f, shape, false, this.result);
            if (!this.result.collided()) continue;
            element.hit(ball, 0.0f);
            return true;
        }
        return false;
    }

    public Floor getHighestFloor(Ball ball, Shape shape) {
        float best = -1000.0f;
        Floor found = null;
        for (int i = 0; i < this.floors.size(); ++i) {
            MapElement element = (MapElement)this.floors.get(i);
            this.result.missed();
            element.getShape().collides(0.0f, 0.0f, shape, false, this.result);
            if (!this.result.collided()) continue;
            element.hit(ball, 0.0f);
            Floor f = (Floor)element;
            if (!(f.getZ() > best)) continue;
            best = f.getZ();
            found = f;
        }
        return found;
    }

    public void renderFloor(int delta) {
        for (int i = 0; i < this.floors.size(); ++i) {
            MapElement element = (MapElement)this.floors.get(i);
            element.render(delta, false);
        }
    }

    public void renderFloorOther(int delta) {
        GL11.glDepthFunc((int)513);
        for (int i = 0; i < this.floors.size(); ++i) {
            MapElement element = (MapElement)this.floors.get(i);
            element.renderOther(delta, false);
        }
        GL11.glDepthFunc((int)515);
    }

    public void renderBits(int delta, boolean reflection) {
        MapElement element;
        int i;
        for (i = 0; i < this.items.size(); ++i) {
            element = (MapElement)this.items.get(i);
            if (reflection) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            } else {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
            element.render(delta, reflection);
        }
        for (i = 0; i < this.items.size(); ++i) {
            element = (MapElement)this.items.get(i);
            if (reflection) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            } else {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
            element.renderOther(delta, reflection);
        }
    }

    public void getElements(Class clazz, ArrayList result) {
        MapElement element;
        int i;
        result.clear();
        for (i = 0; i < this.items.size(); ++i) {
            element = (MapElement)this.items.get(i);
            if (element.getClass() != clazz) continue;
            result.add(element);
        }
        for (i = 0; i < this.floors.size(); ++i) {
            element = (MapElement)this.floors.get(i);
            if (element.getClass() != clazz) continue;
            result.add(element);
        }
    }

    public boolean clear(MapElement me, Shape shape) {
        for (int i = 0; i < this.others.size(); ++i) {
            MapElement element = (MapElement)this.others.get(i);
            if (me == element) continue;
            this.result.missed();
            element.getShape().collides(0.0f, 0.0f, shape, false, this.result);
            if (!this.result.collided()) continue;
            return false;
        }
        return true;
    }

    public void update(GlobalEmitter emitter, int delta, float rx, float ry) {
        MapElement element;
        int i;
        this.space.setGravity(ry * 0.2f * (5.0f / (float)delta), -rx * 0.2f * (5.0f / (float)delta));
        this.space.update(delta);
        for (int b = 0; b < this.balls.size(); ++b) {
            Ball ball = (Ball)this.balls.get(b);
            Shape shape = ball.getShape();
            for (int i2 = 0; i2 < this.colliders.size(); ++i2) {
                MapElement element2 = (MapElement)this.colliders.get(i2);
                this.result.missed();
                element2.getShape().collides(0.0f, 0.0f, shape, false, this.result);
                if (!this.result.collided()) continue;
                element2.hit(ball, this.result.getPenDepth());
            }
        }
        for (i = 0; i < this.floors.size(); ++i) {
            element = (MapElement)this.floors.get(i);
            element.update(emitter, delta, rx, ry);
        }
        for (i = 0; i < this.items.size(); ++i) {
            element = (MapElement)this.items.get(i);
            element.update(emitter, delta, rx, ry);
        }
    }

    public void destroy() {
        MapElement element;
        int i;
        for (i = 0; i < this.floors.size(); ++i) {
            element = (MapElement)this.floors.get(i);
            element.destroy();
        }
        for (i = 0; i < this.items.size(); ++i) {
            element = (MapElement)this.items.get(i);
            element.destroy();
        }
    }

    public void create() {
        MapElement element;
        int i;
        for (i = 0; i < this.floors.size(); ++i) {
            element = (MapElement)this.floors.get(i);
            element.create(this);
        }
        for (i = 0; i < this.items.size(); ++i) {
            element = (MapElement)this.items.get(i);
            element.create(this);
        }
    }

    public Map copy() {
        MapElement copy;
        int i;
        Map map = new Map(this.locX, this.locY);
        map.maxX = this.maxX;
        map.maxY = this.maxY;
        map.minX = this.minX;
        map.minY = this.minY;
        map.name = this.name;
        map.objective = this.objective;
        map.targetTime = this.targetTime;
        for (i = 0; i < this.floors.size(); ++i) {
            copy = ((MapElement)this.floors.get(i)).copy(map);
            map.addFloor(copy);
        }
        for (i = 0; i < this.items.size(); ++i) {
            copy = ((MapElement)this.items.get(i)).copy(map);
            if (copy == null) continue;
            map.addItem(copy);
        }
        return map;
    }

    public String toString() {
        return "[Map (" + super.toString() + ") " + this.minX + "," + this.minY + " -> " + this.maxX + "," + this.maxY + "]";
    }

    public boolean hit(DynamicBody mover, Body target, float pen) {
        MapElement movingElement = (MapElement)this.bodies.get(mover);
        if (movingElement instanceof Ball) {
            Ball ball = (Ball)movingElement;
            MapElement element = (MapElement)this.bodies.get(target);
            if (!(element instanceof Stud)) {
                ball.hit(ball, pen);
            }
            return element.hit(ball, pen);
        }
        if (movingElement instanceof Fuggle) {
            MapElement element = (MapElement)this.bodies.get(target);
            if (!(element instanceof Ball)) {
                Fuggle fuggle = (Fuggle)movingElement;
                fuggle.blocked();
            } else {
                Fuggle fuggle = (Fuggle)movingElement;
                fuggle.hit((Ball)element, 0.0f);
            }
        }
        return false;
    }

    public void removeBody(Body body) {
        this.space.remove(body);
    }

    public static void render(Texture texture, ObjModel model, Color col, boolean outline) {
        Map.render(texture, model, col, outline, 1.1f);
    }

    public static void render(Texture texture, ObjModel model, Color col, boolean outline, float scale) {
        if (outline) {
            Texture.bindNone();
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glCullFace((int)1028);
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            model.render();
            GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
            GL11.glCullFace((int)1029);
        }
        if (texture != null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            texture.bind();
        } else {
            Texture.bindNone();
        }
        if (col != null) {
            col.a = 0.5f;
            col.bind();
        }
        model.render();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
    }
}

