/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.render.util.Color;
import org.newdawn.render.util.Tuple4;
import org.newdawn.render.window.LWJGLWindow;
import org.newdawn.state.GameState;
import org.newdawn.state.StateBasedGame;
import org.newdawn.state.transitions.FadeInTransition;
import org.newdawn.state.transitions.FadeOutTransition;
import org.newdawn.state.transitions.Transition;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.Configuration;
import org.newdawn.tilt.InGameState;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapStore;
import org.newdawn.tilt.MouseOverArea;
import org.newdawn.tilt.SharedUI;
import org.newdawn.tilt.TiltController;
import org.newdawn.tilt.balls.BallType;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.util.FastTrig;

public class LevelSelectState
implements GameState {
    public static final int ID = 8;
    private static final int ROWS = 11;
    private FloatBuffer buffer = BufferUtils.createFloatBuffer((int)4);
    private FloatBuffer mcolor = BufferUtils.createFloatBuffer((int)4);
    private FloatBuffer mcolor2 = BufferUtils.createFloatBuffer((int)4);
    private FloatBuffer pos1 = new Tuple4(0.5f, 0.2f, 0.5f, 0.0f).toFloatBuffer();
    private FloatBuffer spec1 = new Tuple4(0.2f, 0.2f, 0.2f, 1.0f).toFloatBuffer();
    private FloatBuffer pos2 = new Tuple4(-0.5f, -0.2f, -0.5f, 0.0f).toFloatBuffer();
    private FloatBuffer spec2 = new Tuple4(0.2f, 0.2f, 0.2f, 1.0f).toFloatBuffer();
    private LWJGLWindow window;
    private Texture title;
    private Texture back;
    private Texture level;
    private Texture star;
    private MouseOverArea backArea;
    private int selected;
    private HashMap areaToMap = new HashMap();
    private ArrayList circles = new ArrayList();
    private int selectedx;
    private int selectedy;
    private Map selectedMap;
    private String selectedProp;
    private InGameState ingame;
    private String selectedMapFile = "";
    private boolean selectedSetByController;
    private String maintext = null;
    private Map map;
    private String text = null;
    private boolean available;
    private float rot;
    private boolean blastOn = false;
    private MapToken[][] tokens = new MapToken[20][20];
    private int starCount;
    private Color gray = new Color(0.0f, 0.0f, 0.0f, 0.3f);
    private String starCountMessage = "";
    private boolean hasEnoughStars30;
    private boolean hasEnoughStars31;
    private boolean hasEnoughStars41;
    private boolean hasEnoughStars42;
    private boolean opened30;
    private boolean opened31;
    private boolean opened41;
    private boolean opened42;
    private Texture box;
    private float ballRot;
    private MouseOverArea[] ballAreas = new MouseOverArea[10];
    private int selectedBall = -1;
    private int lastSelectedBall = -1;
    private float ballSelectGUIValue;
    private int ballInUse = 3;
    private boolean[] availableBalls = new boolean[7];
    private int lastStarCount;
    private ArrayList events = new ArrayList();
    private Event currentEvent;
    private Texture levelIcon;
    private Event[] preDef = new Event[50];
    private float count;

    public LevelSelectState(InGameState ingame, LWJGLWindow window) {
        this.window = window;
        this.ingame = ingame;
    }

    private void configureLighting() {
        float ambient = 0.2f;
        this.buffer.put(ambient).put(ambient).put(ambient).put(1.0f);
        this.buffer.flip();
        GL11.glLightModel((int)2899, (FloatBuffer)this.buffer);
        this.mcolor.put(1.0f).put(1.0f).put(1.0f).put(1.0f);
        this.mcolor.flip();
        GL11.glMaterial((int)1028, (int)4610, (FloatBuffer)this.mcolor);
        this.mcolor2.put(0.0f).put(0.0f).put(0.0f).put(1.0f);
        this.mcolor2.flip();
        GL11.glMaterial((int)1028, (int)5632, (FloatBuffer)this.mcolor2);
        GL11.glColorMaterial((int)1028, (int)5634);
        GL11.glEnable((int)2903);
        GL11.glLight((int)16384, (int)4611, (FloatBuffer)this.pos1);
        GL11.glLight((int)16384, (int)4610, (FloatBuffer)this.spec1);
        GL11.glEnable((int)16384);
        GL11.glLight((int)16385, (int)4611, (FloatBuffer)this.pos2);
        GL11.glLight((int)16385, (int)4610, (FloatBuffer)this.spec2);
        GL11.glEnable((int)16385);
        GL11.glEnable((int)32826);
    }

    private void addCircle(int x, int y, String id) {
        int total = y + 1;
        if (y > 8) {
            total -= 2;
        }
        if (y > 9) {
            total -= 2;
        }
        int xp = 300 - total * 64 / 2;
        Circle circle = new Circle(xp + x * 64 + 32, 70 + y * 32 + 32, 20.0f);
        MapToken token = new MapToken(x, y, "maps/level-" + x + "-" + y + ".svg", id);
        this.areaToMap.put(circle, token);
        this.circles.add(circle);
        this.tokens[x][y] = token;
    }

    public void init(StateBasedGame game) throws IOException {
        this.lastStarCount = (int)Configuration.getGlobalValue("lastStarCount", 0.0f);
        this.title = TextureLoader.get().getTextureLinear("res/chooselevel.tga");
        this.back = TextureLoader.get().getTextureLinear("res/backtomenu.tga");
        this.level = TextureLoader.get().getTextureLinear("res/levelbox.tga");
        this.star = TextureLoader.get().getTextureLinear("res/star.tga");
        this.box = TextureLoader.get().getTextureLinear("res/select.tga");
        this.levelIcon = TextureLoader.get().getTextureLinear("res/balls/levelicon.tga");
        this.backArea = new MouseOverArea(this.window, 200.0f, 530.0f, 200.0f, 50.0f);
        for (int y = 0; y < 11; ++y) {
            int total = y + 1;
            if (y > 8) {
                total -= 2;
            }
            if (y > 9) {
                total -= 2;
            }
            for (int x = 0; x < total; ++x) {
                this.addCircle(x, y, null);
            }
        }
        this.addCircle(3, 0, "hidden1");
        this.addCircle(3, 1, "hidden2");
        this.addCircle(4, 1, "hidden3");
        this.addCircle(4, 2, "hidden4");
        this.opened30 = MapStore.isAccessible(3, 0);
        this.opened31 = MapStore.isAccessible(3, 1);
        this.opened41 = MapStore.isAccessible(4, 1);
        this.opened42 = MapStore.isAccessible(4, 2);
        GL11.glEnable((int)2896);
        this.configureLighting();
        for (int i = 0; i < 7; ++i) {
            this.ballAreas[i] = new MouseOverArea(this.window, i * 65 + 80, 475.0f, 50.0f, 50.0f);
        }
        this.preDef[0] = new Event(15, "You unlocked the", Ball.renderers[1].getName() + "!", Ball.rendererIcons[1]){

            public void action() {
                Configuration.setBallAvailable(1);
            }
        };
        this.preDef[1] = new Event(20, "You found a Bonus Level!", "Now find the entrance!", this.levelIcon){

            public void action() {
            }
        };
        this.preDef[2] = new Event(25, "You unlocked the", Ball.renderers[0].getName() + "!", Ball.rendererIcons[0]){

            public void action() {
                Configuration.setBallAvailable(0);
            }
        };
        this.preDef[3] = new Event(35, "You unlocked the", Ball.renderers[4].getName() + "!", Ball.rendererIcons[4]){

            public void action() {
                Configuration.setBallAvailable(4);
            }
        };
        this.preDef[4] = new Event(45, "You unlocked the", Ball.renderers[5].getName() + "!", Ball.rendererIcons[5]){

            public void action() {
                Configuration.setBallAvailable(5);
            }
        };
        this.preDef[5] = new Event(55, "You unlocked the", Ball.renderers[6].getName() + "!", Ball.rendererIcons[6]){

            public void action() {
                Configuration.setBallAvailable(6);
            }
        };
        this.preDef[6] = new Event(60, "You unlocked the", Ball.renderers[2].getName() + "!", Ball.rendererIcons[2]){

            public void action() {
                Configuration.setBallAvailable(2);
            }
        };
        this.preDef[7] = new Event(30, "You found a Bonus Level!", "Now find the entrance!", this.levelIcon){

            public void action() {
            }
        };
        this.preDef[8] = new Event(40, "You found a Bonus Level!", "Now find the entrance!", this.levelIcon){

            public void action() {
            }
        };
        this.preDef[9] = new Event(50, "You found a Bonus Level!", "Now find the entrance!", this.levelIcon){

            public void action() {
            }
        };
    }

    public void reinit(StateBasedGame game) throws IOException {
    }

    private void renderRectangle(float x, float y, float width, float height) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glEnd();
    }

    private void drawLevelIcon(int x, int y) {
        int total = y + 1;
        if (y > 8) {
            total -= 2;
        }
        if (y > 9) {
            total -= 2;
        }
        int xp = 300 - total * 64 / 2;
        this.level.bind();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.complete(x, y)) {
            GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        }
        if (!this.exists(x, y)) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
            if (x == this.selectedx && y == this.selectedy) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
                this.map = this.selectedMap;
                this.maintext = "Unavailable in Demo";
                this.text = "Click to View, Register to Play";
            }
        } else if (!this.accessible(x, y) && !this.blastOn) {
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.6f);
            if (x == this.selectedx && y == this.selectedy) {
                this.map = this.selectedMap;
                this.maintext = this.selectedMap.getName();
                this.text = "complete the level above to unlock";
                if (this.selectedProp != null) {
                    this.text = "find the secret exit to play!";
                }
                this.available = false;
                GL11.glColor4f((float)0.8f, (float)0.0f, (float)0.0f, (float)0.6f);
            }
        } else if (this.selectedMap != null && x == this.selectedx && y == this.selectedy) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            this.map = this.selectedMap;
            this.maintext = this.selectedMap.getName();
            if (this.onTarget(x, y)) {
                this.text = "click to play";
            } else {
                if (!this.complete(x, y)) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.3f, (float)1.0f);
                }
                this.text = "can you complete on target?";
            }
            this.available = true;
        }
        this.renderRectangle(xp + x * 64, 70 + y * 32, 64.0f, 64.0f);
        if (this.onTarget(x, y)) {
            this.star.bind();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.renderRectangle(xp + x * 64 + 14, 80 + y * 32, 34.0f, 34.0f);
            Texture.bindNone();
        }
    }

    public void render(StateBasedGame game, int delta) {
        int xp;
        int i;
        int resXOffset = (this.window.getWidth() - 600) / 2;
        this.ballSelectGUIValue = this.selectedBall == -1 ? 0.0f : (this.lastSelectedBall == this.selectedBall ? (this.availableBalls[this.selectedBall] ? (this.ballSelectGUIValue += (float)delta * 0.01f) : 0.0f) : 0.0f);
        this.lastSelectedBall = this.selectedBall;
        this.window.enterOrtho(600, 600);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.getStarCount() == 64) {
            float radius = 250.0f;
            for (int a = 0; a < 360; a += 20) {
                float xp2 = (float)(FastTrig.cos(Math.toRadians((float)a + this.count)) * (double)radius);
                float yp = (float)(FastTrig.sin(Math.toRadians((float)a + this.count)) * (double)radius);
                this.star.bind();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                this.renderRectangle(283.0f + xp2, 283.0f + yp, 34.0f, 34.0f);
                Texture.bindNone();
            }
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.box.bind();
        for (i = 0; i < 7; ++i) {
            if (this.selectedBall == i || i == this.ballInUse) {
                float v = this.ballSelectGUIValue;
                if (i == this.ballInUse) {
                    v = 100.0f;
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)Math.min(1.0f, 0.5f + v));
                float offset = Math.min(8.0f, v * 5.0f);
                this.renderRectangle((float)(i * 65 + 80) - offset, 475.0f - offset, 50.0f + offset * 2.0f, 50.0f + offset * 2.0f);
                continue;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            this.renderRectangle(i * 65 + 80, 475.0f, 50.0f, 50.0f);
        }
        this.window.leaveOrtho();
        GL11.glEnable((int)2896);
        this.ballRot += (float)delta * 0.1f;
        for (i = 0; i < 7; ++i) {
            if (!this.availableBalls[i]) continue;
            float yd = 600.0f / (float)Display.getDisplayMode().getHeight();
            GL11.glLoadIdentity();
            GL11.glScalef((float)yd, (float)yd, (float)1.0f);
            GL11.glTranslatef((float)(-5.4f + (float)i * 1.8f), (float)-5.5f, (float)-20.0f);
            GL11.glRotatef((float)(this.ballRot * 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(this.ballRot * 0.5f), (float)0.0f, (float)0.0f, (float)1.0f);
            BallType renderer = Ball.renderers[i];
            renderer.preBall();
            if (this.ballInUse == i) {
                GL11.glDisable((int)3042);
                Map.render(renderer.getTexture(), renderer.getModel(), null, true, 1.06f);
            } else {
                GL11.glEnable((int)3042);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                renderer.getTexture().bind();
                renderer.getModel().render();
            }
            renderer.postBall();
        }
        this.window.enterOrtho(600, 600);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.title.bind();
        this.renderRectangle(50.0f, -25.0f, 512.0f, 128.0f);
        float col = 0.75f + this.backArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.back.bind();
        this.renderRectangle(185.0f, 540.0f, 256.0f, 64.0f);
        this.map = null;
        this.maintext = null;
        this.text = null;
        this.available = false;
        for (int y = 0; y < 11; ++y) {
            int total = y + 1;
            if (y > 8) {
                total -= 2;
            }
            if (y > 9) {
                total -= 2;
            }
            for (int x = 0; x < total; ++x) {
                this.drawLevelIcon(x, y);
            }
        }
        if (this.hasEnoughStars30) {
            this.drawLevelIcon(3, 0);
        }
        if (this.hasEnoughStars31) {
            this.drawLevelIcon(3, 1);
        }
        if (this.hasEnoughStars41) {
            this.drawLevelIcon(4, 1);
        }
        if (this.hasEnoughStars42) {
            this.drawLevelIcon(4, 2);
        }
        if (this.maintext != null) {
            if (this.available) {
                GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.5f);
            } else {
                GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            }
            Texture.bindNone();
            this.renderRectangle(-resXOffset, 460.0f, 600 + resXOffset * 2, 70.0f);
            if (this.available) {
                GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
            }
            this.renderRectangle(-resXOffset, 460.0f, 600 + resXOffset * 2, 2.0f);
            this.renderRectangle(-resXOffset, 530.0f, 600 + resXOffset * 2, 2.0f);
            xp = 300 - SharedUI.bigFontO.getWidth(this.maintext) / 2;
            SharedUI.bigFontO.drawString(xp + 3, 503, this.maintext, this.gray);
            SharedUI.bigFontO.drawString(xp, 500, this.maintext, Color.white);
        }
        if (this.text != null) {
            xp = 300 - SharedUI.smallFontO.getWidth(this.text) / 2;
            SharedUI.smallFontO.drawString(xp + 3, 528, this.text, this.gray);
            SharedUI.smallFontO.drawString(xp, 525, this.text, Color.white);
        }
        int offset = SharedUI.bigFontO.getWidth(this.starCountMessage);
        SharedUI.bigFontO.drawString(110 - (offset /= 2), 153, this.starCountMessage, this.gray);
        SharedUI.bigFontO.drawString(107 - offset, 150, this.starCountMessage, Color.white);
        this.star.bind();
        GL11.glTranslatef((float)65.0f, (float)135.0f, (float)0.0f);
        GL11.glRotatef((float)this.rot, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3f);
        this.renderRectangle(-17.0f, -17.0f, 34.0f, 34.0f);
        GL11.glRotatef((float)(-this.rot), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-3.0f, (float)-3.0f, (float)0.0f);
        GL11.glRotatef((float)this.rot, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.renderRectangle(-17.0f, -17.0f, 34.0f, 34.0f);
        GL11.glRotatef((float)(-this.rot), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-107.0f, (float)-107.0f, (float)0.0f);
        Texture.bindNone();
        if (this.currentEvent != null) {
            this.currentEvent.render();
        }
        this.window.leaveOrtho();
    }

    private boolean checkForFirstPress() {
        if (this.selectedx == -1) {
            this.backArea.setCursorSelect(false);
            this.selectedx = 0;
            this.selectedy = 0;
            this.selectedMap = MapStore.getMap(this.selectedx, this.selectedy);
            this.selectedMapFile = MapStore.getMapName(this.selectedx, this.selectedy);
            SharedUI.playOver();
            return true;
        }
        return false;
    }

    private void selectBackToMenu() {
        this.selectedx = -1;
        this.selectedy = -1;
        this.selectedMap = null;
        this.backArea.setCursorSelect(true);
    }

    public void update(StateBasedGame game, int delta) {
        this.count += (float)delta * 0.03f;
        if (this.currentEvent != null) {
            if (this.currentEvent.update(delta)) {
                this.currentEvent = null;
            } else {
                return;
            }
        }
        if (this.events.size() != 0) {
            this.currentEvent = (Event)this.events.remove(0);
            return;
        }
        int oldSelected = this.selected;
        this.selected = 0;
        int lastBall = this.selectedBall;
        this.selectedBall = -1;
        for (int i = 0; i < 7; ++i) {
            if (!this.ballAreas[i].considerMouse(delta)) continue;
            this.selectedBall = i;
            if (this.selectedBall == lastBall) continue;
            SharedUI.over.playAsSoundEffect(1.0f, 1.0f);
            this.backArea.clear();
            this.selected = -1;
        }
        if (this.backArea.considerMouse(delta)) {
            this.selected = 1;
        }
        if (TiltController.isEnabled()) {
            if (TiltController.leftPressed()) {
                Mouse.setCursorPosition((int)590, (int)10);
                if (!this.checkForFirstPress()) {
                    --this.selectedx;
                    if (this.selectedx < 0) {
                        this.selectedx = this.selectedy;
                    }
                }
                this.selectedSetByController = true;
                SharedUI.playOver();
            }
            if (TiltController.rightPressed()) {
                Mouse.setCursorPosition((int)590, (int)10);
                if (!this.checkForFirstPress()) {
                    ++this.selectedx;
                    if (this.selectedx > this.selectedy) {
                        this.selectedx = 0;
                    }
                }
                this.selectedSetByController = true;
                SharedUI.playOver();
            }
            if (TiltController.upPressed()) {
                Mouse.setCursorPosition((int)590, (int)10);
                if (!this.checkForFirstPress()) {
                    --this.selectedy;
                    if (this.selectedy < 0) {
                        this.selectBackToMenu();
                    }
                    if (this.selectedx > this.selectedy) {
                        --this.selectedx;
                    }
                }
                this.selectedSetByController = true;
                SharedUI.playOver();
            }
            if (TiltController.downPressed()) {
                Mouse.setCursorPosition((int)590, (int)10);
                if (!this.checkForFirstPress()) {
                    ++this.selectedy;
                    if (this.selectedy >= 11) {
                        this.selectBackToMenu();
                    }
                }
                this.selectedSetByController = true;
                SharedUI.playOver();
            }
            if (this.selectedSetByController) {
                if (!this.exists(this.selectedx, this.selectedy)) {
                    this.selectBackToMenu();
                } else if (this.selectedx != -1) {
                    this.selectedMap = MapStore.getMap(this.selectedx, this.selectedy);
                    this.selectedMapFile = MapStore.getMapName(this.selectedx, this.selectedy);
                }
            }
        }
        boolean found = false;
        for (int i = 0; i < this.circles.size(); ++i) {
            int yp;
            int xp;
            Circle area = (Circle)this.circles.get(i);
            if (!area.inside(xp = Mouse.getX() - (this.window.getWidth() - 600) / 2, 600 - (yp = Mouse.getY() - (this.window.getHeight() - 600) / 2))) continue;
            MapToken token = (MapToken)this.areaToMap.get(area);
            if (token.prop != null && (token.x == 3 && token.y == 0 && !this.hasEnoughStars30 || token.x == 3 && token.y == 1 && !this.hasEnoughStars31 || token.x == 4 && token.y == 1 && !this.hasEnoughStars41 || token.x == 4 && token.y == 2 && !this.hasEnoughStars42)) continue;
            found = true;
            this.selectedx = token.x;
            this.selectedy = token.y;
            this.selectedMap = MapStore.getMap(token.name);
            this.selectedSetByController = false;
            this.selectedProp = token.prop;
            if (this.selectedMapFile.equals(token.name)) continue;
            this.selectedMapFile = token.name;
            SharedUI.playOver();
        }
        if (!found && !this.selectedSetByController) {
            this.selectedx = -1;
            this.selectedy = -1;
            this.selectedMap = null;
        }
        if (oldSelected != this.selected && this.selected != 0) {
            SharedUI.playOver();
        }
        if (TiltController.buttonPressed()) {
            this.selectMap(game);
        }
        if (Keyboard.isKeyDown((int)30) && Keyboard.isKeyDown((int)19) && Keyboard.isKeyDown((int)31)) {
            this.blastOn = TiltController.ALL;
        }
        while (Mouse.next()) {
            if (Mouse.getEventButton() < 0 || !Mouse.getEventButtonState()) continue;
            this.selectMap(game);
        }
    }

    private void selectMap(StateBasedGame game) {
        if (this.selectedBall >= 0) {
            if (this.availableBalls[this.selectedBall]) {
                this.ballInUse = this.selectedBall;
                Configuration.setBallInUse(this.ballInUse);
                SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
                return;
            }
            SharedUI.dud.playAsSoundEffect(1.0f, 1.0f);
            return;
        }
        if (this.selected == 1) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            game.changeToState(2, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
            return;
        }
        if (this.selectedMap != null) {
            if (this.accessible(this.selectedx, this.selectedy) || !this.exists(this.selectedx, this.selectedy) || this.blastOn) {
                SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
                this.ingame.setMap(this.selectedMapFile, this.selectedMap);
                game.changeToState(1, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
                return;
            }
            SharedUI.dud.playAsSoundEffect(1.5f, 0.2f);
        } else if (this.selectedx != -1) {
            SharedUI.dud.playAsSoundEffect(1.5f, 0.2f);
        }
    }

    public void enterState(StateBasedGame game) {
        Mouse.setGrabbed((boolean)false);
        this.backArea.setCursorSelect(false);
        if (this.selectedSetByController) {
            Mouse.setCursorPosition((int)595, (int)0);
        }
        this.regen(MapStore.getStarCount());
        boolean ball = true;
    }

    private void regen(int starCount) {
        int i;
        for (i = 0; i < 7; ++i) {
            this.availableBalls[i] = Configuration.isBallAvailable(i);
        }
        this.ballInUse = Configuration.getBallInUse();
        this.starCount = starCount;
        for (int x = 0; x < 20; ++x) {
            for (int y = 0; y < 20; ++y) {
                if (this.tokens[x][y] == null) continue;
                this.tokens[x][y].exists = MapStore.exists(x, y);
                if (MapStore.isAccessible(x, y)) {
                    this.tokens[x][y].accesible = true;
                    this.tokens[x][y].ontarget = MapStore.isOnTarget(x, y);
                    this.tokens[x][y].complete = MapStore.isComplete(x, y);
                    continue;
                }
                this.tokens[x][y].accesible = false;
                this.tokens[x][y].ontarget = false;
                this.tokens[x][y].complete = false;
            }
        }
        for (i = 0; i < this.preDef.length; ++i) {
            if (this.preDef[i] == null || this.lastStarCount >= this.preDef[i].getTarget() || starCount < this.preDef[i].getTarget()) continue;
            this.preDef[i].reset();
            this.events.add(this.preDef[i]);
        }
        this.lastStarCount = starCount;
        Configuration.setGlobalValue("lastStarCount", starCount);
        this.starCountMessage = "" + starCount;
        this.hasEnoughStars30 = MapStore.hasEnoughStars(3, 0);
        this.hasEnoughStars31 = MapStore.hasEnoughStars(3, 1);
        this.hasEnoughStars41 = MapStore.hasEnoughStars(4, 1);
        this.hasEnoughStars42 = MapStore.hasEnoughStars(4, 2);
        if (this.opened30 != MapStore.isAccessible(3, 0)) {
            this.events.add(this.createLevelEvent(3, 0));
            this.opened30 = MapStore.isAccessible(3, 0);
        }
        if (this.opened31 != MapStore.isAccessible(3, 1)) {
            this.events.add(this.createLevelEvent(3, 1));
            this.opened31 = MapStore.isAccessible(3, 1);
        }
        if (this.opened41 != MapStore.isAccessible(4, 1)) {
            this.events.add(this.createLevelEvent(4, 1));
            this.opened41 = MapStore.isAccessible(4, 1);
        }
        if (this.opened42 != MapStore.isAccessible(4, 2)) {
            this.events.add(this.createLevelEvent(4, 2));
            this.opened42 = MapStore.isAccessible(4, 2);
        }
    }

    private Event createLevelEvent(int x, int y) {
        Event e = new Event(30, "You found the entrance to", MapStore.getMap(x, y).getName(), this.levelIcon){

            public void action() {
            }
        };
        return e;
    }

    private int getStarCount() {
        return this.starCount;
    }

    private boolean onTarget(int x, int y) {
        if (x < 0 || y < 0) {
            return false;
        }
        if (this.tokens[x][y] != null) {
            return this.tokens[x][y].ontarget;
        }
        return false;
    }

    private boolean complete(int x, int y) {
        if (x < 0 || y < 0) {
            return false;
        }
        if (this.tokens[x][y] != null) {
            return this.tokens[x][y].complete;
        }
        return false;
    }

    private boolean accessible(int x, int y) {
        if (x < 0 || y < 0) {
            return false;
        }
        if (this.tokens[x][y] != null) {
            return this.tokens[x][y].accesible || this.blastOn;
        }
        return false;
    }

    private boolean exists(int x, int y) {
        if (x < 0 || y < 0) {
            return false;
        }
        if (this.tokens[x][y] != null) {
            return this.tokens[x][y].exists;
        }
        return false;
    }

    public void leaveState(StateBasedGame game) {
    }

    private abstract class Event {
        private final int IN = 1;
        private final int SHOW = 2;
        private final int OUT = 3;
        public String line1;
        public String line2;
        private float value;
        private Texture tex;
        private float offset;
        private int timer;
        private int state;
        private int viewPause = 3500;
        private int target;

        public Event(int target, String line1, String line2, Texture tex) {
            this.line1 = line1;
            this.line2 = line2;
            this.tex = tex;
            this.target = target;
            this.reset();
        }

        public int getTarget() {
            return this.target;
        }

        public void reset() {
            this.offset = Display.getDisplayMode().getWidth() + 200;
            this.state = 1;
        }

        public boolean update(int delta) {
            this.timer += delta;
            if (this.state == 1) {
                this.offset -= (float)delta * 1.0f;
                if (this.offset < 0.0f) {
                    this.offset = 0.0f;
                    this.state = 2;
                    this.timer = 0;
                }
            }
            if (this.state == 2 && this.timer > this.viewPause) {
                this.timer = 0;
                this.state = 3;
            }
            if (this.state == 3) {
                this.offset -= (float)delta * 1.0f;
                if (this.offset < (float)(-(Display.getDisplayMode().getWidth() + 200))) {
                    this.offset = -(Display.getDisplayMode().getWidth() + 200);
                    this.action();
                    LevelSelectState.this.regen(LevelSelectState.this.starCount);
                    return true;
                }
            }
            return false;
        }

        public void render() {
            GL11.glTranslatef((float)this.offset, (float)0.0f, (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)0.6f);
            LevelSelectState.this.renderRectangle(150.0f, 150.0f, 400.0f, 190.0f);
            GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.0f, (float)1.0f);
            LevelSelectState.this.renderRectangle(150.0f, 150.0f, 400.0f, 4.0f);
            LevelSelectState.this.renderRectangle(150.0f, 340.0f, 400.0f, 4.0f);
            LevelSelectState.this.renderRectangle(150.0f, 150.0f, 4.0f, 194.0f);
            LevelSelectState.this.renderRectangle(550.0f, 150.0f, 4.0f, 194.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            LevelSelectState.this.renderRectangle(151.0f, 151.0f, 400.0f, 2.0f);
            LevelSelectState.this.renderRectangle(151.0f, 341.0f, 400.0f, 2.0f);
            LevelSelectState.this.renderRectangle(151.0f, 151.0f, 2.0f, 192.0f);
            LevelSelectState.this.renderRectangle(551.0f, 151.0f, 2.0f, 192.0f);
            int xp = 150 + (400 - SharedUI.bigFontO.getWidth(this.line1)) / 2;
            SharedUI.bigFontO.drawString(xp + 3, 203, this.line1, LevelSelectState.this.gray);
            SharedUI.bigFontO.drawString(xp, 200, this.line1, Color.white);
            xp = 150 + (400 - SharedUI.bigFontO.getWidth(this.line2)) / 2;
            SharedUI.bigFontO.drawString(xp + 3, 333, this.line2, LevelSelectState.this.gray);
            SharedUI.bigFontO.drawString(xp, 330, this.line2, Color.white);
            this.tex.bind();
            int xo = 350 - this.tex.getImageWidth() / 2;
            int yo = 250 - this.tex.getImageHeight() / 2;
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex2f((float)xo, (float)yo);
            GL11.glTexCoord2f((float)0.0f, (float)this.tex.getHeight());
            GL11.glVertex2f((float)xo, (float)(yo + this.tex.getImageWidth()));
            GL11.glTexCoord2f((float)this.tex.getWidth(), (float)this.tex.getHeight());
            GL11.glVertex2f((float)(xo + this.tex.getImageHeight()), (float)(yo + this.tex.getImageWidth()));
            GL11.glTexCoord2f((float)this.tex.getWidth(), (float)0.0f);
            GL11.glVertex2f((float)(xo + this.tex.getImageHeight()), (float)yo);
            GL11.glEnd();
        }

        public abstract void action();
    }

    private class MapToken {
        public int x;
        public int y;
        public String name;
        public String prop;
        public boolean exists;
        public boolean complete;
        public boolean accesible;
        public boolean ontarget;

        public MapToken(int x, int y, String name, String prop) {
            this.x = x;
            this.y = y;
            this.name = name;
            this.prop = prop;
        }
    }
}

