/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.render.util.Color;
import org.newdawn.render.util.Tuple4;
import org.newdawn.render.window.LWJGLWindow;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.state.GameState;
import org.newdawn.state.StateBasedGame;
import org.newdawn.state.transitions.FadeInTransition;
import org.newdawn.state.transitions.FadeOutTransition;
import org.newdawn.state.transitions.Transition;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.Configuration;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapStore;
import org.newdawn.tilt.MouseOverArea;
import org.newdawn.tilt.MouseOverGroup;
import org.newdawn.tilt.Prefs;
import org.newdawn.tilt.SharedUI;
import org.newdawn.tilt.TiltController;
import org.newdawn.tilt.util.FastTrig;
import org.newdawn.util.Log;

public class InGameState
implements GameState {
    public static final int ID = 1;
    private static final float LIMIT = 20.0f;
    private LWJGLWindow window;
    private Map map;
    private float rx;
    private float ry;
    private FloatBuffer buffer = BufferUtils.createFloatBuffer((int)4);
    private FloatBuffer mcolor = BufferUtils.createFloatBuffer((int)4);
    private FloatBuffer mcolor2 = BufferUtils.createFloatBuffer((int)4);
    private FloatBuffer pos1 = new Tuple4(0.5f, 0.2f, 0.5f, 0.0f).toFloatBuffer();
    private FloatBuffer spec1 = new Tuple4(0.2f, 0.2f, 0.2f, 1.0f).toFloatBuffer();
    private FloatBuffer pos2 = new Tuple4(-0.5f, -0.2f, -0.5f, 0.0f).toFloatBuffer();
    private FloatBuffer spec2 = new Tuple4(0.2f, 0.2f, 0.2f, 1.0f).toFloatBuffer();
    private Texture paused;
    private Texture[] options = new Texture[3];
    private MouseOverArea[] boxes = new MouseOverArea[3];
    private MouseOverGroup group;
    private int selected;
    private boolean starting = true;
    private boolean entering = false;
    private float jiggle;
    private float startCounter;
    private float stopCounter;
    private boolean completing;
    private String title;
    private String secondLine;
    private String instruction;
    private boolean exitBeep = false;
    private long currentTime;
    private long bestTime;
    private long targetTime;
    private String mapName;
    private float sense;
    private GlobalEmitter emitter;
    private boolean movingBoard;
    private boolean dragToMove = true;
    private boolean autoCentre;
    private Map selectedMap;
    private boolean tracking = false;
    private boolean tooSlow = false;
    private Sound timegoneSound;
    private int blipsLeft;
    private int noMove = 0;
    private boolean moved = false;
    private long lastIndependentTime;
    private boolean reflections = true;
    private int runningSlow;
    private int lastMouseEvent;
    private Color gray = new Color(0.0f, 0.0f, 0.0f, 0.3f);
    private boolean exists;
    private Color redWarning = new Color(1.0f, 0.4f, 0.4f);
    private StringBuffer sbuffer = new StringBuffer();
    private boolean gui = true;
    private String[] times = new String[4000];

    public InGameState(LWJGLWindow window) {
        this.window = window;
        for (int i = 0; i < 4000; ++i) {
            this.times[i] = "" + (float)i / 10.0f;
            if (i >= 100) continue;
            this.times[i] = "0" + this.times[i];
        }
    }

    public void init(StateBasedGame game) throws IOException {
        GL11.glClearColor((float)0.2f, (float)0.4f, (float)0.8f, (float)0.0f);
        this.paused = TextureLoader.get().getTextureLinear("res/paused.tga");
        this.options[0] = TextureLoader.get().getTextureLinear("res/option-continue.tga");
        this.options[1] = TextureLoader.get().getTextureLinear("res/option-restart.tga");
        this.options[2] = TextureLoader.get().getTextureLinear("res/option-quit.tga");
        this.boxes[0] = new MouseOverArea(this.window, 210.0f, 300.0f, 230.0f, 40.0f);
        this.boxes[1] = new MouseOverArea(this.window, 210.0f, 350.0f, 230.0f, 40.0f);
        this.boxes[2] = new MouseOverArea(this.window, 210.0f, 400.0f, 230.0f, 40.0f);
        this.group = new MouseOverGroup("pause");
        this.group.addArea(this.boxes[0]);
        this.group.addArea(this.boxes[1]);
        this.group.addArea(this.boxes[2]);
        Mouse.setGrabbed((boolean)true);
        this.movingBoard = true;
        this.emitter = new GlobalEmitter();
        this.timegoneSound = SoundStore.get().getOgg("res/sounds/timegone.ogg");
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-28.0f);
        GL11.glEnable((int)2896);
        this.configureLighting();
    }

    public float getRX() {
        return this.rx;
    }

    public float getRY() {
        return this.ry;
    }

    public void completeLevel() {
        this.stopCounter = 0.0f;
        this.startCounter = 0.0f;
        Mouse.setGrabbed((boolean)false);
        this.movingBoard = false;
        this.starting = true;
        this.completing = true;
        this.tooSlow = false;
        if (this.currentTime - this.targetTime < 150L) {
            if (this.currentTime > this.targetTime) {
                this.currentTime = this.targetTime;
            }
            this.title = "Level Complete!";
            this.secondLine = "Finished on Target - Good Job!";
        } else if (this.currentTime < this.bestTime) {
            this.title = "Level Complete!";
            this.secondLine = "New Best Time - Well Done!";
        } else {
            this.title = "Level Complete - Go Faster!";
            this.secondLine = "Meet the target - get a star!!";
            this.tooSlow = true;
        }
        if (this.bestTime == 0L || this.currentTime < this.bestTime) {
            this.bestTime = this.currentTime;
            Configuration.setBestTime(this.mapName, this.currentTime);
        }
        this.instruction = "Click To Continue";
    }

    public void setMap(String name, Map map) {
        this.selectedMap = map;
        this.mapName = name;
        this.exists = MapStore.exists(map.getLocX(), map.getLocY());
    }

    public void reset(StateBasedGame game) {
        if (game != null && !MapStore.exists(this.selectedMap.getLocX(), this.selectedMap.getLocY())) {
            game.changeToState(8, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
            return;
        }
        this.lastIndependentTime = LWJGLWindow.getTime();
        this.blipsLeft = 4;
        this.currentTime = 0L;
        this.targetTime = 0L;
        this.bestTime = 0L;
        this.exitBeep = false;
        this.completing = false;
        this.stopCounter = 0.0f;
        this.startCounter = 0.0f;
        Mouse.setGrabbed((boolean)false);
        this.movingBoard = false;
        this.starting = true;
        if (this.map != null) {
            this.map.destroy();
            this.emitter.reset();
        }
        this.map = this.selectedMap.copy();
        this.map.create();
        this.targetTime = (long)(this.map.getTargetTime() * 1000.0f);
        this.bestTime = Configuration.getBestTime(this.mapName);
        this.title = this.map.getName();
        this.secondLine = this.map.getObjective();
        this.instruction = "Click To Start";
        this.rx = (float)FastTrig.cos(this.jiggle) * 20.0f;
        this.ry = (float)FastTrig.sin(this.jiggle) * 20.0f;
        if (!MapStore.exists(this.map.getLocX(), this.map.getLocY())) {
            this.secondLine = "Locked";
            this.instruction = "Register to Play! Click to Return";
        }
        if (game != null && !MapStore.exists(this.map.getLocX(), this.map.getLocY())) {
            game.changeToState(8, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
        }
    }

    private void configureLighting() {
        float ambient = 0.2f;
        this.buffer.put(ambient).put(ambient).put(ambient).put(1.0f);
        this.buffer.flip();
        GL11.glLightModel((int)2899, (FloatBuffer)this.buffer);
        this.mcolor.put(1.0f).put(1.0f).put(1.0f).put(1.0f);
        this.mcolor.flip();
        GL11.glMaterial((int)1028, (int)4610, (FloatBuffer)this.mcolor);
        this.mcolor2.put(0.0f).put(0.0f).put(0.0f).put(1.0f);
        this.mcolor2.flip();
        GL11.glMaterial((int)1028, (int)5632, (FloatBuffer)this.mcolor2);
        GL11.glColorMaterial((int)1028, (int)5634);
        GL11.glEnable((int)2903);
        GL11.glLight((int)16384, (int)4611, (FloatBuffer)this.pos1);
        GL11.glLight((int)16384, (int)4610, (FloatBuffer)this.spec1);
        GL11.glEnable((int)16384);
        GL11.glLight((int)16385, (int)4611, (FloatBuffer)this.pos2);
        GL11.glLight((int)16385, (int)4610, (FloatBuffer)this.spec2);
        GL11.glEnable((int)16385);
        GL11.glEnable((int)32826);
    }

    private void renderRectangle(float x, float y, float width, float height) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glEnd();
    }

    public void reinit(StateBasedGame game) throws IOException {
    }

    public void render(StateBasedGame game, int delta) {
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-28.0f);
        GL11.glEnable((int)2896);
        boolean x = false;
        boolean y = false;
        float width = this.map.getMaxX() - this.map.getMinX();
        float height = this.map.getMaxY() - this.map.getMinY();
        float offsetx = -this.map.getMinX() - width / 2.0f;
        float offsety = -this.map.getMinY() - height / 2.0f;
        if (this.tracking) {
            Ball ball = this.map.getBall();
            GL11.glTranslatef((float)(-ball.getShape().getX() - (offsetx - 1.0f)), (float)(-ball.getShape().getY() - (offsety - 1.0f)), (float)0.0f);
        }
        GL11.glRotatef((float)this.ry, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.rx, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)offsetx, (float)offsety, (float)0.0f);
        this.map.renderFloor(delta);
        if (this.reflections) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glCullFace((int)1028);
            GL11.glDepthFunc((int)518);
            GL11.glDepthMask((boolean)false);
            this.map.renderBits(delta, true);
            GL11.glDepthMask((boolean)true);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
        }
        GL11.glCullFace((int)1029);
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)3042);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.map.renderBits(delta, false);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.map.renderFloorOther(delta);
        this.emitter.render(delta);
        if (!this.gui) {
            return;
        }
        this.window.enterOrtho(600, 600);
        int resYOffset = (this.window.getHeight() - 600) / 2;
        if (this.exists) {
            String time = this.timeToString(this.currentTime);
            SharedUI.bigFontO.drawString(258, 38 - resYOffset, time, this.gray);
            boolean red = false;
            if (this.targetTime - this.currentTime < 5000L) {
                int mod = (int)((this.targetTime - this.currentTime) % 400L);
                boolean bl = red = mod > 200;
            }
            if (this.currentTime - this.targetTime < 100L && !red) {
                SharedUI.bigFontO.drawString(255, 35 - resYOffset, time, Color.white);
            } else {
                SharedUI.bigFontO.drawString(255, 35 - resYOffset, time, this.redWarning);
            }
            if (this.noMove > 3000 && !this.moved && this.dragToMove) {
                String text = "Drag the mouse to tilt!";
                float ang = (float)(this.noMove - 3000) / 200.0f;
                int yp = (int)(FastTrig.sin(ang) * 15.0);
                int xp = (600 - SharedUI.bigFontO.getWidth(text)) / 2;
                SharedUI.bigFontO.drawString(xp + 3, 103 + yp, text, this.gray);
                SharedUI.bigFontO.drawString(xp, 100 + yp, text, Color.white);
            }
            time = this.timeToString(this.targetTime);
            SharedUI.smallFontO.drawString(458, 19 - resYOffset, "TARGET", this.gray);
            SharedUI.smallFontO.drawString(455, 17 - resYOffset, "TARGET", Color.white);
            SharedUI.bigFontO.drawString(448, 50 - resYOffset, time, this.gray);
            SharedUI.bigFontO.drawString(445, 47 - resYOffset, time, Color.white);
            time = this.timeToString(this.bestTime);
            SharedUI.smallFontO.drawString(88, 19 - resYOffset, "BEST", this.gray);
            SharedUI.smallFontO.drawString(85, 17 - resYOffset, "BEST", Color.white);
            SharedUI.bigFontO.drawString(68, 50 - resYOffset, time, this.gray);
            SharedUI.bigFontO.drawString(65, 47 - resYOffset, time, Color.white);
        }
        if (this.starting || this.entering) {
            int resXOffset = (this.window.getWidth() - 600) / 2;
            int left = -resXOffset;
            int right = this.window.getWidth();
            int yoffset = 0;
            Texture.bindNone();
            GL11.glEnable((int)3042);
            if (this.completing) {
                if (this.tooSlow) {
                    GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.7f);
                } else {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)0.7f);
                }
            } else {
                GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.7f);
                if (!this.exists) {
                    GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)0.7f);
                    yoffset = -230;
                }
            }
            this.renderRectangle((float)left + (float)right * this.stopCounter, 255 + yoffset, (float)right * this.startCounter, 95.0f);
            if (this.completing) {
                if (this.tooSlow) {
                    GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
                } else {
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)0.0f);
                }
            } else {
                GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
                if (!this.exists) {
                    GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
                }
            }
            this.renderRectangle((float)left + (float)right * this.stopCounter, 253 + yoffset, (float)right * this.startCounter, 2.0f);
            this.renderRectangle((float)left + (float)right * this.stopCounter, 350 + yoffset, (float)right * this.startCounter, 2.0f);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (this.startCounter >= 1.0f && this.stopCounter == 0.0f) {
                int xp = (600 - SharedUI.bigFontO.getWidth(this.title)) / 2;
                SharedUI.bigFontO.drawString(xp, 291 + yoffset, this.title, this.gray);
                SharedUI.bigFontO.drawString(xp, 288 + yoffset, this.title, Color.white);
                String line = this.secondLine;
                xp = (600 - SharedUI.smallFontO.getWidth(line)) / 2;
                SharedUI.smallFontO.drawString(xp, 311 + yoffset, line, this.gray);
                SharedUI.smallFontO.drawString(xp, 308 + yoffset, line, Color.white);
                line = this.instruction;
                xp = (600 - SharedUI.smallFontO.getWidth(line)) / 2;
                SharedUI.smallFontO.drawString(xp, 349 + yoffset, line, this.gray);
                SharedUI.smallFontO.drawString(xp, 346 + yoffset, line, Color.white);
                if (this.completing) {
                    this.renderPause(true);
                }
            }
        }
        if (!(this.movingBoard || this.starting || this.entering)) {
            this.renderPause(false);
        }
        this.window.leaveOrtho();
    }

    private String timeToString(long time) {
        if ((time /= 100L) < 4000L) {
            return this.times[(int)time];
        }
        float value = (float)time / 10.0f;
        this.sbuffer.setLength(0);
        this.sbuffer.append(Float.toString(value));
        if (this.sbuffer.length() < 4) {
            this.sbuffer.insert(0, "0");
        }
        return this.sbuffer.toString();
    }

    public void renderPause(boolean restartOnly) {
        if (!MapStore.exists(this.map.getLocX(), this.map.getLocY())) {
            return;
        }
        int resXOffset = (this.window.getWidth() - 600) / 2;
        int resYOffset = (this.window.getHeight() - 600) / 2;
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int i = 0;
        float v = 0.0f;
        if (!restartOnly) {
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2f);
            Texture.bindNone();
            this.renderRectangle(-resXOffset, -resYOffset, 600 + resXOffset * 2, 600 + resYOffset * 2);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.paused.bind();
            this.renderRectangle(240.0f, 170.0f, 128.0f, 128.0f);
            i = 0;
            v = 0.75f + this.boxes[i].getValue();
            GL11.glColor4f((float)v, (float)v, (float)v, (float)1.0f);
            this.options[i].bind();
            this.renderRectangle(182.0f, 300 + i * 50, 256.0f, 64.0f);
            i = 2;
            v = 0.75f + this.boxes[i].getValue();
            GL11.glColor4f((float)v, (float)v, (float)v, (float)1.0f);
            this.options[i].bind();
            this.renderRectangle(250.0f, 305 + i * 50, 128.0f, 64.0f);
        }
        i = 1;
        v = 0.75f + this.boxes[i].getValue();
        GL11.glColor4f((float)v, (float)v, (float)v, (float)1.0f);
        this.options[i].bind();
        this.renderRectangle(182.0f, 300 + i * 50, 256.0f, 64.0f);
        GL11.glDisable((int)3042);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void updatePause(int delta, boolean restartOnly) {
        if ((this.starting || this.entering) && !this.completing) {
            return;
        }
        this.group.update();
        int x = Mouse.getX();
        int y = 600 - Mouse.getY();
        int oldSelected = this.selected;
        this.selected = -1;
        for (int i = 0; i < this.options.length; ++i) {
            if (restartOnly && i != 1 || !this.boxes[i].considerMouse(delta)) continue;
            this.selected = i;
            if (this.selected == oldSelected) continue;
            SharedUI.playOver();
        }
    }

    public void update(StateBasedGame game, int delta) {
        if (this.window.getFPS() < 30) {
            this.runningSlow += delta;
            if (this.runningSlow > 2000) {
                this.reflections = false;
            }
        }
        long independentDelta = LWJGLWindow.getTime() - this.lastIndependentTime;
        this.lastIndependentTime = LWJGLWindow.getTime();
        if (this.movingBoard) {
            if (!this.map.ballsThroughExit()) {
                this.currentTime += independentDelta;
                if (this.blipsLeft >= 0 && this.targetTime - this.currentTime < (long)(this.blipsLeft * 1000)) {
                    if (this.blipsLeft == 0) {
                        this.timegoneSound.playAsSoundEffect(0.8f, 1.0f);
                    } else {
                        this.timegoneSound.playAsSoundEffect(0.6f, 1.0f);
                    }
                    --this.blipsLeft;
                }
            }
            this.map.update(this.emitter, delta, this.rx, this.ry);
            if (!this.map.ballsDead()) {
                float off = 0.1f + this.sense * 0.1f;
                float dx = (float)Mouse.getDX() * off;
                float dy = (float)(-Mouse.getDY()) * off;
                if (TiltController.isEnabled()) {
                    if (TiltController.isAnalgoue()) {
                        float xaxis = TiltController.getXAxis();
                        float yaxis = TiltController.getYAxis();
                        this.ry = (float)(Math.pow(xaxis, 3.0) * 20.0);
                        this.rx = (float)(Math.pow(yaxis, 3.0) * 20.0);
                        if (xaxis < 0.0f && this.ry > 0.0f) {
                            this.ry = -this.ry;
                        }
                        if (yaxis < 0.0f && this.rx > 0.0f) {
                            this.rx = -this.rx;
                        }
                    } else {
                        float adj = 5.5f;
                        if (TiltController.isKeyboard()) {
                            adj = 5.5f;
                        }
                        this.ry += TiltController.getXAxis() * (float)delta * off * 0.4f * adj;
                        this.rx += TiltController.getYAxis() * (float)delta * off * 0.4f * adj;
                    }
                }
                if (TiltController.isKeyboard() && (Mouse.isButtonDown((int)0) || !this.dragToMove)) {
                    this.ry += dx;
                    this.rx += dy;
                }
                this.ry = Math.min(20.0f, this.ry);
                this.ry = Math.max(-20.0f, this.ry);
                this.rx = Math.min(20.0f, this.rx);
                this.rx = Math.max(-20.0f, this.rx);
                if (this.autoCentre && this.dragToMove && !Mouse.isButtonDown((int)0)) {
                    this.rx *= 0.95f;
                    this.ry *= 0.95f;
                }
            }
            if (this.map.ballsFinished()) {
                this.completeLevel();
            }
            if (this.map.ballsFallComplete()) {
                this.reset(game);
            }
            if (this.rx != 0.0f || this.ry != 0.0f) {
                this.moved = true;
            }
            if (!this.moved) {
                this.noMove += delta;
            }
            this.emitter.update(delta);
        } else {
            if (this.entering) {
                this.stopCounter += (float)delta * 0.003f;
                this.stopCounter = Math.min(this.stopCounter, 1.0f);
                this.rx *= 0.95f;
                this.ry *= 0.95f;
                if (this.stopCounter >= 1.0f) {
                    Mouse.setGrabbed((boolean)true);
                    this.movingBoard = true;
                    this.entering = false;
                    this.rx = 0.0f;
                    this.ry = 0.0f;
                    this.lastMouseEvent = 0;
                    return;
                }
            }
            if (this.starting) {
                this.startCounter += (float)delta * 0.003f;
                this.startCounter = Math.min(this.startCounter, 1.0f);
                if (!this.completing) {
                    this.jiggle += (float)delta * 0.0015f;
                    this.rx = (float)FastTrig.cos(this.jiggle) * 20.0f;
                    this.ry = (float)FastTrig.sin(this.jiggle) * 20.0f;
                }
            } else {
                this.updatePause(delta, false);
            }
            if (this.completing) {
                this.updatePause(delta, true);
            }
        }
        if (this.movingBoard) {
            if (Keyboard.isKeyDown((int)1)) {
                Mouse.setGrabbed((boolean)false);
                this.movingBoard = false;
                SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            }
            if (Keyboard.isKeyDown((int)57) || Keyboard.isKeyDown((int)19)) {
                this.reset(game);
                this.movingBoard = false;
                SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            }
        }
        this.lastMouseEvent += delta;
        if (this.lastMouseEvent > 100) {
            while (Mouse.next()) {
                if (Mouse.getEventButton() < 0 || !Mouse.getEventButtonState()) continue;
                this.lastMouseEvent = 0;
                if (this.movingBoard) {
                    if (Mouse.getEventButton() != 1 && this.dragToMove) continue;
                    Mouse.setGrabbed((boolean)false);
                    this.movingBoard = false;
                    SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
                } else {
                    this.controlPressed(game);
                }
                break;
            }
        } else {
            while (Mouse.next()) {
            }
        }
        if (TiltController.isEnabled() && TiltController.buttonPressed()) {
            if (this.movingBoard) {
                Mouse.setGrabbed((boolean)false);
                this.movingBoard = false;
                SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            } else {
                this.controlPressed(game);
            }
        }
    }

    public Map getMap() {
        return this.map;
    }

    private void controlPressed(StateBasedGame game) {
        if (this.completing) {
            if (!this.exitBeep) {
                this.exitBeep = true;
                SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            }
            if (this.selected == 1) {
                this.reset(game);
            } else {
                game.changeToState(8, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
            }
            return;
        }
        if (this.starting || this.entering) {
            this.starting = false;
            if (!MapStore.exists(this.map.getLocX(), this.map.getLocY())) {
                game.changeToState(8, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
                return;
            }
            if (!this.entering) {
                this.entering = true;
                SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            }
        } else {
            Mouse.setGrabbed((boolean)true);
            this.movingBoard = true;
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            if (this.selected == 1) {
                this.reset(game);
            }
            if (this.selected == 2) {
                game.changeToState(8, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
            }
        }
    }

    public void startLevel() {
        this.entering = true;
        this.gui = false;
    }

    public void enterState(StateBasedGame game) {
        this.dragToMove = Configuration.getGlobalValue("dragmove", 1.0f) != 0.0f;
        this.sense = Configuration.getGlobalValue("sense", 0.5f);
        this.autoCentre = Configuration.getGlobalValue("centre", 1.0f) != 0.0f;
        this.reset(null);
        this.lastMouseEvent = 1000;
        this.runningSlow = 0;
        TiltController.ALL = Configuration.prefs.getString("r3", null) != null;
    }

    public void leaveState(StateBasedGame game) {
        String ID = "id";
        float value = Configuration.prefs.getLong(ID, 0L);
        if (value != (float)Prefs.levels.getAbsolutePath().hashCode()) {
            Configuration.remove("r1");
            int pop = Prefs.levels.hashCode();
            Configuration.remove("r2");
            ID = null;
            value = 0.0f;
            Configuration.remove("r3");
            Log.log((String)"Getting Rid Of 2");
        }
        if (MapStore.isAccessible(0, 50)) {
            System.exit(0);
        }
    }
}

