/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.models.obj.ObjLoader;
import org.newdawn.render.models.obj.ObjModel;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.render.util.Color;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.util.Log;

public class GravityProducer
extends MapElement {
    private static ObjModel model1;
    private static ObjModel model2;
    private static ObjModel model3;
    private static final float LIFE = 600.0f;
    private static final float POWER = 0.006f;
    private static Texture texture;
    private float x;
    private float y;
    private String data;
    private Map map;
    private Body body;
    private int id;
    private boolean init;
    private float ang;
    private ArrayList balls = new ArrayList();

    public static void init() throws IOException {
        model3 = ObjLoader.loadObj((String)"res/g_base.obj");
        model1 = ObjLoader.loadObj((String)"res/g_centre.obj");
        model2 = ObjLoader.loadObj((String)"res/g_cover.obj");
        texture = TextureLoader.get().getTextureLinear("res/metal.tga");
    }

    public GravityProducer(Map map, float x, float y, String data) throws IOException {
        this.x = x;
        this.y = y;
        this.data = data;
        this.map = map;
        this.body = new Body(new Circle(x, y, 0.6f));
    }

    public Body getBody() {
        return this.body;
    }

    public Shape getShape() {
        return this.body.getShape();
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int getID() {
        return this.id;
    }

    public void createImpl() {
    }

    public void destroy() {
    }

    public void renderImpl(int delta, boolean reflection) {
        if (reflection) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        Map.render(texture, model3, null, true, 1.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.06666667f);
        Texture.bindNone();
        GL11.glRotatef((float)this.ang, (float)0.0f, (float)0.0f, (float)1.0f);
        Map.render(null, model1, Color.green, false);
        GL11.glRotatef((float)(-this.ang), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)0.4f, (float)0.9f, (float)1.0f, (float)0.3f);
        model2.render();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
        this.ang += (float)delta * 0.6f;
        this.map.getElements(Ball.class, this.balls);
        for (int i = 0; i < this.balls.size(); ++i) {
            float dy;
            Ball ball = (Ball)this.balls.get(i);
            float dx = this.x - ball.getX();
            float len2 = dx * dx + (dy = this.y - ball.getY()) * dy;
            if (!(len2 < 25.0f)) continue;
            ball.adjustVelocity((dx /= len2) * 0.006f * (float)delta, (dy /= len2) * 0.006f * (float)delta);
        }
    }

    public boolean hit(Ball ball, float depth) {
        return false;
    }

    public MapElement copy(Map map) {
        try {
            return new GravityProducer(map, this.x, this.y, this.data);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public boolean finished() {
        return false;
    }
}

