/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.particles.Affect;
import org.newdawn.render.particles.Emitter;
import org.newdawn.render.particles.ParticleEngine;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.tilt.effect.ParticleEffect;
import org.newdawn.tilt.effect.ParticleProvider;

public class GlobalEmitter
implements Emitter,
Affect,
ParticleProvider {
    private ParticleEffect[] effects = new ParticleEffect[2000];
    private ParticleEngine engine;
    private ArrayList added = new ArrayList();
    private Texture texture = TextureLoader.get().getTextureLinear("res/particle1.tga");

    public GlobalEmitter() throws IOException {
        this.reset();
    }

    public void reset() {
        this.effects = new ParticleEffect[2000];
        this.added = new ArrayList();
        this.engine = new ParticleEngine(1000, this.texture, (Emitter)this, true, false, 1);
    }

    public void update(int delta) {
        this.engine.update(delta);
    }

    public void render(int delta) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        this.engine.render(delta, false);
        GL11.glEnable((int)2896);
    }

    public void init(ParticleEngine engine) {
        this.engine = engine;
        engine.addAffect((Affect)this);
    }

    public void addEffect(ParticleEffect effect) {
        this.added.add(effect);
    }

    public void update(int delta, ParticleEngine engine) {
        for (int i = 0; i < this.added.size(); ++i) {
            ParticleEffect effect = (ParticleEffect)this.added.get(i);
            if (effect.finished()) {
                this.added.remove(effect);
                --i;
                continue;
            }
            effect.update(this, engine, delta);
        }
    }

    public void updateParticle(int i, int delta, ParticleEngine engine, int life) {
        if (this.effects[i] != null) {
            this.effects[i].updateParticle(i, delta, engine, life);
        }
    }

    public int getParticle(ParticleEffect effect, int life) {
        int index = this.engine.getParticle(life);
        if (index != -1) {
            this.effects[index] = effect;
        }
        return index;
    }
}

