/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.models.obj.ObjLoader;
import org.newdawn.render.models.obj.ObjModel;
import org.newdawn.render.particles.ParticleEngine;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.effect.ParticleEffect;
import org.newdawn.tilt.effect.ParticleProvider;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.tilt.physics.DynamicBody;
import org.newdawn.tilt.util.FastTrig;
import org.newdawn.util.Log;

public class Fuggle
extends MapElement
implements ParticleEffect {
    private static Texture normal;
    private static Texture electro;
    private static ObjModel model;
    private static ObjModel modelbase;
    private static Sound pop;
    private static Sound spark;
    private Circle bounds;
    private Circle floorBounds;
    private float x;
    private float y;
    private int list;
    private DynamicBody body;
    private Map map;
    private String id;
    private float ang;
    private float dx;
    private float dy;
    private boolean left;
    private int ignore;
    private boolean done;
    private boolean exploding = false;
    private int explodeTimer;
    private boolean first = true;
    private GlobalEmitter emitter;
    private float lastx;
    private float lasty;
    private Texture texture;
    private boolean electroFuggle;
    private float loop = 0.0f;
    private float scale = 1.0f;

    public static void init() throws IOException {
        spark = SoundStore.get().getOgg("res/sounds/spark.ogg");
        pop = SoundStore.get().getOgg("res/sounds/ballpop.ogg");
        normal = TextureLoader.get().getTextureLinear("res/fuggle.tga");
        electro = TextureLoader.get().getTextureLinear("res/efuggle.tga");
        model = ObjLoader.loadObj((String)"res/fuggle.obj");
        modelbase = ObjLoader.loadObj((String)"res/fuggle-base.obj");
    }

    public Fuggle(Map map, float x, float y, String id) throws IOException {
        if (id.indexOf("big") >= 0) {
            this.scale = 3.0f;
        }
        this.bounds = new Circle(x, y, 0.4f * this.scale);
        this.floorBounds = new Circle(x, y, 0.1f * this.scale);
        this.x = x;
        this.y = y;
        this.map = map;
        this.id = id;
        if (id.indexOf("left") >= 0) {
            this.left = true;
        }
        if (id.indexOf("electro") >= 0) {
            this.electroFuggle = true;
        }
        this.texture = normal;
        if (this.electroFuggle) {
            this.texture = electro;
        }
        this.body = new DynamicBody(this.bounds, 0.2f, 0.2f);
        this.body.setPushable(false);
        this.dx = 0.0f;
        this.dy = 1.0f;
    }

    private void explode() {
        if (!this.exploding) {
            pop.playAsSoundEffect(1.5f, 1.0f);
            this.exploding = true;
            this.body.setActive(false);
            this.explodeTimer = 1000;
        }
    }

    public void blocked() {
        if (this.left) {
            if (this.dx != 0.0f) {
                this.dy = -this.dx;
                this.dx = 0.0f;
                return;
            }
            if (this.dy != 0.0f) {
                this.dx = this.dy;
                this.dy = 0.0f;
                return;
            }
        } else {
            if (this.dx != 0.0f) {
                this.dy = this.dx;
                this.dx = 0.0f;
                return;
            }
            if (this.dy != 0.0f) {
                this.dx = -this.dy;
                this.dy = 0.0f;
                return;
            }
        }
    }

    public Body getBody() {
        return this.body;
    }

    public void createImpl() {
    }

    public void destroy() {
    }

    public Shape getShape() {
        return this.bounds;
    }

    public void renderImpl(int delta, boolean reflection) {
        if (this.exploding) {
            return;
        }
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.6f);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        GL11.glRotatef((float)this.ang, (float)0.0f, (float)0.0f, (float)1.0f);
        if (reflection) {
            this.texture.bind();
            modelbase.render();
        } else {
            Map.render(this.texture, model, null, true, this.scale == 1.0f ? 1.1f : 1.03f);
        }
        GL11.glRotatef((float)(-this.ang), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScalef((float)(1.0f / this.scale), (float)(1.0f / this.scale), (float)(1.0f / this.scale));
        GL11.glTranslatef((float)(-this.x), (float)(-this.y), (float)-0.6f);
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
        if (this.emitter == null) {
            this.emitter = emitter;
            emitter.addEffect(this);
        }
        if (this.exploding) {
            this.explodeTimer -= delta;
            if (this.explodeTimer < 0) {
                this.map.removeItem(this);
                return;
            }
        }
        this.ang += (float)delta * 0.3f;
        this.loop -= (float)delta * 0.05f;
        this.x = this.bounds.getX();
        this.y = this.bounds.getY();
        if (this.x == this.lastx && this.y == this.lasty) {
            this.blocked();
        }
        this.lastx = this.x;
        this.lasty = this.y;
        if (this.exploding || this.done) {
            this.body.setVelocity(0.0f, 0.0f);
        } else {
            this.body.setVelocity(this.dx * 0.3f, this.dy * 0.3f);
            if (this.ignore < 0) {
                this.floorBounds.setX(this.bounds.getX());
                this.floorBounds.setY(this.bounds.getY());
                if (!this.map.onFloor(null, this.floorBounds)) {
                    this.blocked();
                    this.ignore = 150;
                }
            }
            this.ignore -= delta;
        }
    }

    public boolean hit(Ball other, float depth) {
        if (other.isPowerOn()) {
            this.explode();
            return true;
        }
        if (this.scale != 1.0f) {
            float dx = this.x - other.getX();
            float dy = this.y - other.getY();
            other.adjustVelocity(dx * 1.15f, dy * 1.15f);
        }
        if (this.electroFuggle && !this.done) {
            other.explode();
            spark.playAsSoundEffect(1.0f, 1.0f);
            this.done = true;
        }
        return false;
    }

    public MapElement copy(Map map) {
        try {
            return new Fuggle(map, this.x, this.y, this.id);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public void update(ParticleProvider provider, ParticleEngine engine, int delta) {
        int p;
        int i;
        if (this.electroFuggle) {
            for (i = 0; i < 4; ++i) {
                p = provider.getParticle(this, 50);
                if (p < 0) continue;
                float ang = (float)((double)i * Math.PI / 2.0) + this.loop;
                float rad = 0.4f;
                float x = (float)((double)this.bounds.getX() + FastTrig.sin(ang) * (double)(rad += (float)Math.random() * 0.3f));
                float y = (float)((double)this.bounds.getY() + FastTrig.cos(ang) * (double)rad);
                float offset = 0.3f + (float)Math.random() * 0.7f;
                engine.setColor(p, offset, offset, 1.0f, 1.0f);
                engine.setSize(p, 0.2f);
                engine.setVelocity(p, 0.0f, 0.0f, 0.0f);
                engine.setPos(p, x, y, 0.3f);
            }
        }
        if (this.exploding && this.first) {
            this.first = false;
            for (i = 0; i < 100; ++i) {
                p = provider.getParticle(this, 1000);
                if (p < 0) continue;
                this.x = this.bounds.getX();
                this.y = this.bounds.getY();
                float offset = 0.5f + (float)Math.random() * 0.5f;
                engine.setColor(p, 1.0f, offset, offset, 1.0f);
                engine.setSize(p, 0.4f);
                float ang = (float)(Math.random() * Math.PI * 2.0);
                float speed = (float)Math.random() * 3.0f;
                engine.setVelocity(p, (float)FastTrig.cos(ang) * speed, (float)FastTrig.sin(ang) * speed, 0.0f);
                engine.setPos(p, this.x, this.y, 0.4f + (float)Math.random() * 0.2f);
            }
        }
    }

    public void updateParticle(int index, int delta, ParticleEngine engine, int life) {
        float fade = (float)delta * -0.002f;
        if (this.exploding) {
            engine.adjustColor(index, 0.0f, fade, fade, fade);
            engine.scaleVelocity(index, 0.99f, 0.99f, 1.0f);
        } else {
            engine.adjustColor(index, fade * 3.0f, fade * 3.0f, 0.0f, fade * 3.0f);
            engine.setVelocity(index, this.body.getVelocityX(), this.body.getVelocityY(), 0.0f);
        }
    }

    public boolean finished() {
        return this.explodeTimer < 0;
    }
}

