/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.FloorStyle;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.AABox;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.tilt.util.FastTrig;
import org.newdawn.util.Log;

public class Floor
extends MapElement {
    private static Sound snap;
    private static Sound click;
    private AABox box;
    private Texture texture;
    private float h;
    private int top;
    private int edges;
    private FloorStyle style;
    private String data;
    private boolean fall;
    private float z = 0.0f;
    private float vz = 0.0f;
    private int fallTimer = 500;
    private boolean startFall = false;
    private float wiggle;
    private int fadeTimer = 0;
    private boolean fader = false;
    private boolean faded = false;
    private float ox;
    private float oy;
    private String id;
    private ArrayList moves = new ArrayList();
    private int currentMove = 0;
    private boolean wood;
    private float lastMoveX;
    private float lastMoveY;

    public static void init() throws IOException {
        snap = SoundStore.get().getOgg("res/sounds/snap.ogg");
        click = SoundStore.get().getOgg("res/sounds/floorclick2.ogg");
    }

    protected Floor(String id) {
        this.id = id;
        this.processMovement(id);
    }

    public Floor(String id, float x, float y, float width, float height, float h, FloorStyle style, String data) throws IOException {
        this.id = id;
        this.processMovement(id);
        this.box = new AABox(x, y, width, height);
        if (data == null) {
            data = "";
        }
        this.data = data;
        if (data.equals("fall")) {
            this.fall = true;
        } else if (data.startsWith("fade")) {
            this.fadeTimer = Integer.parseInt(data.substring(5));
            this.fader = true;
            this.ox = x;
            this.oy = y;
        } else if (data.startsWith("step")) {
            StringTokenizer tokens = new StringTokenizer(data.substring(5), ",");
            this.zoffset = Float.parseFloat(tokens.nextToken());
            if (tokens.hasMoreTokens()) {
                h = Float.parseFloat(tokens.nextToken());
            }
        }
        if (this.moves.size() > 0 || width < 0.8f || height < 0.8f) {
            this.wood = true;
            style = new FloorStyle("res/crate.tga", 1.0f);
        }
        this.style = style;
        this.h = -h;
        this.texture = style.getTexture();
    }

    private void processMovement(String script) {
        if (script == null) {
            return;
        }
        if (script.indexOf("fade") >= 0) {
            return;
        }
        if (script.indexOf("fall") >= 0) {
            return;
        }
        if (script.indexOf("step") >= 0) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(script, ",");
        while (tokens.hasMoreTokens()) {
            String command = tokens.nextToken();
            float size = Float.parseFloat(tokens.nextToken());
            if (command.equals("left")) {
                this.moves.add(new Move(-size, 0.0f, 0.0f));
                continue;
            }
            if (command.equals("right")) {
                this.moves.add(new Move(size, 0.0f, 0.0f));
                continue;
            }
            if (command.equals("up")) {
                this.moves.add(new Move(0.0f, -size, 0.0f));
                continue;
            }
            if (command.equals("down")) {
                this.moves.add(new Move(0.0f, size, 0.0f));
                continue;
            }
            if (command.equals("wait")) {
                this.moves.add(new Move(0.0f, 0.0f, size));
                continue;
            }
            Log.log((String)("Unrecoginised command: " + command));
        }
    }

    public float getZ() {
        return this.zoffset;
    }

    public Body getBody() {
        return null;
    }

    public void createImpl() {
        this.top = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.top, (int)4864);
        this.renderBox();
        GL11.glEndList();
        this.edges = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.edges, (int)4864);
        this.renderEdges();
        GL11.glEndList();
    }

    public void destroy() {
        GL11.glDeleteLists((int)this.top, (int)1);
        GL11.glDeleteLists((int)this.edges, (int)1);
    }

    public Shape getShape() {
        return this.box;
    }

    public void renderBox() {
        AABox box = new AABox(0.0f, 0.0f, this.box.getWidth(), this.box.getHeight());
        float xscale = 0.5f * this.style.getTextureScale();
        float yscale = 0.5f * this.style.getTextureScale();
        AABox tbox = this.box;
        if (this.wood) {
            tbox = box;
            if (box.getWidth() < 0.8f) {
                xscale = 0.1f;
                yscale = 0.5f;
            }
            if (box.getHeight() < 0.8f) {
                yscale = 0.1f;
                xscale = 0.5f;
            }
        }
        GL11.glBegin((int)7);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTexCoord2f((float)(tbox.getX() * xscale), (float)(tbox.getY() * yscale));
        GL11.glVertex3f((float)box.getX(), (float)box.getY(), (float)0.0f);
        GL11.glTexCoord2f((float)(tbox.getX2() * xscale), (float)(tbox.getY() * yscale));
        GL11.glVertex3f((float)box.getX2(), (float)box.getY(), (float)0.0f);
        GL11.glTexCoord2f((float)(tbox.getX2() * xscale), (float)(tbox.getY2() * yscale));
        GL11.glVertex3f((float)box.getX2(), (float)box.getY2(), (float)0.0f);
        GL11.glTexCoord2f((float)(tbox.getX() * xscale), (float)(tbox.getY2() * yscale));
        GL11.glVertex3f((float)box.getX(), (float)box.getY2(), (float)0.0f);
        GL11.glEnd();
    }

    public void renderEdges() {
        float scale;
        AABox box = new AABox(0.0f, 0.0f, this.box.getWidth(), this.box.getHeight());
        float dodge = 0.0f;
        float scale2 = scale = 0.5f * this.style.getTextureScale();
        AABox tbox = this.box;
        if (this.wood) {
            tbox = box;
            if (box.getWidth() < 0.8f || box.getHeight() < 0.8f) {
                scale = 0.1f;
            }
        }
        GL11.glBegin((int)7);
        float xdam = box.getY() % 2.0f;
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)((tbox.getX() + xdam) * scale), (float)0.0f);
        GL11.glVertex3f((float)box.getX(), (float)box.getY(), (float)dodge);
        GL11.glTexCoord2f((float)((tbox.getX() + xdam) * scale), (float)(this.h * scale2));
        GL11.glVertex3f((float)box.getX(), (float)box.getY(), (float)this.h);
        GL11.glTexCoord2f((float)((tbox.getX2() + xdam) * scale), (float)(this.h * scale2));
        GL11.glVertex3f((float)box.getX2(), (float)box.getY(), (float)this.h);
        GL11.glTexCoord2f((float)((tbox.getX2() + xdam) * scale), (float)0.0f);
        GL11.glVertex3f((float)box.getX2(), (float)box.getY(), (float)dodge);
        xdam = box.getX2() % 2.0f + 1.0f;
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)((tbox.getX() + xdam) * scale), (float)0.0f);
        GL11.glVertex3f((float)box.getX(), (float)box.getY2(), (float)dodge);
        GL11.glTexCoord2f((float)((tbox.getX2() + xdam) * scale), (float)0.0f);
        GL11.glVertex3f((float)box.getX2(), (float)box.getY2(), (float)dodge);
        GL11.glTexCoord2f((float)((tbox.getX2() + xdam) * scale), (float)(this.h * scale2));
        GL11.glVertex3f((float)box.getX2(), (float)box.getY2(), (float)this.h);
        GL11.glTexCoord2f((float)((tbox.getX() + xdam) * scale), (float)(this.h * scale2));
        GL11.glVertex3f((float)box.getX(), (float)box.getY2(), (float)this.h);
        xdam = box.getX() % 2.0f;
        GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)((tbox.getY() + xdam) * scale), (float)0.0f);
        GL11.glVertex3f((float)box.getX(), (float)box.getY(), (float)dodge);
        GL11.glTexCoord2f((float)((tbox.getY2() + xdam) * scale), (float)0.0f);
        GL11.glVertex3f((float)box.getX(), (float)box.getY2(), (float)dodge);
        GL11.glTexCoord2f((float)((tbox.getY2() + xdam) * scale), (float)(this.h * scale2));
        GL11.glVertex3f((float)box.getX(), (float)box.getY2(), (float)this.h);
        GL11.glTexCoord2f((float)((tbox.getY() + xdam) * scale), (float)(this.h * scale2));
        GL11.glVertex3f((float)box.getX(), (float)box.getY(), (float)this.h);
        xdam = box.getX2() % 2.0f + 1.0f;
        GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)((tbox.getY() + xdam) * scale), (float)0.0f);
        GL11.glVertex3f((float)box.getX2(), (float)box.getY(), (float)dodge);
        GL11.glTexCoord2f((float)((tbox.getY() + xdam) * scale), (float)(this.h * scale2));
        GL11.glVertex3f((float)box.getX2(), (float)box.getY(), (float)this.h);
        GL11.glTexCoord2f((float)((tbox.getY2() + xdam) * scale), (float)(this.h * scale2));
        GL11.glVertex3f((float)box.getX2(), (float)box.getY2(), (float)this.h);
        GL11.glTexCoord2f((float)((tbox.getY2() + xdam) * scale), (float)0.0f);
        GL11.glVertex3f((float)box.getX2(), (float)box.getY2(), (float)dodge);
        GL11.glEnd();
    }

    public void renderImpl(int delta, boolean reflection) {
        if (this.fader && this.faded) {
            return;
        }
        if (this.wood) {
            return;
        }
        this.renderTop();
    }

    private void renderTop() {
        GL11.glTranslatef((float)this.box.getX(), (float)this.box.getY(), (float)this.z);
        if (this.z < 0.0f) {
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f + this.z / 20.0f));
        }
        this.texture.bind();
        GL11.glCallList((int)this.top);
        GL11.glTranslatef((float)(-this.box.getX()), (float)(-this.box.getY()), (float)(-this.z));
        if (this.z < 0.0f) {
            GL11.glDisable((int)3042);
        }
    }

    public void renderOtherImpl(int delta, boolean reflection) {
        if (this.fader && this.faded) {
            return;
        }
        if (this.wood) {
            this.renderTop();
        }
        GL11.glTranslatef((float)this.box.getX(), (float)this.box.getY(), (float)this.z);
        if (this.z < 0.0f) {
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f + this.z / 20.0f));
        }
        this.texture.bind();
        GL11.glCallList((int)this.edges);
        GL11.glTranslatef((float)(-this.box.getX()), (float)(-this.box.getY()), (float)(-this.z));
        if (this.z < 0.0f) {
            GL11.glDisable((int)3042);
        }
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
        if (this.startFall) {
            if (this.fallTimer > 0) {
                this.z = (float)(FastTrig.cos(this.wiggle) * 0.5);
                if (this.z > 0.0f) {
                    this.z -= this.z;
                }
                this.wiggle += (float)delta * 0.05f;
                this.fallTimer -= delta;
                if (this.fallTimer <= 0) {
                    this.z = 0.0f;
                    snap.playAsSoundEffect(1.0f, 1.0f);
                }
            }
            if (this.fallTimer <= 0 && Math.abs(this.z) < 200.0f) {
                this.vz = (float)((double)this.vz - 0.01 * (double)delta);
                this.z = (float)((double)this.z + (double)(this.vz * (float)delta) * 0.01);
                if (Math.abs(this.z) > 0.3f) {
                    this.box.setWidth(0.0f);
                    this.box.setHeight(0.0f);
                }
            }
        }
        if (this.fader && this.fadeTimer > 0) {
            this.fadeTimer -= delta;
            if (this.fadeTimer <= 0) {
                if (this.faded) {
                    this.fadeTimer = 3000;
                    this.faded = false;
                    this.box.setX(this.ox);
                    this.box.setY(this.oy);
                } else {
                    this.fadeTimer = 2000;
                    this.faded = true;
                    this.box.setX(10000.0f);
                    this.box.setY(10000.0f);
                }
                click.playAsSoundEffect(0.1f, 0.2f);
            }
        }
        this.move(delta);
    }

    protected void move(int delta) {
        if (this.moves.size() == 0) {
            return;
        }
        Move move = (Move)this.moves.get(this.currentMove);
        if (move.update(delta)) {
            ++this.currentMove;
            if (this.currentMove >= this.moves.size()) {
                this.currentMove = 0;
            }
            Move next = (Move)this.moves.get(this.currentMove);
            next.init();
        }
    }

    public float getLastMoveX() {
        return this.lastMoveX;
    }

    public float getLastMoveY() {
        return this.lastMoveY;
    }

    public boolean hit(Ball other, float depth) {
        if (this.fall && other != null && !this.startFall) {
            this.startFall = true;
        }
        return true;
    }

    public MapElement copy(Map map) {
        try {
            return new Floor(this.id, this.box.getX(), this.box.getY(), this.box.getWidth(), this.box.getHeight(), -this.h, this.style, this.data);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    private class Move {
        private float xm;
        private float ym;
        private float xd;
        private float yd;
        private float wm;
        private float wd;
        private float speed = 0.002f;

        public Move(float xm, float ym, float wm) {
            this.xm = xm;
            this.ym = ym;
            this.wm = wm;
        }

        public void init() {
            this.xd = 0.0f;
            this.yd = 0.0f;
            this.wd = 0.0f;
        }

        public boolean update(int delta) {
            float d = (float)delta * this.speed;
            boolean done = false;
            Floor.this.lastMoveX = 0.0f;
            Floor.this.lastMoveY = 0.0f;
            if (this.xd > this.xm) {
                this.xd -= d;
                if (this.xd <= this.xm) {
                    done = true;
                    d -= this.xm - this.xd;
                }
                Floor.this.lastMoveX = -d;
                Floor.this.box.setX(Floor.this.box.getX() - d);
            }
            if (this.xd < this.xm) {
                this.xd += d;
                if (this.xd >= this.xm) {
                    done = true;
                    d -= this.xd - this.xm;
                }
                Floor.this.lastMoveX = d;
                Floor.this.box.setX(Floor.this.box.getX() + d);
            }
            if (this.yd > this.ym) {
                this.yd -= d;
                if (this.yd <= this.ym) {
                    done = true;
                    d -= this.ym - this.yd;
                }
                Floor.this.lastMoveY = -d;
                Floor.this.box.setY(Floor.this.box.getY() - d);
            }
            if (this.yd < this.ym) {
                this.yd += d;
                if (this.yd >= this.ym) {
                    done = true;
                    d -= this.yd - this.ym;
                }
                Floor.this.lastMoveY = d;
                Floor.this.box.setY(Floor.this.box.getY() + d);
            }
            if (this.wd < this.wm) {
                this.wd += d;
                if (this.wd >= this.wm) {
                    done = true;
                }
            }
            return done;
        }
    }
}

