/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.models.obj.ObjLoader;
import org.newdawn.render.models.obj.ObjModel;
import org.newdawn.render.particles.ParticleEngine;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.render.util.Tuple2;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.effect.ParticleEffect;
import org.newdawn.tilt.effect.ParticleProvider;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.Line;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.tilt.util.FastTrig;
import org.newdawn.util.Log;

public class Fence
extends MapElement
implements ParticleEffect {
    private static ObjModel model;
    private static Sound spark;
    private static final float LIFE = 500.0f;
    private static Texture texture;
    private float x;
    private float y;
    private String data;
    private Map map;
    private Body body;
    private float tx;
    private float ty;
    private boolean blast;
    private int id;
    private GlobalEmitter emitter;
    private boolean init;
    private boolean created;
    private boolean off = true;
    private int timer;
    private int interval = 2000;
    private Line line;
    private int lastTime;
    private int genTimer;
    private ArrayList fences = new ArrayList();
    private ArrayList balls = new ArrayList();
    static float[] results;

    public static void init() throws IOException {
        model = ObjLoader.loadObj((String)"res/leccy.obj");
        spark = SoundStore.get().getOgg("res/sounds/spark.ogg");
        texture = TextureLoader.get().getTextureLinear("res/metal.tga");
    }

    public Fence(Map map, float x, float y, String data) throws IOException {
        this.x = x;
        this.y = y;
        this.data = data;
        this.map = map;
        StringTokenizer tokens = new StringTokenizer(data, ",");
        tokens.nextToken();
        this.id = Integer.parseInt(tokens.nextToken());
        this.timer = tokens.hasMoreTokens() ? 1000 + Integer.parseInt(tokens.nextToken()) : 1000;
        this.body = new Body(new Circle(x, y, 0.1f));
    }

    public void toggle() {
        if (!this.blast) {
            return;
        }
        if (this.off) {
            spark.playAsSoundEffect(0.8f + (float)(Fence.random() * (double)0.2f), 0.8f);
            this.off = false;
        } else {
            this.off = true;
            this.init = true;
        }
    }

    public Body getBody() {
        return this.body;
    }

    public Shape getShape() {
        return this.body.getShape();
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int getID() {
        return this.id;
    }

    public void createImpl() {
        this.lastTime = 10000;
        this.init = true;
        this.map.getElements(Fence.class, this.fences);
        for (int i = 0; i < this.fences.size(); ++i) {
            Fence fence = (Fence)this.fences.get(i);
            if (fence.getID() != this.id + 1) continue;
            this.tx = fence.getX();
            this.ty = fence.getY();
            this.blast = true;
            this.line = new Line(new Tuple2(this.x, this.y), new Tuple2(this.tx, this.ty));
        }
        this.created = true;
    }

    public void destroy() {
    }

    public void renderImpl(int delta, boolean reflection) {
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        Map.render(texture, model, null, !reflection);
        GL11.glTranslatef((float)(-this.x), (float)(-this.y), (float)0.0f);
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
        if (this.emitter == null && this.blast) {
            emitter.addEffect(this);
            this.emitter = emitter;
        }
        if (this.timer > 10000) {
            return;
        }
        if (this.blast && !this.off) {
            this.map.getElements(Ball.class, this.balls);
            for (int i = 0; i < this.balls.size(); ++i) {
                Ball ball = (Ball)this.balls.get(i);
                if (!this.line.touches((Circle)ball.getShape())) continue;
                this.timer = 100000;
                ball.explode();
                spark.playAsSoundEffect(1.0f, 1.0f);
                return;
            }
        }
        this.timer -= delta;
        if (this.timer <= 0) {
            this.toggle();
            this.timer = this.interval;
        }
    }

    public boolean hit(Ball ball, float depth) {
        return false;
    }

    public MapElement copy(Map map) {
        try {
            return new Fence(map, this.x, this.y, this.data);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public void update(ParticleProvider provider, ParticleEngine engine, int delta) {
        if (!this.created) {
            return;
        }
        if (this.off) {
            if (this.timer < 700 && this.timer > 50 && this.lastTime - this.timer > 100) {
                this.lastTime = this.timer;
                this.createBall(provider, engine, this.x, this.y);
                this.createBall(provider, engine, this.tx, this.ty);
            }
            return;
        }
        this.lastTime = 10000;
        if (this.init) {
            this.init = false;
            for (int i = 0; i < 100; i += 5) {
                this.createEnergy(provider, engine, (float)i / 100.0f);
            }
            return;
        }
        if (this.blast) {
            this.genTimer -= delta;
            if (this.genTimer < 0) {
                this.genTimer = 30;
                this.createEnergy(provider, engine, 0.0f);
            }
        }
    }

    private void createBall(ParticleProvider provider, ParticleEngine engine, float x, float y) {
        int p = provider.getParticle(this, 250);
        if (p != -1) {
            float xp = x;
            float yp = y;
            float life = engine.getLife(p);
            engine.setPos(p, xp, yp, 0.6f);
            float white = (float)Fence.random() + 0.5f;
            engine.setSize(p, 0.45f);
            engine.setColor(p, white, white, 1.0f, 0.75f);
            engine.setVelocity(p, 0.0f, 0.0f, 0.0f);
        }
    }

    private void createEnergy(ParticleProvider provider, ParticleEngine engine, float pos) {
        float white;
        float life;
        float y;
        float x;
        float dy;
        float dx;
        int p;
        float xofs = (float)((double)0.995f + Fence.random() * (double)0.01f);
        float yofs = (float)((double)0.995f + Fence.random() * (double)0.01f);
        if (pos != 0.0f) {
            xofs = 1.0f;
            yofs = 1.0f;
        }
        if ((p = provider.getParticle(this, (int)(500.0f * (1.0f - pos)))) != -1) {
            dx = this.tx - this.x;
            dy = this.ty - this.y;
            x = this.x + pos * dx;
            y = this.y + pos * dy;
            life = engine.getLife(p);
            engine.setPos(p, x * xofs, y * yofs, 0.6f + (float)(FastTrig.cos(life / 10.0f) * (double)0.2f));
            white = (float)Fence.random() + 0.5f;
            engine.setSize(p, 0.15f);
            engine.setColor(p, white, white, 1.0f, 1.0f);
            engine.setVelocity(p, dx / 0.5f, dy / 0.5f, 0.0f);
        }
        if ((p = provider.getParticle(this, (int)(500.0f * (1.0f - pos)))) != -1) {
            dx = this.tx - this.x;
            dy = this.ty - this.y;
            x = this.x + pos * dx;
            y = this.y + pos * dy;
            life = engine.getLife(p);
            engine.setPos(p, x * xofs, y * yofs, 0.6f + (float)(FastTrig.cos(life / 10.0f) * (double)0.2f));
            white = (float)Fence.random();
            engine.setSize(p, 0.4f);
            engine.setColor(p, white, white, 1.0f, 0.4f);
            engine.setVelocity(p, dx / 0.5f, dy / 0.5f, 0.0f);
        }
    }

    public void updateParticle(int index, int delta, ParticleEngine engine, int life) {
        if (this.off) {
            if (this.timer > 700) {
                engine.setPos(index, 10000.0f, 10000.0f, 10000.0f);
                engine.adjustColor(index, 0.0f, 0.0f, 0.0f, -1.0f);
            }
        } else {
            engine.setPos(index, engine.getX(index), engine.getY(index), 0.6f + Fence.quickCos((float)life / 10.0f) * 0.2f);
        }
    }

    public boolean finished() {
        return false;
    }

    private static float quickCos(float ang) {
        double index = (double)ang / (Math.PI * 2);
        index %= 1.0;
        return results[(int)(index *= 5000.0)];
    }

    private static double random() {
        return Math.random();
    }

    static {
        results = new float[5000];
        double step = 0.0012566370614359172;
        for (int i = 0; i < 5000; ++i) {
            Fence.results[i] = (float)Math.cos(step * (double)i);
        }
    }
}

