/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.util.StringTokenizer;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.models.obj.ObjLoader;
import org.newdawn.render.models.obj.ObjModel;
import org.newdawn.render.particles.ParticleEngine;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.render.util.Tuple2;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.effect.ParticleEffect;
import org.newdawn.tilt.effect.ParticleProvider;
import org.newdawn.tilt.geom.AABox;
import org.newdawn.tilt.geom.CollisionResult;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.tilt.util.FastTrig;
import org.newdawn.util.Log;

public class Fan
extends MapElement
implements ParticleEffect {
    private static ObjModel model1;
    private static ObjModel model2;
    private static Texture texture;
    private float x;
    private float y;
    private String data;
    private Map map;
    private Body body;
    private int id;
    private boolean init;
    private float ang;
    private float rot;
    private boolean on;
    private AABox blowArea;
    private int interval;
    private int timer;
    private float power = 0.008f;
    private float speed;
    private GlobalEmitter emitter;
    private CollisionResult result = new CollisionResult();

    public static void init() throws IOException {
        model2 = ObjLoader.loadObj((String)"res/fan_base.obj");
        model1 = ObjLoader.loadObj((String)"res/fan_blades.obj");
        texture = TextureLoader.get().getTextureLinear("res/fan.tga");
    }

    public Fan(Map map, float x, float y, String data) throws IOException {
        this.x = x;
        this.y = y;
        this.data = data;
        this.map = map;
        if (data == null) {
            data = "blah,blah";
        }
        StringTokenizer tokens = new StringTokenizer(data, ",");
        tokens.nextToken();
        tokens.nextToken();
        this.interval = 2000;
        if (tokens.hasMoreTokens()) {
            this.interval = Integer.parseInt(tokens.nextToken());
        }
        this.timer = 0;
        if (tokens.hasMoreTokens()) {
            this.timer = Integer.parseInt(tokens.nextToken());
        }
        float length = 2.5f;
        if (tokens.hasMoreTokens()) {
            length = Float.parseFloat(tokens.nextToken());
        }
        if (tokens.hasMoreTokens()) {
            this.power = Float.parseFloat(tokens.nextToken());
        }
        this.rot = 0.0f;
        this.blowArea = new AABox(x - 0.5f, y - 0.5f - length, 1.0f, length);
        if (data.indexOf("left") >= 0) {
            this.rot = 270.0f;
            this.blowArea = new AABox(x - length - 0.5f, y - 0.5f, length, 1.0f);
        }
        if (data.indexOf("right") >= 0) {
            this.rot = 90.0f;
            this.blowArea = new AABox(x + 0.5f, y - 0.5f, length, 1.0f);
        }
        if (data.indexOf("up") >= 0) {
            this.rot = 180.0f;
            this.blowArea = new AABox(x - 0.5f, y + 0.5f, 1.0f, length);
        }
        this.body = new Body(new AABox(x - 0.5f, y - 0.5f, 1.0f, 1.0f));
    }

    public Body getBody() {
        return this.body;
    }

    public Shape getShape() {
        return this.body.getShape();
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int getID() {
        return this.id;
    }

    public void createImpl() {
    }

    public void destroy() {
    }

    public void renderImpl(int delta, boolean reflection) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.5f);
        GL11.glRotatef((float)this.rot, (float)0.0f, (float)0.0f, (float)1.0f);
        Map.render(texture, model2, null, true);
        GL11.glRotatef((float)this.ang, (float)0.0f, (float)1.0f, (float)0.0f);
        Map.render(texture, model1, null, false);
        GL11.glPopMatrix();
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
        if (this.emitter == null) {
            this.emitter = emitter;
            emitter.addEffect(this);
        }
        this.timer -= delta;
        if (this.timer < 0) {
            this.on = !this.on;
            this.timer = this.interval;
        }
        this.ang += (float)delta * this.speed;
        if (this.on) {
            this.speed += (float)delta * 0.001f;
            if (this.speed > 0.8f) {
                this.speed = 0.8f;
            }
        } else {
            this.speed -= (float)delta * 0.001f;
            if (this.speed < 0.0f) {
                this.speed = 0.0f;
            }
        }
        if (this.on && this.speed > 0.5f) {
            this.result.missed();
            this.map.getBall().getShape().collides(0.0f, 0.0f, this.blowArea, false, this.result);
            if (this.result.collided()) {
                float power = this.power;
                Tuple2 bpos = new Tuple2(this.map.getBall().getX(), this.map.getBall().getY());
                bpos.sub(new Tuple2(this.x, this.y));
                power = 1.0f / bpos.length() * power;
                if (this.rot == 0.0f) {
                    this.map.getBall().adjustVelocity(0.0f, (float)(-delta) * power);
                }
                if (this.rot == 180.0f) {
                    this.map.getBall().adjustVelocity(0.0f, (float)delta * power);
                }
                if (this.rot == 90.0f) {
                    this.map.getBall().adjustVelocity((float)delta * power, 0.0f);
                }
                if (this.rot == 270.0f) {
                    this.map.getBall().adjustVelocity((float)(-delta) * power, 0.0f);
                }
            }
        }
    }

    public boolean hit(Ball ball, float depth) {
        return false;
    }

    public MapElement copy(Map map) {
        try {
            return new Fan(map, this.x, this.y, this.data);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public boolean finished() {
        return false;
    }

    public void update(ParticleProvider provider, ParticleEngine engine, int delta) {
        int p;
        if (this.on && this.speed > 0.4f && (p = provider.getParticle(this, 800)) >= 0) {
            engine.setSize(p, 0.05f);
            engine.setColor(p, 1.0f, 1.0f, 1.0f, 0.8f + (float)Math.random() * 0.2f);
            float ran = (float)(Math.random() * Math.PI * 2.0);
            float dis = (float)(Math.random() * (double)0.4f) + 0.1f;
            float ac = (float)FastTrig.cos(ran) * dis;
            float as = (float)FastTrig.sin(ran) * dis;
            if (this.rot == 180.0f) {
                engine.setPos(p, this.x - ac, this.y + 0.5f, 0.5f + as);
                engine.setVelocity(p, 0.0f, 5.0f, 0.0f);
            }
            if (this.rot == 0.0f) {
                engine.setPos(p, this.x - ac, this.y - 0.5f, 0.5f + as);
                engine.setVelocity(p, 0.0f, -5.0f, 0.0f);
            }
            if (this.rot == 90.0f) {
                engine.setPos(p, this.x + 0.5f, this.y + ac, 0.5f + as);
                engine.setVelocity(p, 5.0f, 0.0f, 0.0f);
            }
            if (this.rot == 270.0f) {
                engine.setPos(p, this.x - 0.5f, this.y + ac, 0.5f + as);
                engine.setVelocity(p, -5.0f, 0.0f, 0.0f);
            }
        }
    }

    public void updateParticle(int index, int delta, ParticleEngine engine, int life) {
        engine.adjustColor(index, 0.0f, 0.0f, 0.0f, -0.002f * (float)delta);
    }
}

