/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.Block;
import org.newdawn.tilt.Floor;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.AABox;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.util.Log;

public class FallingBridge
extends Floor {
    private static Sound noise;
    private static Texture texture;
    private AABox box;
    private float h;
    private int top;
    private float ox;
    private float oy;
    private boolean present;
    private float toffset;
    private boolean fall = false;
    private float ang = 90.0f;
    private Map map;
    private boolean complete;
    private float height;
    private float width;
    private float x;
    private float y;
    private boolean wobble;
    private boolean horizontal;
    private boolean wobblea;
    private boolean wobbleb;
    private boolean wobblec;
    private String id;

    public static void init() throws IOException {
        noise = SoundStore.get().getOgg("res/sounds/snap.ogg");
        texture = TextureLoader.get().getTextureLinear("res/crate.tga");
    }

    public FallingBridge(String id, Map map, float x, float y, float width, float height, float h) throws IOException {
        super(id);
        this.box = new AABox(x, y, width, height);
        this.id = id;
        this.map = map;
        this.h = -h;
        this.x = x;
        this.y = y;
        this.height = height;
        this.width = width;
        this.horizontal = width > height;
    }

    public Body getBody() {
        return null;
    }

    public void createImpl() {
        try {
            if (this.horizontal) {
                FlipBlock block = new FlipBlock(this.map, this.x, this.y, 0.1f, this.height, 0.1f, 6);
                this.map.addItem(block);
            } else {
                FlipBlock block = new FlipBlock(this.map, this.x, this.y, this.width, 0.1f, 0.1f, 6);
                this.map.addItem(block);
            }
        }
        catch (IOException e) {
            Log.log((Throwable)e);
        }
        this.top = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.top, (int)4864);
        this.renderBox();
        GL11.glEndList();
    }

    public void destroy() {
        GL11.glDeleteLists((int)this.top, (int)1);
    }

    public Shape getShape() {
        return this.box;
    }

    public void setPresent(boolean present) {
        if (this.present != present) {
            this.present = present;
            noise.playAsSoundEffect(2.0f, 0.3f);
        }
    }

    public void renderBox() {
        float scale = 0.5f;
        float zo = -0.2f;
        if (this.horizontal) {
            GL11.glBegin((int)7);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)(-this.box.getHeight() / 2.0f), (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)this.box.getWidth(), (float)(-this.box.getHeight() / 2.0f), (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)this.box.getWidth(), (float)(this.box.getHeight() / 2.0f), (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)0.0f, (float)(this.box.getHeight() / 2.0f), (float)0.0f);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)0.0f, (float)(-this.box.getHeight() / 2.0f), (float)zo);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)this.box.getWidth(), (float)(-this.box.getHeight() / 2.0f), (float)zo);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)this.box.getWidth(), (float)(this.box.getHeight() / 2.0f), (float)zo);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)0.0f, (float)(this.box.getHeight() / 2.0f), (float)zo);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)this.box.getWidth(), (float)(-this.box.getHeight() / 2.0f), (float)zo);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)this.box.getWidth(), (float)(-this.box.getHeight() / 2.0f), (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)this.box.getWidth(), (float)(this.box.getHeight() / 2.0f), (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)this.box.getWidth(), (float)(this.box.getHeight() / 2.0f), (float)zo);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glTexCoord2f((float)(this.box.getX() * scale), (float)(this.box.getY() * scale));
            GL11.glVertex3f((float)0.0f, (float)(-this.box.getHeight() / 2.0f), (float)zo);
            GL11.glTexCoord2f((float)(this.box.getX2() * scale), (float)(this.box.getY() * scale));
            GL11.glVertex3f((float)this.box.getWidth(), (float)(-this.box.getHeight() / 2.0f), (float)zo);
            GL11.glTexCoord2f((float)(this.box.getX2() * scale), (float)(this.box.getY2() * scale));
            GL11.glVertex3f((float)this.box.getWidth(), (float)(-this.box.getHeight() / 2.0f), (float)0.0f);
            GL11.glTexCoord2f((float)(this.box.getX() * scale), (float)(this.box.getY2() * scale));
            GL11.glVertex3f((float)0.0f, (float)(-this.box.getHeight() / 2.0f), (float)0.0f);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glTexCoord2f((float)(this.box.getX() * scale), (float)(this.box.getY() * scale));
            GL11.glVertex3f((float)0.0f, (float)(this.box.getHeight() / 2.0f), (float)zo);
            GL11.glTexCoord2f((float)(this.box.getX2() * scale), (float)(this.box.getY() * scale));
            GL11.glVertex3f((float)this.box.getWidth(), (float)(this.box.getHeight() / 2.0f), (float)zo);
            GL11.glTexCoord2f((float)(this.box.getX2() * scale), (float)(this.box.getY2() * scale));
            GL11.glVertex3f((float)this.box.getWidth(), (float)(this.box.getHeight() / 2.0f), (float)0.0f);
            GL11.glTexCoord2f((float)(this.box.getX() * scale), (float)(this.box.getY2() * scale));
            GL11.glVertex3f((float)0.0f, (float)(this.box.getHeight() / 2.0f), (float)0.0f);
            GL11.glEnd();
        } else {
            GL11.glBegin((int)7);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.box.getWidth() / 2.0f), (float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.box.getWidth() / 2.0f), (float)this.box.getHeight(), (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.box.getWidth() / 2.0f), (float)this.box.getHeight(), (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.box.getWidth() / 2.0f), (float)0.0f, (float)0.0f);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.box.getWidth() / 2.0f), (float)0.0f, (float)zo);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.box.getWidth() / 2.0f), (float)this.box.getHeight(), (float)zo);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.box.getWidth() / 2.0f), (float)this.box.getHeight(), (float)zo);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.box.getWidth() / 2.0f), (float)0.0f, (float)zo);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.box.getWidth() / 2.0f), (float)this.box.getHeight(), (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.box.getWidth() / 2.0f), (float)this.box.getHeight(), (float)zo);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.box.getWidth() / 2.0f), (float)this.box.getHeight(), (float)zo);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.box.getWidth() / 2.0f), (float)this.box.getHeight(), (float)0.0f);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.box.getWidth() / 2.0f), (float)0.0f, (float)zo);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.box.getWidth() / 2.0f), (float)this.box.getHeight(), (float)zo);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.box.getWidth() / 2.0f), (float)this.box.getHeight(), (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.box.getWidth() / 2.0f), (float)0.0f, (float)0.0f);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.box.getWidth() / 2.0f), (float)0.0f, (float)zo);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.box.getWidth() / 2.0f), (float)this.box.getHeight(), (float)zo);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.box.getWidth() / 2.0f), (float)this.box.getHeight(), (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.box.getWidth() / 2.0f), (float)0.0f, (float)0.0f);
            GL11.glEnd();
        }
    }

    public void renderImpl(int delta, boolean reflection) {
    }

    public void renderOtherImpl(int delta, boolean reflection) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        if (this.horizontal) {
            GL11.glTranslatef((float)this.box.getX(), (float)(this.box.getY() + this.box.getHeight() / 2.0f), (float)0.0f);
            GL11.glRotatef((float)(-this.ang), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL11.glTranslatef((float)(this.box.getX() + this.box.getWidth() / 2.0f), (float)this.box.getY(), (float)0.0f);
            GL11.glRotatef((float)this.ang, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        texture.bind();
        GL11.glCallList((int)this.top);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
        if (this.fall) {
            this.ang -= (float)delta * 0.25f;
            if (this.ang < 0.0f) {
                this.ang = 0.0f;
                this.complete = true;
                this.fall = false;
                noise.playAsSoundEffect(0.2f, 0.8f);
            }
        }
        if (this.wobble) {
            if (this.wobblea) {
                this.ang -= (float)delta * 0.04f;
                if (this.ang < 83.0f) {
                    this.wobblea = false;
                    this.wobbleb = true;
                }
            }
            if (this.wobbleb) {
                this.ang += (float)delta * 0.04f;
                if (this.ang > 97.0f) {
                    this.wobbleb = false;
                    this.wobblec = true;
                }
            }
            if (this.wobblec) {
                this.ang -= (float)delta * 0.04f;
                if (this.ang < 90.0f) {
                    this.ang = 90.0f;
                    this.wobblec = false;
                    this.wobble = false;
                }
            }
        }
    }

    public boolean hit(Ball other, float depth) {
        return true;
    }

    public MapElement copy(Map map) {
        try {
            return new FallingBridge(this.id, map, this.box.getX(), this.box.getY(), this.box.getWidth(), this.box.getHeight(), -this.h);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    private class FlipBlock
    extends Block {
        public FlipBlock(Map map, float x, float y, float width, float height, float h, int type) throws IOException {
            super(map, x, y, width, height, h, type, false);
        }

        public boolean hit(Ball other, float depth) {
            if (!FallingBridge.this.complete && !FallingBridge.this.fall) {
                float f = FallingBridge.this.horizontal ? 0.022f : 0.02f;
                if (depth > f) {
                    this.body.setActive(false);
                    FallingBridge.this.map.removeItem(this);
                    FallingBridge.this.fall = true;
                    FallingBridge.this.wobble = false;
                } else if (!FallingBridge.this.wobble) {
                    FallingBridge.this.ang = 90.0f;
                    FallingBridge.this.wobble = true;
                    FallingBridge.this.wobblea = true;
                }
            }
            return super.hit(other, depth);
        }

        public String toString() {
            return "[FLIP BLOCK: " + super.toString() + "]";
        }
    }
}

