/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.models.obj.ObjLoader;
import org.newdawn.render.models.obj.ObjModel;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.render.util.Color;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.Configuration;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.MapStore;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.tilt.util.FastTrig;

public class ExitItem
extends MapElement {
    private static Texture ring;
    private static ObjModel arrow;
    private static Sound appear;
    private Circle bounds;
    private float x;
    private float y;
    private float zstep;
    private Map map;
    private float[] ringSize = new float[4];
    private float[] ringPos = new float[4];
    private float zrot = 0.0f;
    private boolean visible = false;
    private Ball currentBall;
    private Body body;
    private String target;
    private ArrayList result = new ArrayList();
    private boolean used;

    public static void init() throws IOException {
        ring = TextureLoader.get().getTextureLinear("res/ring.tga");
        arrow = ObjLoader.loadObj((String)"res/arrow.obj");
        appear = SoundStore.get().getOgg("res/sounds/appear.ogg");
    }

    public ExitItem(Map map, float x, float y, String id) {
        this.bounds = new Circle(x, y, 0.4f);
        this.x = x;
        this.y = y;
        this.zstep = (float)(Math.random() * 30.0);
        if (id != null && !id.equals("")) {
            this.target = id;
        }
        this.map = map;
        for (int i = 0; i < this.ringSize.length; ++i) {
            this.ringPos[i] = (float)i * (2.0f / (float)this.ringSize.length);
            this.ringSize[i] = 0.5f + (float)i * 0.05f;
        }
        this.body = new Body(this.bounds);
        this.body.setActive(false);
    }

    public Body getBody() {
        return this.body;
    }

    public void createImpl() {
    }

    public void destroy() {
    }

    public Shape getShape() {
        return this.bounds;
    }

    public void renderImpl(int delta, boolean reflection) {
        if (!this.visible) {
            return;
        }
        if (reflection) {
            return;
        }
        if (this.currentBall != null && !this.currentBall.completed()) {
            return;
        }
        if (this.map.ballsFinished()) {
            return;
        }
        if (!this.used) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.x, (float)this.y, (float)((float)(4.0 + FastTrig.sin(Math.toRadians(this.zrot * 5.0f)))));
            GL11.glRotatef((float)this.zrot, (float)0.0f, (float)0.0f, (float)1.0f);
            Map.render(null, arrow, Color.yellow, false);
            GL11.glPopMatrix();
        }
    }

    public void renderOtherImpl(int delta, boolean reflection) {
        if (!this.visible) {
            return;
        }
        if (reflection) {
            return;
        }
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        float offset = 0.1f;
        ring.bind();
        GL11.glBegin((int)7);
        for (int i = 0; i < this.ringSize.length; ++i) {
            float size = this.ringSize[i];
            float zpos = this.ringPos[i];
            if (this.target == null) {
                GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)(2.0f - zpos));
            } else {
                GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)(2.0f - zpos));
            }
            if (this.used) {
                GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)((2.0f - zpos) / 2.0f));
            }
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.x - size), (float)(this.y - size), (float)(zpos - offset));
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.x + size), (float)(this.y - size), (float)(zpos - offset));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.x + size), (float)(this.y + size), (float)(zpos - offset));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.x - size), (float)(this.y + size), (float)(zpos - offset));
        }
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
        int i;
        if (!this.visible) {
            return;
        }
        this.zrot += (float)delta * 0.1f;
        boolean reset = false;
        for (i = 0; i < this.ringPos.length; ++i) {
            int n = i;
            this.ringPos[n] = this.ringPos[n] + (float)delta * 0.001f;
            int n2 = i;
            this.ringSize[n2] = this.ringSize[n2] + (float)delta * 2.0E-4f;
            if (!(this.ringPos[i] > 2.0f)) continue;
            reset = true;
        }
        if (reset) {
            for (i = this.ringSize.length - 1; i > 0; --i) {
                this.ringPos[i] = this.ringPos[i - 1];
                this.ringSize[i] = this.ringSize[i - 1];
            }
            this.ringPos[0] = 0.0f;
            this.ringSize[0] = 0.5f;
        }
    }

    public boolean hit(Ball ball, float depth) {
        if (this.used) {
            return true;
        }
        if (!this.visible) {
            return true;
        }
        if (this.target != null) {
            Configuration.setGlobalValue(this.target, 1.0f);
        }
        this.currentBall = ball;
        ball.complete(this);
        this.result.clear();
        this.map.getElements(Ball.class, this.result);
        for (int i = 0; i < this.result.size(); ++i) {
            Ball b = (Ball)this.result.get(i);
            if (b.throughExit()) continue;
            this.used = true;
            this.body.setActive(false);
        }
        return true;
    }

    public void show() {
        appear.playAsSoundEffect(1.0f, 0.7f);
        this.body.setActive(true);
        this.visible = true;
    }

    public MapElement copy(Map map) {
        if ("hidden1".equals(this.target) && !MapStore.hasEnoughStars(3, 0)) {
            return null;
        }
        if ("hidden2".equals(this.target) && !MapStore.hasEnoughStars(3, 1)) {
            return null;
        }
        if ("hidden3".equals(this.target) && !MapStore.hasEnoughStars(4, 1)) {
            return null;
        }
        if ("hidden4".equals(this.target) && !MapStore.hasEnoughStars(4, 2)) {
            return null;
        }
        return new ExitItem(map, this.x, this.y, this.target);
    }
}

