/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.tilt.util.FastTrig;
import org.newdawn.util.Log;

public class Cylinder
extends MapElement {
    private static Texture texture;
    private Circle bounds;
    private float x;
    private float y;
    private float rad;
    private float top;
    private float bottom;
    private int list;
    private Body body;

    public static void init() throws IOException {
        texture = TextureLoader.get().getTextureLinear("res/crate.tga");
    }

    public Cylinder(float x, float y, float rad, float bottom, float top) throws IOException {
        this.bounds = new Circle(x, y, rad);
        this.x = x;
        this.y = y;
        this.rad = rad;
        this.top = top;
        this.bottom = bottom;
        this.body = new Body(this.bounds);
    }

    public Body getBody() {
        return this.body;
    }

    public void createImpl() {
        this.list = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.list, (int)4864);
        Cylinder.renderCylinder(this.x, this.y, this.rad, this.top, this.bottom);
        GL11.glEndList();
    }

    public void destroy() {
        GL11.glDeleteLists((int)this.list, (int)1);
    }

    public static void renderCylinder(float x, float y, float rad, float top, float bottom) {
        Cylinder.renderCylinder(x, y, rad, top, bottom, true);
    }

    public static void renderCylinder(float x, float y, float rad, float top, float bottom, boolean caps) {
        int step = 30;
        GL11.glBegin((int)7);
        for (int i = 0; i < 360; i += step) {
            float x1 = (float)FastTrig.cos(Math.toRadians(i)) * rad;
            float y1 = (float)FastTrig.sin(Math.toRadians(i)) * rad;
            float x2 = (float)FastTrig.cos(Math.toRadians(i + step)) * rad;
            float y2 = (float)FastTrig.sin(Math.toRadians(i + step)) * rad;
            GL11.glNormal3f((float)((x1 += x) - x), (float)((y1 += y) - y), (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)x1, (float)y1, (float)bottom);
            GL11.glNormal3f((float)((x2 += x) - x), (float)((y2 += y) - y), (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)x2, (float)y2, (float)bottom);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)x2, (float)y2, (float)top);
            GL11.glNormal3f((float)(x1 - x), (float)(y1 - y), (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)x1, (float)y1, (float)top);
        }
        GL11.glEnd();
        if (caps) {
            float scale = 0.05f;
            GL11.glBegin((int)4);
            for (int i = 0; i < 360; i += step) {
                float x1 = (float)FastTrig.cos(Math.toRadians(i)) * rad;
                float y1 = (float)FastTrig.sin(Math.toRadians(i)) * rad;
                float x2 = (float)FastTrig.cos(Math.toRadians(i + step)) * rad;
                float y2 = (float)FastTrig.sin(Math.toRadians(i + step)) * rad;
                x1 += x;
                y1 += y;
                x2 += x;
                y2 += y;
                GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTexCoord2f((float)0.5f, (float)0.5f);
                GL11.glVertex3f((float)x, (float)y, (float)top);
                GL11.glTexCoord2f((float)((x1 - x) * scale), (float)((y1 - y) * scale));
                GL11.glVertex3f((float)x1, (float)y1, (float)top);
                GL11.glTexCoord2f((float)((x2 - x) * scale), (float)((y2 - y) * scale));
                GL11.glVertex3f((float)x2, (float)y2, (float)top);
            }
            GL11.glEnd();
        }
    }

    public Shape getShape() {
        return this.bounds;
    }

    public void renderImpl(int delta, boolean reflection) {
        texture.bind();
        GL11.glCallList((int)this.list);
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
    }

    public boolean hit(Ball other, float depth) {
        return false;
    }

    public MapElement copy(Map map) {
        try {
            return new Cylinder(this.x, this.y, this.rad, this.bottom, this.top);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }
}

