/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.models.obj.ObjLoader;
import org.newdawn.render.models.obj.ObjModel;
import org.newdawn.render.util.Color;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;

public class CubitItem
extends MapElement {
    private static ObjModel model;
    private static Sound collect;
    private Circle bounds;
    private float x;
    private float y;
    private float zrot;
    private Map map;
    private Body body;

    public static void init() throws IOException {
        model = ObjLoader.loadObj((String)"res/cubit.obj");
        collect = SoundStore.get().getOgg("res/sounds/collect.ogg");
    }

    public CubitItem(Map map, float x, float y) {
        this.bounds = new Circle(x, y, 0.4f);
        this.x = x;
        this.y = y;
        this.zrot = (float)(Math.random() * 30.0);
        this.map = map;
        this.body = new Body(this.bounds);
    }

    public Body getBody() {
        return this.body;
    }

    public void createImpl() {
    }

    public void destroy() {
    }

    public Shape getShape() {
        return this.bounds;
    }

    public void renderImpl(int delta, boolean reflection) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.5f);
        GL11.glRotatef((float)this.zrot, (float)0.0f, (float)0.0f, (float)1.0f);
        Map.render(null, model, Color.yellow, !reflection);
        GL11.glPopMatrix();
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
        this.zrot += (float)delta * 0.1f;
    }

    public boolean hit(Ball ball, float depth) {
        collect.playAsSoundEffect(1.0f, 1.0f);
        this.map.removeItem(this);
        return true;
    }

    public MapElement copy(Map map) {
        return new CubitItem(map, this.x, this.y);
    }
}

