/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.render.util.Color;
import org.newdawn.render.window.LWJGLWindow;
import org.newdawn.state.GameState;
import org.newdawn.state.StateBasedGame;
import org.newdawn.state.transitions.FadeInTransition;
import org.newdawn.state.transitions.FadeOutTransition;
import org.newdawn.state.transitions.Transition;
import org.newdawn.tilt.Configuration;
import org.newdawn.tilt.MouseOverArea;
import org.newdawn.tilt.MouseOverGroup;
import org.newdawn.tilt.SharedUI;
import org.newdawn.tilt.TiltController;

public class ControlSettingsState
implements GameState {
    public static final int ID = 21;
    private LWJGLWindow window;
    private Texture title;
    private Texture drag;
    private Texture check;
    private Texture uncheck;
    private Texture sense;
    private Texture plus;
    private Texture minus;
    private Texture back;
    private Texture bar;
    private Texture auto;
    private Texture gamepad;
    private Texture vertical;
    private Texture horizontal;
    private MouseOverArea backArea;
    private MouseOverArea plusArea;
    private MouseOverArea minusArea;
    private MouseOverArea dragArea;
    private MouseOverArea autoArea;
    private MouseOverArea gamepadArea;
    private MouseOverGroup group;
    private int selected;
    private float value = 0.5f;
    private boolean dragToMove;
    private boolean autoCentre;
    private boolean configureX;
    private boolean configureY;
    private boolean configDone;
    private int xaxis;
    private boolean controller;
    private Color gray = new Color(0.0f, 0.0f, 0.0f, 0.5f);

    public ControlSettingsState(LWJGLWindow window) {
        this.window = window;
    }

    private void renderRectangle(float x, float y, float width, float height) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glEnd();
    }

    public void init(StateBasedGame game) throws IOException {
        this.title = TextureLoader.get().getTextureLinear("res/settings.tga");
        this.sense = TextureLoader.get().getTextureLinear("res/msense.tga");
        this.plus = TextureLoader.get().getTextureLinear("res/plus.tga");
        this.minus = TextureLoader.get().getTextureLinear("res/minus.tga");
        this.back = TextureLoader.get().getTextureLinear("res/backtomenu.tga");
        this.bar = TextureLoader.get().getTextureLinear("res/bar.tga");
        this.auto = TextureLoader.get().getTextureLinear("res/autocenter.tga");
        this.drag = TextureLoader.get().getTextureLinear("res/dragtomove.tga");
        this.gamepad = TextureLoader.get().getTextureLinear("res/gamepad.tga");
        this.check = TextureLoader.get().getTextureLinear("res/check.tga");
        this.uncheck = TextureLoader.get().getTextureLinear("res/uncheck.tga");
        this.backArea = new MouseOverArea(this.window, 200.0f, 540.0f, 200.0f, 50.0f);
        this.minusArea = new MouseOverArea(this.window, 75.0f, 165.0f, 50.0f, 50.0f);
        this.plusArea = new MouseOverArea(this.window, 470.0f, 155.0f, 50.0f, 50.0f);
        this.dragArea = new MouseOverArea(this.window, 370.0f, 230.0f, 70.0f, 50.0f);
        this.autoArea = new MouseOverArea(this.window, 370.0f, 290.0f, 70.0f, 50.0f);
        this.gamepadArea = new MouseOverArea(this.window, 370.0f, 350.0f, 70.0f, 50.0f);
        this.group = new MouseOverGroup("controls");
        this.group.addArea(this.minusArea);
        this.group.addArea(this.plusArea);
        this.group.addArea(this.dragArea);
        this.group.addArea(this.autoArea);
        this.group.addArea(this.gamepadArea);
        this.group.addArea(this.backArea);
    }

    public void reinit(StateBasedGame game) throws IOException {
    }

    public void render(StateBasedGame game, int delta) {
        this.window.enterOrtho(600, 600);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.title.bind();
        this.renderRectangle(174.0f, -15.0f, 256.0f, 128.0f);
        this.sense.bind();
        this.renderRectangle(50.0f, 65.0f, 512.0f, 128.0f);
        this.drag.bind();
        this.renderRectangle(140.0f, 230.0f, 256.0f, 64.0f);
        this.auto.bind();
        this.renderRectangle(140.0f, 290.0f, 256.0f, 64.0f);
        this.gamepad.bind();
        this.renderRectangle(190.0f, 350.0f, 256.0f, 128.0f);
        if (this.autoCentre) {
            this.check.bind();
        } else {
            this.uncheck.bind();
        }
        float col = 0.75f + this.autoArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.renderRectangle(350.0f, 290.0f, 128.0f, 64.0f);
        if (this.dragToMove) {
            this.check.bind();
        } else {
            this.uncheck.bind();
        }
        col = 0.75f + this.dragArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.renderRectangle(350.0f, 230.0f, 128.0f, 64.0f);
        if (this.controller && TiltController.isWorking()) {
            this.check.bind();
        } else {
            this.uncheck.bind();
        }
        col = 0.75f + this.gamepadArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.renderRectangle(350.0f, 350.0f, 128.0f, 64.0f);
        col = 0.75f + this.minusArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.minus.bind();
        this.renderRectangle(75.0f, 175.0f, 64.0f, 32.0f);
        col = 0.75f + this.plusArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.plus.bind();
        this.renderRectangle(470.0f, 158.0f, 64.0f, 64.0f);
        col = 0.75f + this.backArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.back.bind();
        this.renderRectangle(174.0f, 540.0f, 256.0f, 64.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.bar.bind();
        this.renderRectangle(55.0f, 150.0f, 512.0f, 64.0f);
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.7f);
        Texture.bindNone();
        this.renderRectangle(150.0f, 170.0f, 300.0f * this.value, 27.0f);
        if (TiltController.isWorking()) {
            String msg;
            if (this.configureX) {
                msg = "Move control stick left";
                this.drawString(450, msg);
            }
            if (this.configureY) {
                msg = "Move control stick up";
                this.drawString(470, msg);
            }
            if (this.configDone) {
                msg = "Configuration Complete";
                this.drawString(490, msg);
            }
        } else {
            this.drawString(450, "No Controllers Found");
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        this.window.leaveOrtho();
    }

    private void drawString(int y, String text) {
        int x = (600 - SharedUI.smallFontO.getWidth(text)) / 2;
        SharedUI.smallFontO.drawString(x + 3, y + 3, text, this.gray);
        SharedUI.smallFontO.drawString(x, y, text, Color.white);
    }

    public void update(StateBasedGame game, int delta) {
        int axis;
        int oldSelected = this.selected;
        this.selected = 0;
        if (this.configureY && !this.configDone && (axis = TiltController.checkForAxisActivity(this.xaxis)) != -1) {
            TiltController.setYAxisIndex(axis);
            Configuration.setGlobalValue("yaxis", axis);
            this.configDone = true;
        }
        if (this.configureX && !this.configDone && !this.configureY && (axis = TiltController.checkForAxisActivity(-1)) != -1) {
            this.xaxis = axis;
            TiltController.setXAxisIndex(this.xaxis);
            Configuration.setGlobalValue("xaxis", this.xaxis);
            this.configureY = true;
        }
        if (this.backArea.considerMouse(delta)) {
            this.selected = 1;
        }
        if (this.minusArea.considerMouse(delta)) {
            this.selected = 2;
            if (Mouse.isButtonDown((int)0)) {
                this.value -= (float)delta * 2.0E-4f;
                this.value = Math.max(0.0f, this.value);
            }
        }
        if (this.plusArea.considerMouse(delta)) {
            this.selected = 3;
            if (Mouse.isButtonDown((int)0)) {
                this.value += (float)delta * 2.0E-4f;
                this.value = Math.min(1.0f, this.value);
            }
        }
        if (this.dragArea.considerMouse(delta)) {
            this.selected = 4;
        }
        if (this.dragToMove && this.autoArea.considerMouse(delta)) {
            this.selected = 5;
        }
        if (TiltController.isWorking() && this.gamepadArea.considerMouse(delta)) {
            this.selected = 6;
        }
        if (oldSelected != this.selected && this.selected != 0) {
            SharedUI.playOver();
        }
        this.group.update();
        if (TiltController.buttonPressed()) {
            this.selectOption(game);
        }
        while (Mouse.next()) {
            if (Mouse.getEventButton() < 0 || !Mouse.getEventButtonState()) continue;
            this.selectOption(game);
        }
    }

    private void selectOption(StateBasedGame game) {
        if (this.selected == 1) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            game.changeToState(7, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
            return;
        }
        if (this.selected == 4) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            this.dragToMove = !this.dragToMove;
            Configuration.setGlobalValue("dragmove", this.dragToMove ? 1.0f : 0.0f);
        }
        if (this.selected == 5) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            this.autoCentre = !this.autoCentre;
            Configuration.setGlobalValue("centre", this.autoCentre ? 1.0f : 0.0f);
        }
        if (this.selected == 6 && TiltController.isWorking()) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            this.controller = !this.controller;
            Configuration.setGlobalValue("gamepad", this.controller ? 1.0f : 0.0f);
            if (this.controller) {
                this.configureX = true;
                this.configureY = false;
                this.configDone = false;
            } else {
                this.configureX = false;
                this.configureY = false;
                this.configDone = false;
            }
        }
    }

    public void enterState(StateBasedGame game) {
        Mouse.setGrabbed((boolean)false);
        this.dragToMove = Configuration.getGlobalValue("dragmove", 1.0f) != 0.0f;
        this.value = Configuration.getGlobalValue("sense", 0.5f);
        this.autoCentre = Configuration.getGlobalValue("centre", 1.0f) != 0.0f;
        this.controller = Configuration.getGlobalValue("gamepad", 0.0f) != 0.0f;
        this.configureX = false;
        this.configureY = false;
        this.configDone = false;
    }

    public void leaveState(StateBasedGame game) {
        if (!this.configDone) {
            TiltController.setEnabled(false);
        } else {
            TiltController.setEnabled(this.controller);
        }
        Configuration.setGlobalValue("sense", this.value);
    }
}

