/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapStore;
import org.newdawn.tilt.Prefs;

public class Configuration {
    public static Prefs prefs = new Prefs();

    public static void init() {
    }

    public static void remove(String map) {
        Configuration.prefs.data.remove(map);
        prefs.save();
    }

    public static int getBallInUse() {
        int inUse = prefs.getInt("ball", 3);
        if (!Configuration.isBallAvailable(inUse)) {
            Configuration.setBallInUse(3);
            return 3;
        }
        return inUse;
    }

    public static void setBallInUse(int inUse) {
        prefs.putInt("ball", inUse);
    }

    public static boolean isBallAvailable(int index) {
        if (index == 3) {
            return true;
        }
        return prefs.getInt("ball" + index, 0) != 0;
    }

    public static void setBallAvailable(int index) {
        prefs.putInt("ball" + index, 1);
    }

    public static void setBestTime(String map, long best) {
        Map data = MapStore.getMap(map);
        int currentVersion = data.getVersion();
        prefs.putInt(map + "/version", currentVersion);
        prefs.putLong(map + "/best", best);
    }

    public static long getBestTime(String map) {
        int storedVersion;
        Map data = MapStore.getMap(map);
        int currentVersion = data.getVersion();
        if (currentVersion != (storedVersion = prefs.getInt(map + "/version", -1))) {
            Configuration.setBestTime(map, 0L);
        }
        return prefs.getLong(map + "/best", 0L);
    }

    public static float getGlobalValue(String key, float def) {
        return prefs.getFloat("global_" + key, def);
    }

    public static void setGlobalValue(String key, float value) {
        prefs.putFloat("global_" + key, value);
    }
}

