/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.Floor;
import org.newdawn.tilt.FloorStyle;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.tilt.util.FastTrig;
import org.newdawn.util.Log;

public class CircleFloor
extends Floor {
    private Circle bounds;
    private Texture texture;
    private float h;
    private int top;
    private int edges;
    private FloorStyle style;
    private String id;

    public CircleFloor(String id, float x, float y, float rad, float h, FloorStyle style) throws IOException {
        super(id);
        this.id = id;
        this.bounds = new Circle(x, y, rad);
        this.style = style;
        this.h = -h;
        this.texture = style.getTexture();
    }

    public Body getBody() {
        return null;
    }

    public void createImpl() {
        this.top = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.top, (int)4864);
        this.renderTop();
        GL11.glEndList();
        this.edges = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.edges, (int)4864);
        this.renderEdges();
        GL11.glEndList();
    }

    public void destroy() {
        GL11.glDeleteLists((int)this.top, (int)1);
        GL11.glDeleteLists((int)this.edges, (int)1);
    }

    public Shape getShape() {
        return this.bounds;
    }

    public void renderEdges() {
        float scale = 0.5f * this.style.getTextureScale();
        int step = 18;
        float x = this.bounds.getX();
        float y = this.bounds.getY();
        float rad = this.bounds.getRadius();
        float bottom = this.h;
        float top = 0.0f;
        GL11.glBegin((int)7);
        for (int i = 0; i < 360; i += step) {
            float x1 = (float)FastTrig.cos(Math.toRadians(i)) * rad;
            float y1 = (float)FastTrig.sin(Math.toRadians(i)) * rad;
            float x2 = (float)FastTrig.cos(Math.toRadians(i + step)) * rad;
            float y2 = (float)FastTrig.sin(Math.toRadians(i + step)) * rad;
            GL11.glNormal3f((float)((x1 += x) - x), (float)((y1 += y) - y), (float)0.0f);
            GL11.glTexCoord2f((float)(x1 * scale), (float)scale);
            GL11.glVertex3f((float)x1, (float)y1, (float)bottom);
            GL11.glNormal3f((float)((x2 += x) - x), (float)((y2 += y) - y), (float)0.0f);
            GL11.glTexCoord2f((float)(x2 * scale), (float)scale);
            GL11.glVertex3f((float)x2, (float)y2, (float)bottom);
            GL11.glTexCoord2f((float)(x2 * scale), (float)0.0f);
            GL11.glVertex3f((float)x2, (float)y2, (float)top);
            GL11.glNormal3f((float)(x1 - x), (float)(y1 - y), (float)0.0f);
            GL11.glTexCoord2f((float)(x1 * scale), (float)0.0f);
            GL11.glVertex3f((float)x1, (float)y1, (float)top);
        }
        GL11.glEnd();
    }

    public void renderTop() {
        float dodge = 0.0f;
        float scale = 0.5f * this.style.getTextureScale();
        int step = 18;
        float x = this.bounds.getX();
        float y = this.bounds.getY();
        float rad = this.bounds.getRadius();
        float bottom = this.h;
        float top = 0.001f;
        GL11.glBegin((int)4);
        for (int i = 0; i < 360; i += step) {
            float x1 = (float)FastTrig.cos(Math.toRadians(i)) * rad;
            float y1 = (float)FastTrig.sin(Math.toRadians(i)) * rad;
            float x2 = (float)FastTrig.cos(Math.toRadians(i + step)) * rad;
            float y2 = (float)FastTrig.sin(Math.toRadians(i + step)) * rad;
            x1 += x;
            y1 += y;
            x2 += x;
            y2 += y;
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTexCoord2f((float)(x * scale), (float)(y * scale));
            GL11.glVertex3f((float)x, (float)y, (float)top);
            GL11.glTexCoord2f((float)(x1 * scale), (float)(y1 * scale));
            GL11.glVertex3f((float)x1, (float)y1, (float)top);
            GL11.glTexCoord2f((float)(x2 * scale), (float)(y2 * scale));
            GL11.glVertex3f((float)x2, (float)y2, (float)top);
        }
        GL11.glEnd();
    }

    public void renderImpl(int delta, boolean reflection) {
        this.texture.bind();
        GL11.glCallList((int)this.top);
    }

    public void renderOtherImpl(int delta, boolean reflection) {
        this.texture.bind();
        GL11.glCallList((int)this.edges);
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
    }

    public boolean hit(Ball other, float depth) {
        return true;
    }

    public MapElement copy(Map map) {
        try {
            return new CircleFloor(this.id, this.bounds.getX(), this.bounds.getY(), this.bounds.getRadius(), -this.h, this.style);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }
}

