/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.util.Tuple2;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.Floor;
import org.newdawn.tilt.FloorStyle;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.Capsule;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.tilt.util.FastTrig;
import org.newdawn.util.Log;

public class CapsuleFloor
extends Floor {
    private Capsule bounds;
    private Texture texture;
    private float h;
    private int top;
    private int edges;
    private FloorStyle style;
    private float x1;
    private float x2;
    private float y1;
    private float y2;
    private float radius;
    private String id;

    public CapsuleFloor(String id, float x1, float y1, float x2, float y2, float rad, float h, FloorStyle style) throws IOException {
        super(id);
        this.bounds = new Capsule(new Tuple2(x1, y1), new Tuple2(x2, y2), rad);
        this.id = id;
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.radius = rad;
        this.style = style;
        this.h = -h;
        this.texture = style.getTexture();
    }

    public Body getBody() {
        return null;
    }

    public void createImpl() {
        this.top = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.top, (int)4864);
        this.renderTop();
        GL11.glEndList();
        this.edges = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.edges, (int)4864);
        this.renderEdges();
        GL11.glEndList();
    }

    public void destroy() {
        GL11.glDeleteLists((int)this.top, (int)1);
        GL11.glDeleteLists((int)this.edges, (int)1);
    }

    public Shape getShape() {
        return this.bounds;
    }

    public void renderEdges() {
        float bottom = this.h;
        float top = 0.0f;
        float h = 0.6f;
        int step = 30;
        float stretch = 5.0f;
        float scale = 1.0f;
        float offset = 0.0f;
        Tuple2 tangent = new Tuple2(-(this.y2 - this.y1), this.x2 - this.x1);
        tangent.normalise();
        Tuple2 normTan = tangent.copy();
        tangent.scale(this.radius);
        float ang = (float)Math.toDegrees(Math.atan2(this.x2 - this.x1, this.y2 - this.y1));
        if (!(this.x2 > this.x1) || !(this.y2 > this.y1)) {
            offset = -(step / 2);
        }
        ang -= 180.0f;
        if (this.x2 < this.x1 && this.y2 > this.y1) {
            ang -= 180.0f;
        }
        GL11.glBegin((int)7);
        GL11.glNormal3f((float)(-normTan.x), (float)(-normTan.y), (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(this.x2 - tangent.x), (float)(this.y2 - tangent.y), (float)bottom);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(this.x2 - tangent.x), (float)(this.y2 - tangent.y), (float)top);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(this.x1 - tangent.x), (float)(this.y1 - tangent.y), (float)top);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(this.x1 - tangent.x), (float)(this.y1 - tangent.y), (float)bottom);
        GL11.glNormal3f((float)normTan.x, (float)normTan.y, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(this.x2 + tangent.x), (float)(this.y2 + tangent.y), (float)bottom);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(this.x1 + tangent.x), (float)(this.y1 + tangent.y), (float)bottom);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(this.x1 + tangent.x), (float)(this.y1 + tangent.y), (float)top);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(this.x2 + tangent.x), (float)(this.y2 + tangent.y), (float)top);
        boolean mid = false;
        for (int i = 0; i < 360 + step; i += step) {
            float a1 = (float)i + ang - 90.0f + offset;
            float xo1 = (float)FastTrig.cos(Math.toRadians(a1)) * this.radius;
            float yo1 = (float)FastTrig.sin(Math.toRadians(a1)) * this.radius;
            float xo2 = (float)FastTrig.cos(Math.toRadians(a1 + (float)step)) * this.radius;
            float yo2 = (float)FastTrig.sin(Math.toRadians(a1 + (float)step)) * this.radius;
            float bx = 0.0f;
            float by = 0.0f;
            if (i < 180 || i == 180 && !mid) {
                bx = this.x1;
                by = this.y1;
                if (i == 180) {
                    mid = true;
                    i -= step;
                }
            } else {
                bx = this.x2;
                by = this.y2;
            }
            GL11.glNormal3f((float)((xo1 += bx) - bx), (float)((yo1 += by) - by), (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)xo1, (float)yo1, (float)bottom);
            GL11.glNormal3f((float)((xo2 += bx) - bx), (float)((yo2 += by) - by), (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)xo2, (float)yo2, (float)bottom);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)xo2, (float)yo2, (float)top);
            GL11.glNormal3f((float)(xo1 - bx), (float)(yo1 - by), (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)xo1, (float)yo1, (float)top);
        }
        GL11.glEnd();
    }

    public void renderTop() {
        float h = 0.6f;
        int step = 30;
        float stretch = 5.0f;
        float scale = 0.25f;
        float offset = 0.0f;
        Tuple2 tangent = new Tuple2(-(this.y2 - this.y1), this.x2 - this.x1);
        tangent.normalise();
        Tuple2 normTan = tangent.copy();
        tangent.scale(this.radius);
        float ang = (float)Math.toDegrees(Math.atan2(this.x2 - this.x1, this.y2 - this.y1));
        if (this.x2 > this.x1 && this.y2 > this.y1) {
            ang -= 180.0f;
        } else {
            offset = -(step / 2);
        }
        float bottom = h;
        float top = 0.03f;
        GL11.glBegin((int)4);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTexCoord2f((float)((this.x1 + tangent.x) * scale), (float)((this.y1 + tangent.y) * scale));
        GL11.glVertex3f((float)(this.x1 + tangent.x), (float)(this.y1 + tangent.y), (float)top);
        GL11.glTexCoord2f((float)((this.x1 - tangent.x) * scale), (float)((this.y1 - tangent.y) * scale));
        GL11.glVertex3f((float)(this.x1 - tangent.x), (float)(this.y1 - tangent.y), (float)top);
        GL11.glTexCoord2f((float)((this.x2 - tangent.x) * scale), (float)((this.y2 - tangent.y) * scale));
        GL11.glVertex3f((float)(this.x2 - tangent.x), (float)(this.y2 - tangent.y), (float)top);
        GL11.glTexCoord2f((float)((this.x2 + tangent.x) * scale), (float)((this.y2 + tangent.y) * scale));
        GL11.glVertex3f((float)(this.x2 + tangent.x), (float)(this.y2 + tangent.y), (float)top);
        GL11.glTexCoord2f((float)((this.x1 + tangent.x) * scale), (float)((this.y1 + tangent.y) * scale));
        GL11.glVertex3f((float)(this.x1 + tangent.x), (float)(this.y1 + tangent.y), (float)top);
        GL11.glTexCoord2f((float)((this.x2 - tangent.x) * scale), (float)((this.y2 - tangent.y) * scale));
        GL11.glVertex3f((float)(this.x2 - tangent.x), (float)(this.y2 - tangent.y), (float)top);
        boolean mid = false;
        for (int i = 0; i < 360 + step; i += step) {
            float a1 = (float)i + ang - 90.0f + offset;
            float xo1 = (float)FastTrig.cos(Math.toRadians(a1)) * this.radius;
            float yo1 = (float)FastTrig.sin(Math.toRadians(a1)) * this.radius;
            float xo2 = (float)FastTrig.cos(Math.toRadians(a1 + (float)step)) * this.radius;
            float yo2 = (float)FastTrig.sin(Math.toRadians(a1 + (float)step)) * this.radius;
            float bx = 0.0f;
            float by = 0.0f;
            if (i < 180 || i == 180 && !mid) {
                bx = this.x1;
                by = this.y1;
                if (i == 180) {
                    mid = true;
                    i -= step;
                }
            } else {
                bx = this.x2;
                by = this.y2;
            }
            GL11.glTexCoord2f((float)((xo1 += bx) * scale), (float)((yo1 += by) * scale));
            GL11.glVertex3f((float)xo1, (float)yo1, (float)top);
            GL11.glTexCoord2f((float)((xo2 += bx) * scale), (float)((yo2 += by) * scale));
            GL11.glVertex3f((float)xo2, (float)yo2, (float)top);
            GL11.glTexCoord2f((float)(bx * scale), (float)(by * scale));
            GL11.glVertex3f((float)bx, (float)by, (float)top);
        }
        GL11.glEnd();
    }

    public void renderImpl(int delta, boolean reflection) {
        this.texture.bind();
        GL11.glCallList((int)this.top);
    }

    public void renderOtherImpl(int delta, boolean reflection) {
        this.texture.bind();
        GL11.glCallList((int)this.edges);
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
    }

    public boolean hit(Ball other, float depth) {
        return true;
    }

    public MapElement copy(Map map) {
        try {
            return new CapsuleFloor(this.id, this.x1, this.y1, this.x2, this.y2, this.radius, -this.h, this.style);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }
}

