/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.render.util.Tuple2;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.Capsule;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.tilt.util.FastTrig;

public class CapsuleBlock
extends MapElement {
    private static Texture crate;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private float radius;
    private Capsule shape;
    private Body body;
    private int list;

    public static void init() throws IOException {
        crate = TextureLoader.get().getTextureLinear("res/wood2.tga");
    }

    public CapsuleBlock(float x1, float y1, float x2, float y2, float radius) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.radius = radius;
        this.shape = new Capsule(new Tuple2(x1, y1), new Tuple2(x2, y2), radius);
        this.body = new Body(this.shape);
    }

    public Body getBody() {
        return this.body;
    }

    public Shape getShape() {
        return this.shape;
    }

    public static void renderCapsule(float x1, float y1, float x2, float y2, float radius) {
        float by;
        float bx;
        float yo2;
        float xo2;
        float yo1;
        float xo1;
        float a1;
        int i;
        float h = 0.6f;
        int step = 30;
        float top = h;
        float bottom = 0.0f;
        float stretch = 5.0f;
        float scale = 0.5f;
        Tuple2 tangent = new Tuple2(-(y2 - y1), x2 - x1);
        tangent.normalise();
        Tuple2 normTan = tangent.copy();
        tangent.scale(radius);
        float offset = 0.0f;
        float ang = (float)Math.toDegrees(Math.atan2(x2 - x1, y2 - y1));
        if (!(x2 > x1) || !(y2 > y1)) {
            offset = -(step / 2);
        }
        ang -= 180.0f;
        if (x2 < x1 && y2 > y1) {
            ang -= 180.0f;
        }
        GL11.glBegin((int)7);
        GL11.glNormal3f((float)(-normTan.x), (float)(-normTan.y), (float)0.0f);
        GL11.glTexCoord2f((float)stretch, (float)0.0f);
        GL11.glVertex3f((float)(x2 - tangent.x), (float)(y2 - tangent.y), (float)bottom);
        GL11.glTexCoord2f((float)stretch, (float)1.0f);
        GL11.glVertex3f((float)(x2 - tangent.x), (float)(y2 - tangent.y), (float)top);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(x1 - tangent.x), (float)(y1 - tangent.y), (float)top);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(x1 - tangent.x), (float)(y1 - tangent.y), (float)bottom);
        GL11.glNormal3f((float)normTan.x, (float)normTan.y, (float)0.0f);
        GL11.glTexCoord2f((float)stretch, (float)0.0f);
        GL11.glVertex3f((float)(x2 + tangent.x), (float)(y2 + tangent.y), (float)bottom);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(x1 + tangent.x), (float)(y1 + tangent.y), (float)bottom);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(x1 + tangent.x), (float)(y1 + tangent.y), (float)top);
        GL11.glTexCoord2f((float)stretch, (float)1.0f);
        GL11.glVertex3f((float)(x2 + tangent.x), (float)(y2 + tangent.y), (float)top);
        boolean mid = false;
        for (i = 0; i < 360 + step; i += step) {
            a1 = (float)i + ang - 90.0f + offset;
            xo1 = (float)FastTrig.cos(Math.toRadians(a1)) * radius;
            yo1 = (float)FastTrig.sin(Math.toRadians(a1)) * radius;
            xo2 = (float)FastTrig.cos(Math.toRadians(a1 + (float)step)) * radius;
            yo2 = (float)FastTrig.sin(Math.toRadians(a1 + (float)step)) * radius;
            bx = 0.0f;
            by = 0.0f;
            if (i < 180 || i == 180 && !mid) {
                bx = x1;
                by = y1;
                if (i == 180) {
                    mid = true;
                    i -= step;
                }
            } else {
                bx = x2;
                by = y2;
            }
            GL11.glNormal3f((float)((xo1 += bx) - bx), (float)((yo1 += by) - by), (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)xo1, (float)yo1, (float)bottom);
            GL11.glNormal3f((float)((xo2 += bx) - bx), (float)((yo2 += by) - by), (float)0.0f);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)xo2, (float)yo2, (float)bottom);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)xo2, (float)yo2, (float)top);
            GL11.glNormal3f((float)(xo1 - bx), (float)(yo1 - by), (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)xo1, (float)yo1, (float)top);
        }
        GL11.glEnd();
        GL11.glBegin((int)4);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTexCoord2f((float)((x1 + tangent.x) * scale), (float)((y1 + tangent.y) * scale));
        GL11.glVertex3f((float)(x1 + tangent.x), (float)(y1 + tangent.y), (float)top);
        GL11.glTexCoord2f((float)((x1 - tangent.x) * scale), (float)((y1 - tangent.y) * scale));
        GL11.glVertex3f((float)(x1 - tangent.x), (float)(y1 - tangent.y), (float)top);
        GL11.glTexCoord2f((float)((x2 - tangent.x) * scale), (float)((y2 - tangent.y) * scale));
        GL11.glVertex3f((float)(x2 - tangent.x), (float)(y2 - tangent.y), (float)top);
        GL11.glTexCoord2f((float)((x2 + tangent.x) * scale), (float)((y2 + tangent.y) * scale));
        GL11.glVertex3f((float)(x2 + tangent.x), (float)(y2 + tangent.y), (float)top);
        GL11.glTexCoord2f((float)((x1 + tangent.x) * scale), (float)((y1 + tangent.y) * scale));
        GL11.glVertex3f((float)(x1 + tangent.x), (float)(y1 + tangent.y), (float)top);
        GL11.glTexCoord2f((float)((x2 - tangent.x) * scale), (float)((y2 - tangent.y) * scale));
        GL11.glVertex3f((float)(x2 - tangent.x), (float)(y2 - tangent.y), (float)top);
        mid = false;
        for (i = 0; i < 360 + step; i += step) {
            a1 = (float)i + ang - 90.0f - (float)(step / 2);
            xo1 = (float)FastTrig.cos(Math.toRadians(a1)) * radius;
            yo1 = (float)FastTrig.sin(Math.toRadians(a1)) * radius;
            xo2 = (float)FastTrig.cos(Math.toRadians(a1 + (float)step)) * radius;
            yo2 = (float)FastTrig.sin(Math.toRadians(a1 + (float)step)) * radius;
            bx = 0.0f;
            by = 0.0f;
            if (i < 180 || i == 180 && !mid) {
                bx = x1;
                by = y1;
                if (i == 180) {
                    mid = true;
                    i -= step;
                }
            } else {
                bx = x2;
                by = y2;
            }
            GL11.glTexCoord2f((float)((xo1 += bx) * scale), (float)((yo1 += by) * scale));
            GL11.glVertex3f((float)xo1, (float)yo1, (float)top);
            GL11.glTexCoord2f((float)((xo2 += bx) * scale), (float)((yo2 += by) * scale));
            GL11.glVertex3f((float)xo2, (float)yo2, (float)top);
            GL11.glTexCoord2f((float)(bx * scale), (float)(by * scale));
            GL11.glVertex3f((float)bx, (float)by, (float)top);
        }
        GL11.glEnd();
    }

    public void createImpl() {
        this.list = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.list, (int)4864);
        CapsuleBlock.renderCapsule(this.x1, this.y1, this.x2, this.y2, this.radius);
        GL11.glEndList();
    }

    public void destroy() {
        GL11.glDeleteLists((int)this.list, (int)1);
    }

    public void renderImpl(int delta, boolean reflection) {
        crate.bind();
        GL11.glCallList((int)this.list);
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
    }

    public boolean hit(Ball ball, float depth) {
        return false;
    }

    public MapElement copy(Map map) {
        return new CapsuleBlock(this.x1, this.y1, this.x2, this.y2, this.radius);
    }
}

