/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.models.obj.ObjLoader;
import org.newdawn.render.models.obj.ObjModel;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.Bridge;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.AABox;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;

public class Bumper
extends MapElement {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private static ObjModel model;
    private static Sound thud;
    private static Texture texture;
    private AABox bounds;
    private float x;
    private float y;
    private Map map;
    private Body body;
    private int type;
    private float zrot;
    private float z;
    private int interval;
    private String id;
    private int timeout;
    private ArrayList bumpers = new ArrayList();
    private ArrayList bridges = new ArrayList();

    public static void init() throws IOException {
        thud = SoundStore.get().getOgg("res/sounds/thud.ogg");
        model = ObjLoader.loadObj((String)"res/bumper.obj");
        texture = TextureLoader.get().getTextureLinear("res/bumper.tga");
    }

    public Bumper(Map map, float x, float y, int type, String id) {
        this.x = x;
        this.y = y;
        this.map = map;
        this.type = type;
        this.interval = 10000;
        this.id = id;
        if (id != null) {
            this.interval = Integer.parseInt(id);
        }
        if (type == 1) {
            this.zrot = 0.0f;
            this.bounds = new AABox(x - 0.4f, y - 0.1f, 0.8f, 0.2f);
        }
        if (type == 2) {
            this.zrot = 90.0f;
            this.bounds = new AABox(x - 0.1f, y - 0.4f, 0.2f, 0.8f);
        }
        this.body = new Body(this.bounds);
    }

    public Body getBody() {
        return this.body;
    }

    public void createImpl() {
    }

    public void destroy() {
    }

    public Shape getShape() {
        return this.bounds;
    }

    public void renderImpl(int delta, boolean reflection) {
        GL11.glPushMatrix();
        float shudderx = 0.0f;
        float shuddery = 0.0f;
        if (this.z < 0.0f && this.timeout < this.interval / 4) {
            shudderx = (float)(Math.random() * (double)0.02f - (double)0.01f);
            shuddery = (float)(Math.random() * (double)0.02f - (double)0.01f);
        }
        GL11.glTranslatef((float)(this.x + shudderx), (float)(this.y + shuddery), (float)this.z);
        GL11.glRotatef((float)this.zrot, (float)0.0f, (float)0.0f, (float)1.0f);
        Map.render(texture, model, null, !reflection);
        GL11.glPopMatrix();
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
        if (this.timeout > 0) {
            this.timeout -= delta;
            if (this.timeout <= 0) {
                this.z = 0.0f;
                thud.playAsSoundEffect(2.0f, 1.0f);
                this.checkBridgeStatus();
            }
        }
    }

    public boolean hit(Ball ball, float depth) {
        if (this.z == 0.0f) {
            this.timeout = this.interval;
            this.z = -0.5f;
            thud.playAsSoundEffect(2.0f, 1.0f);
            this.checkBridgeStatus();
        }
        return false;
    }

    public boolean isDown() {
        return this.z != 0.0f;
    }

    private void checkBridgeStatus() {
        int i;
        boolean allDown = true;
        this.map.getElements(Bumper.class, this.bumpers);
        for (i = 0; i < this.bumpers.size(); ++i) {
            Bumper bumper = (Bumper)this.bumpers.get(i);
            if (bumper.isDown()) continue;
            allDown = false;
        }
        this.map.getElements(Bridge.class, this.bridges);
        for (i = 0; i < this.bridges.size(); ++i) {
            Bridge bridge = (Bridge)this.bridges.get(i);
            bridge.setPresent(allDown);
        }
    }

    public MapElement copy(Map map) {
        return new Bumper(map, this.x, this.y, this.type, this.id);
    }
}

