/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.Floor;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.AABox;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.util.Log;

public class Bridge
extends Floor {
    private static Sound noise;
    private static Texture texture;
    private AABox box;
    private AABox gone;
    private float h;
    private int top;
    private int edges;
    private boolean fall;
    private float fade;
    private float ox;
    private float oy;
    private boolean present;
    private float toffset;
    private String id;

    public static void init() throws IOException {
        noise = SoundStore.get().getOgg("res/sounds/teleport.ogg");
        texture = TextureLoader.get().getTextureLinear("res/plasma.tga");
    }

    public Bridge(String id, float x, float y, float width, float height, float h) throws IOException {
        super(id);
        this.id = id;
        this.box = new AABox(x, y, width, height);
        this.gone = new AABox(10000.0f, 10000.0f, 0.0f, 0.0f);
        this.h = -h;
    }

    public Body getBody() {
        return null;
    }

    public void createImpl() {
        this.top = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.top, (int)4864);
        this.renderBox();
        GL11.glEndList();
        this.edges = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.edges, (int)4864);
        this.renderEdges();
        GL11.glEndList();
    }

    public void destroy() {
        GL11.glDeleteLists((int)this.top, (int)1);
        GL11.glDeleteLists((int)this.edges, (int)1);
    }

    public Shape getShape() {
        if (this.fade == 0.0f) {
            return this.gone;
        }
        return this.box;
    }

    public void setPresent(boolean present) {
        if (this.present != present) {
            this.present = present;
            noise.playAsSoundEffect(1.7f, 0.15f);
        }
    }

    public void renderBox() {
        float scale = 0.5f;
        float dodge = -0.1f;
        GL11.glBegin((int)7);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTexCoord2f((float)(this.box.getX() * scale), (float)(this.box.getY() * scale));
        GL11.glVertex3f((float)this.box.getX(), (float)this.box.getY(), (float)dodge);
        GL11.glTexCoord2f((float)(this.box.getX2() * scale), (float)(this.box.getY() * scale));
        GL11.glVertex3f((float)this.box.getX2(), (float)this.box.getY(), (float)dodge);
        GL11.glTexCoord2f((float)(this.box.getX2() * scale), (float)(this.box.getY2() * scale));
        GL11.glVertex3f((float)this.box.getX2(), (float)this.box.getY2(), (float)dodge);
        GL11.glTexCoord2f((float)(this.box.getX() * scale), (float)(this.box.getY2() * scale));
        GL11.glVertex3f((float)this.box.getX(), (float)this.box.getY2(), (float)dodge);
        GL11.glEnd();
    }

    public void renderEdges() {
        float scale;
        float dodge = -0.1f;
        float scale2 = scale = 0.5f;
        GL11.glBegin((int)7);
        float xdam = this.box.getY() % 2.0f;
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)((this.box.getX() + xdam) * scale), (float)0.0f);
        GL11.glVertex3f((float)this.box.getX(), (float)this.box.getY(), (float)dodge);
        GL11.glTexCoord2f((float)((this.box.getX() + xdam) * scale), (float)(this.h * scale2));
        GL11.glVertex3f((float)this.box.getX(), (float)this.box.getY(), (float)this.h);
        GL11.glTexCoord2f((float)((this.box.getX2() + xdam) * scale), (float)(this.h * scale2));
        GL11.glVertex3f((float)this.box.getX2(), (float)this.box.getY(), (float)this.h);
        GL11.glTexCoord2f((float)((this.box.getX2() + xdam) * scale), (float)0.0f);
        GL11.glVertex3f((float)this.box.getX2(), (float)this.box.getY(), (float)dodge);
        xdam = this.box.getX2() % 2.0f + 1.0f;
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)((this.box.getX() + xdam) * scale), (float)0.0f);
        GL11.glVertex3f((float)this.box.getX(), (float)this.box.getY2(), (float)dodge);
        GL11.glTexCoord2f((float)((this.box.getX2() + xdam) * scale), (float)0.0f);
        GL11.glVertex3f((float)this.box.getX2(), (float)this.box.getY2(), (float)dodge);
        GL11.glTexCoord2f((float)((this.box.getX2() + xdam) * scale), (float)(this.h * scale2));
        GL11.glVertex3f((float)this.box.getX2(), (float)this.box.getY2(), (float)this.h);
        GL11.glTexCoord2f((float)((this.box.getX() + xdam) * scale), (float)(this.h * scale2));
        GL11.glVertex3f((float)this.box.getX(), (float)this.box.getY2(), (float)this.h);
        xdam = this.box.getX() % 2.0f;
        GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)((this.box.getY() + xdam) * scale), (float)0.0f);
        GL11.glVertex3f((float)this.box.getX(), (float)this.box.getY(), (float)dodge);
        GL11.glTexCoord2f((float)((this.box.getY2() + xdam) * scale), (float)0.0f);
        GL11.glVertex3f((float)this.box.getX(), (float)this.box.getY2(), (float)dodge);
        GL11.glTexCoord2f((float)((this.box.getY2() + xdam) * scale), (float)(this.h * scale2));
        GL11.glVertex3f((float)this.box.getX(), (float)this.box.getY2(), (float)this.h);
        GL11.glTexCoord2f((float)((this.box.getY() + xdam) * scale), (float)(this.h * scale2));
        GL11.glVertex3f((float)this.box.getX(), (float)this.box.getY(), (float)this.h);
        xdam = this.box.getX2() % 2.0f + 1.0f;
        GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)((this.box.getY() + xdam) * scale), (float)0.0f);
        GL11.glVertex3f((float)this.box.getX2(), (float)this.box.getY(), (float)dodge);
        GL11.glTexCoord2f((float)((this.box.getY() + xdam) * scale), (float)(this.h * scale2));
        GL11.glVertex3f((float)this.box.getX2(), (float)this.box.getY(), (float)this.h);
        GL11.glTexCoord2f((float)((this.box.getY2() + xdam) * scale), (float)(this.h * scale2));
        GL11.glVertex3f((float)this.box.getX2(), (float)this.box.getY2(), (float)this.h);
        GL11.glTexCoord2f((float)((this.box.getY2() + xdam) * scale), (float)0.0f);
        GL11.glVertex3f((float)this.box.getX2(), (float)this.box.getY2(), (float)dodge);
        GL11.glEnd();
    }

    public void renderImpl(int delta, boolean reflection) {
        if (this.fade == 0.0f) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)1.0f, (float)this.fade);
        GL11.glMatrixMode((int)5890);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)this.toffset, (float)0.0f);
        GL11.glMatrixMode((int)5888);
        texture.bind();
        GL11.glCallList((int)this.top);
        GL11.glMatrixMode((int)5890);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glDisable((int)3042);
    }

    public void renderOtherImpl(int delta, boolean reflection) {
        if (this.fade == 0.0f) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)1.0f, (float)this.fade);
        texture.bind();
        GL11.glCallList((int)this.edges);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glDisable((int)3042);
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
        if (this.present && this.fade < 0.3f) {
            this.fade += (float)delta * 0.001f;
            if (this.fade > 0.3f) {
                this.fade = 0.3f;
            }
        }
        if (!this.present && this.fade > 0.0f) {
            this.fade -= (float)delta * 0.001f;
            if (this.fade < 0.0f) {
                this.fade = 0.0f;
            }
        }
        this.toffset -= (float)delta * 5.0E-4f;
    }

    public boolean hit(Ball other, float depth) {
        return true;
    }

    public MapElement copy(Map map) {
        try {
            return new Bridge(this.id, this.box.getX(), this.box.getY(), this.box.getWidth(), this.box.getHeight(), -this.h);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }
}

