/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.models.obj.ObjLoader;
import org.newdawn.render.models.obj.ObjModel;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.util.Log;

public class Bouncer
extends MapElement {
    private static ObjModel model;
    private static Sound rebound;
    private static Texture texture;
    private float x;
    private float y;
    private Map map;
    private String data;
    private Body body;
    private float scale;

    public static void init() throws IOException {
        model = ObjLoader.loadObj((String)"res/bouncer.obj");
        rebound = SoundStore.get().getOgg("res/sounds/rebound.ogg");
        texture = TextureLoader.get().getTextureLinear("res/bouncer.tga");
    }

    public Bouncer(Map map, float x, float y, String data) throws IOException {
        this.x = x;
        this.y = y;
        this.map = map;
        this.data = data;
        this.body = new Body(new Circle(x, y, 0.35f));
    }

    public Body getBody() {
        return this.body;
    }

    public Shape getShape() {
        return this.body.getShape();
    }

    public void createImpl() {
    }

    public void destroy() {
    }

    public void renderImpl(int delta, boolean reflection) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        GL11.glScalef((float)(1.0f + this.scale), (float)(1.0f + this.scale), (float)1.0f);
        Map.render(texture, model, null, !reflection);
        GL11.glPopMatrix();
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
        if (this.scale > 0.0f) {
            this.scale -= (float)delta * 0.001f;
            if (this.scale < 0.0f) {
                this.scale = 0.0f;
            }
        }
    }

    public boolean hit(Ball ball, float depth) {
        float dx = this.x - ball.getX();
        float dy = this.y - ball.getY();
        ball.adjustVelocity(dx * 2.5f, dy * 2.5f);
        this.scale = 0.3f;
        rebound.playAsSoundEffect(0.9f + (float)(Math.random() * (double)0.1f), 1.0f);
        return false;
    }

    public MapElement copy(Map map) {
        try {
            return new Bouncer(map, this.x, this.y, this.data);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }
}

