/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.util.StringTokenizer;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.tilt.Ball;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.geom.AABox;
import org.newdawn.tilt.geom.CollisionResult;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.util.Log;

public class Block
extends MapElement {
    private static Sound slide;
    private static Texture crate;
    private static Texture metal;
    private static Texture redwall;
    private static Texture bluewall;
    private static Texture yellowwall;
    public static final int WOOD = 1;
    public static final int METAL = 2;
    public static final int RED = 3;
    public static final int BLUE = 4;
    public static final int YELLOW = 5;
    public static final int INVISIBLE = 6;
    private int type;
    protected AABox box;
    private Texture texture;
    private float h;
    private int list;
    protected Body body;
    private float z;
    private float targetZ;
    private int lastPlay = 0;
    private Map map;
    private boolean soft;
    private boolean faded = false;
    private Ball fadeBall;
    private float fadeValue = 1.0f;
    private String id;
    private boolean updown;
    private int interval;
    private int updownTimer;
    private CollisionResult result = new CollisionResult();

    public static void init() throws IOException {
        slide = SoundStore.get().getOgg("res/sounds/doorslide.ogg");
        crate = TextureLoader.get().getTextureLinear("res/crate.tga");
        metal = TextureLoader.get().getTextureLinear("res/metal.tga");
        redwall = TextureLoader.get().getTextureLinear("res/redwall.tga");
        bluewall = TextureLoader.get().getTextureLinear("res/bluewall.tga");
        yellowwall = TextureLoader.get().getTextureLinear("res/yellowwall.tga");
    }

    public Block(Map map, float x, float y, float width, float height, float h, int type, boolean soft) throws IOException {
        this(map, x, y, width, height, h, type, soft, "");
    }

    public Block(Map map, float x, float y, float width, float height, float h, int type, boolean soft, String id) throws IOException {
        this.box = new AABox(x, y, width, height);
        this.id = id;
        this.soft = soft;
        this.map = map;
        this.h = h;
        this.type = type;
        this.texture = crate;
        if (type == 2) {
            this.texture = metal;
        }
        if (type == 3) {
            this.texture = redwall;
            this.box.setX(x + 0.01f);
            this.box.setWidth(width - 0.02f);
            this.box.setY(y + 0.01f);
            this.box.setHeight(height - 0.02f);
        }
        if (type == 4) {
            this.texture = bluewall;
            this.box.setX(x + 0.01f);
            this.box.setWidth(width - 0.02f);
            this.box.setY(y + 0.01f);
            this.box.setHeight(height - 0.02f);
        }
        if (type == 5) {
            this.texture = yellowwall;
            this.box.setX(x + 0.01f);
            this.box.setWidth(width - 0.02f);
            this.box.setY(y + 0.01f);
            this.box.setHeight(height - 0.02f);
        }
        if (!soft) {
            this.body = new Body(this.box);
        }
        if (id.indexOf("updown") >= 0) {
            this.z = -(h - 0.05f);
            this.setTargetZ(this.z, false);
            StringTokenizer tokens = new StringTokenizer(id, ",");
            tokens.nextToken();
            tokens.nextToken();
            tokens.nextToken();
            this.updown = true;
            this.interval = 1000;
            if (tokens.hasMoreTokens()) {
                this.interval = Integer.parseInt(tokens.nextToken());
            }
            this.updownTimer = 0;
            if (tokens.hasMoreTokens()) {
                this.updownTimer = Integer.parseInt(tokens.nextToken());
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public void createImpl() {
        if (this.type == 6) {
            return;
        }
        this.list = GL11.glGenLists((int)1);
        GL11.glNewList((int)this.list, (int)4864);
        Block.renderBox(this.box, this.h, this.type);
        GL11.glEndList();
    }

    public void destroy() {
        if (this.type == 6) {
            return;
        }
        GL11.glDeleteLists((int)this.list, (int)1);
    }

    public Shape getShape() {
        return this.box;
    }

    public static void renderBox(AABox box, float h) {
        Block.renderBox(box, h, 1);
    }

    public static void renderBox(AABox box, float h, int type) {
        float scaleu = 1.0f / box.getWidth();
        float scalev = 1.0f / box.getHeight();
        float scalez = 0.5f / h;
        GL11.glBegin((int)7);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)box.getX(), (float)box.getY(), (float)h);
        GL11.glTexCoord2f((float)(box.getWidth() * scaleu), (float)0.0f);
        GL11.glVertex3f((float)box.getX2(), (float)box.getY(), (float)h);
        GL11.glTexCoord2f((float)(box.getWidth() * scaleu), (float)(box.getHeight() * scalev));
        GL11.glVertex3f((float)box.getX2(), (float)box.getY2(), (float)h);
        GL11.glTexCoord2f((float)0.0f, (float)(box.getHeight() * scalev));
        GL11.glVertex3f((float)box.getX(), (float)box.getY2(), (float)h);
        if (type == 3 || type == 4 || type == 5) {
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)box.getX(), (float)box.getY(), (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)(box.getHeight() * scalev));
            GL11.glVertex3f((float)box.getX(), (float)box.getY2(), (float)0.0f);
            GL11.glTexCoord2f((float)(box.getWidth() * scaleu), (float)(box.getHeight() * scalev));
            GL11.glVertex3f((float)box.getX2(), (float)box.getY2(), (float)0.0f);
            GL11.glTexCoord2f((float)(box.getWidth() * scaleu), (float)0.0f);
            GL11.glVertex3f((float)box.getX2(), (float)box.getY(), (float)0.0f);
        }
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)((box.getX() + 1.0f) * scaleu), (float)(h * scalez));
        GL11.glVertex3f((float)box.getX(), (float)box.getY(), (float)h);
        GL11.glTexCoord2f((float)((box.getX() + 1.0f) * scaleu), (float)0.0f);
        GL11.glVertex3f((float)box.getX(), (float)box.getY(), (float)0.0f);
        GL11.glTexCoord2f((float)((box.getX2() + 1.0f) * scaleu), (float)0.0f);
        GL11.glVertex3f((float)box.getX2(), (float)box.getY(), (float)0.0f);
        GL11.glTexCoord2f((float)((box.getX2() + 1.0f) * scaleu), (float)(h * scalez));
        GL11.glVertex3f((float)box.getX2(), (float)box.getY(), (float)h);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)((box.getX() + 1.0f) * scaleu), (float)(h * scalez));
        GL11.glVertex3f((float)box.getX(), (float)box.getY2(), (float)h);
        GL11.glTexCoord2f((float)((box.getX2() + 1.0f) * scaleu), (float)(h * scalez));
        GL11.glVertex3f((float)box.getX2(), (float)box.getY2(), (float)h);
        GL11.glTexCoord2f((float)((box.getX2() + 1.0f) * scaleu), (float)0.0f);
        GL11.glVertex3f((float)box.getX2(), (float)box.getY2(), (float)0.0f);
        GL11.glTexCoord2f((float)((box.getX() + 1.0f) * scaleu), (float)0.0f);
        GL11.glVertex3f((float)box.getX(), (float)box.getY2(), (float)0.0f);
        GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)((box.getY() + 1.0f) * scalev), (float)(h * scalez));
        GL11.glVertex3f((float)box.getX(), (float)box.getY(), (float)h);
        GL11.glTexCoord2f((float)((box.getY2() + 1.0f) * scalev), (float)(h * scalez));
        GL11.glVertex3f((float)box.getX(), (float)box.getY2(), (float)h);
        GL11.glTexCoord2f((float)((box.getY2() + 1.0f) * scalev), (float)0.0f);
        GL11.glVertex3f((float)box.getX(), (float)box.getY2(), (float)0.0f);
        GL11.glTexCoord2f((float)((box.getY() + 1.0f) * scalev), (float)0.0f);
        GL11.glVertex3f((float)box.getX(), (float)box.getY(), (float)0.0f);
        GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)((box.getY() + 1.0f) * scalev), (float)(h * scalez));
        GL11.glVertex3f((float)box.getX2(), (float)box.getY(), (float)h);
        GL11.glTexCoord2f((float)((box.getY() + 1.0f) * scalev), (float)0.0f);
        GL11.glVertex3f((float)box.getX2(), (float)box.getY(), (float)0.0f);
        GL11.glTexCoord2f((float)((box.getY2() + 1.0f) * scalev), (float)0.0f);
        GL11.glVertex3f((float)box.getX2(), (float)box.getY2(), (float)0.0f);
        GL11.glTexCoord2f((float)((box.getY2() + 1.0f) * scalev), (float)(h * scalez));
        GL11.glVertex3f((float)box.getX2(), (float)box.getY2(), (float)h);
        GL11.glEnd();
    }

    public void renderImpl(int delta, boolean reflection) {
        if (this.type == 6) {
            return;
        }
        if (this.fadeValue < 1.0f && !reflection) {
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.fadeValue);
        }
        this.texture.bind();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)this.z);
        GL11.glCallList((int)this.list);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-this.z));
        if (this.fadeValue < 1.0f && !reflection) {
            GL11.glDisable((int)3042);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void setTargetZ(float targetZ) {
        this.setTargetZ(targetZ, true);
    }

    public void setTargetZ(float targetZ, boolean sound) {
        if (this.targetZ == targetZ) {
            return;
        }
        if (this.lastPlay < 0) {
            this.lastPlay = 600;
            slide.playAsSoundEffect(1.0f, 1.0f);
        }
        this.targetZ = targetZ;
    }

    public void update(GlobalEmitter emitter, int delta, float boardRollX, float boardRollY) {
        if (this.type == 6) {
            return;
        }
        this.lastPlay -= delta;
        if (this.updown) {
            this.updownTimer -= delta;
            if (this.updownTimer <= 0) {
                this.updownTimer = this.interval;
                if (this.z < 0.0f) {
                    this.setTargetZ(0.0f, false);
                } else {
                    this.setTargetZ(-(this.h - 0.05f), false);
                }
            }
        }
        if (this.z > this.targetZ) {
            this.z -= (float)delta * 0.001f;
            if (this.updown) {
                this.z -= (float)delta * 0.003f;
            }
            if (this.z <= this.targetZ) {
                this.z = this.targetZ;
            }
            if (this.z < 0.5f && !this.updown && !this.map.clear(this, this.box)) {
                this.z = 0.5f;
            }
        } else if (this.z < this.targetZ) {
            this.z += (float)delta * 0.001f;
            if (this.updown) {
                this.z += (float)delta * 0.003f;
            }
            if (this.z >= this.targetZ) {
                this.z = this.targetZ;
            }
            if (this.updown && !this.map.clear(this, this.box)) {
                this.updownTimer = 0;
                this.z = -(this.h - 0.05f);
            }
        }
        if (!this.soft) {
            this.body.setActive(this.z < 0.5f && this.z >= -(this.h - 0.1f));
        }
        if (this.fadeBall != null) {
            this.result.missed();
            this.fadeBall.getShape().collides(0.0f, 0.0f, this.box, false, this.result);
            if (!this.result.collided()) {
                this.fadeBall = null;
                this.faded = false;
            }
        }
        if (this.faded && this.fadeValue > 0.5f) {
            this.fadeValue -= (float)delta * 0.002f;
            this.fadeValue = Math.max(0.5f, this.fadeValue);
        }
        if (!this.faded && this.fadeValue < 1.0f) {
            this.fadeValue += (float)delta * 0.002f;
            this.fadeValue = Math.min(1.0f, this.fadeValue);
        }
    }

    public String toString() {
        return "[Block (" + super.toString() + ") " + this.box + " " + this.type + ")";
    }

    public boolean hit(Ball other, float depth) {
        if (this.soft) {
            this.faded = true;
            this.fadeBall = other;
            return true;
        }
        return false;
    }

    public MapElement copy(Map map) {
        try {
            return new Block(map, this.box.getX(), this.box.getY(), this.box.getWidth(), this.box.getHeight(), this.h, this.type, this.soft, this.id);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public Body getBody() {
        return this.body;
    }
}

