/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.Sys;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.render.util.Color;
import org.newdawn.render.window.LWJGLWindow;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.state.GameState;
import org.newdawn.state.StateBasedGame;
import org.newdawn.state.transitions.FadeInTransition;
import org.newdawn.state.transitions.FadeOutTransition;
import org.newdawn.state.transitions.Transition;
import org.newdawn.tilt.Configuration;
import org.newdawn.tilt.MapStore;
import org.newdawn.tilt.MouseOverArea;
import org.newdawn.tilt.MouseOverGroup;
import org.newdawn.tilt.SharedUI;
import org.newdawn.tilt.TiltController;
import org.newdawn.tilt.reg.PostConnection;
import org.newdawn.tilt.reg.PostListener;
import org.newdawn.util.Log;

public class BestTimesState
implements GameState,
PostListener {
    public static final int ID = 76;
    private static String SUBMIT_URL = "http://www.tiltilation.com/submittimes.php";
    private static String VIEW_URL = "http://www.tiltilation.com/besttimes.php";
    private LWJGLWindow window;
    private Texture title;
    private Texture back;
    private Texture update;
    private Texture view;
    private MouseOverArea updateArea;
    private MouseOverArea viewArea;
    private MouseOverArea backArea;
    private MouseOverGroup group;
    private int selected;
    private int rank = -1;
    private int score = -1;
    private String message;
    private String message2;
    private int lastView;
    private Color gray = new Color(0.0f, 0.0f, 0.0f, 0.3f);
    private int rankTimer;
    private int scoreTimer;
    private Sound thud;

    public BestTimesState(LWJGLWindow window) {
        this.window = window;
    }

    private void renderRectangle(float x, float y, float width, float height) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glEnd();
    }

    public void init(StateBasedGame game) throws IOException {
        this.thud = SoundStore.get().getOgg("res/sounds/thud.ogg");
        this.title = TextureLoader.get().getTextureLinear("res/besttimes.tga");
        this.back = TextureLoader.get().getTextureLinear("res/backtomenu.tga");
        this.update = TextureLoader.get().getTextureLinear("res/bt_update.tga");
        this.view = TextureLoader.get().getTextureLinear("res/bt_view.tga");
        this.backArea = new MouseOverArea(this.window, 200.0f, 540.0f, 200.0f, 50.0f);
        this.viewArea = new MouseOverArea(this.window, 150.0f, 350.0f, 300.0f, 60.0f);
        this.updateArea = new MouseOverArea(this.window, 150.0f, 425.0f, 300.0f, 50.0f);
        this.group = new MouseOverGroup("besttimes");
        this.group.addArea(this.viewArea);
        this.group.addArea(this.updateArea);
        this.group.addArea(this.backArea);
    }

    public void reinit(StateBasedGame game) throws IOException {
    }

    public void render(StateBasedGame game, int delta) {
        this.window.enterOrtho(600, 600);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.title.bind();
        this.renderRectangle(190.0f, 10.0f, 256.0f, 128.0f);
        float col = 0.75f + this.viewArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.view.bind();
        this.renderRectangle(190.0f, 350.0f, 256.0f, 128.0f);
        col = 0.75f + this.updateArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.update.bind();
        this.renderRectangle(170.0f, 425.0f, 512.0f, 128.0f);
        col = 0.75f + this.backArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.back.bind();
        this.renderRectangle(185.0f, 540.0f, 256.0f, 64.0f);
        String text = this.message;
        int xp = (600 - SharedUI.bigFontO.getWidth(text)) / 2;
        if (this.rankTimer < 0) {
            SharedUI.bigFontO.drawString(xp + 3, 203, text, this.gray);
            SharedUI.bigFontO.drawString(xp, 200, text, Color.white);
        }
        text = this.message2;
        xp = (600 - SharedUI.bigFontO.getWidth(text)) / 2;
        if (this.scoreTimer < 0) {
            SharedUI.bigFontO.drawString(xp + 3, 253, text, this.gray);
            SharedUI.bigFontO.drawString(xp, 250, text, Color.white);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        this.window.leaveOrtho();
    }

    private void drawString(int y, String text) {
        int x = (600 - SharedUI.smallFontO.getWidth(text)) / 2;
        SharedUI.smallFontO.drawString(x + 3, y + 3, text, this.gray);
        SharedUI.smallFontO.drawString(x, y, text, Color.white);
    }

    public void update(StateBasedGame game, int delta) {
        if (this.rankTimer >= 0) {
            this.rankTimer -= delta;
            if (this.rankTimer < 0) {
                this.thud.playAsSoundEffect(1.0f, 1.0f);
            }
        }
        if (this.scoreTimer >= 0) {
            this.scoreTimer -= delta;
            if (this.scoreTimer < 0) {
                this.thud.playAsSoundEffect(1.0f, 1.0f);
            }
        }
        if (this.lastView >= 0) {
            this.lastView -= delta;
        }
        int oldSelected = this.selected;
        this.selected = 0;
        if (this.backArea.considerMouse(delta)) {
            this.selected = 3;
        }
        if (this.viewArea.considerMouse(delta)) {
            this.selected = 1;
        }
        if (this.updateArea.considerMouse(delta)) {
            this.selected = 2;
        }
        if (oldSelected != this.selected && this.selected != 0) {
            SharedUI.playOver();
        }
        this.group.update();
        if (TiltController.buttonPressed()) {
            this.selectOption(game);
        }
        while (Mouse.next()) {
            if (Mouse.getEventButton() < 0 || !Mouse.getEventButtonState()) continue;
            this.selectOption(game);
        }
    }

    private void selectOption(StateBasedGame game) {
        if (this.selected == 1) {
            if (this.lastView <= 0) {
                this.lastView = 5000;
                Sys.openURL((String)VIEW_URL);
            }
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            return;
        }
        if (this.selected == 2) {
            this.submit();
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            return;
        }
        if (this.selected == 3) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            game.changeToState(2, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
            return;
        }
    }

    private void submit() {
        if (this.scoreTimer > 0) {
            return;
        }
        PostConnection conn = new PostConnection(SUBMIT_URL, this);
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 20; ++y) {
                if (!MapStore.exists(x, y)) continue;
                long bestTime = Configuration.getBestTime(MapStore.getMapName(x, y));
                int version = MapStore.getMap(x, y).getVersion();
                if (bestTime == 0L) continue;
                bestTime *= (long)((x + 1) * (y + 1) * 10);
                conn.addAttribute("b" + x + "-" + y, "" + (bestTime += 111L) * (long)version);
                conn.addAttribute("v" + x + "-" + y, "" + version);
            }
        }
        conn.addAttribute("k", Configuration.prefs.getString("r3", ""));
        conn.addAttribute("n", Configuration.prefs.getString("r1", ""));
        conn.addAttribute("webname", Configuration.prefs.getString("webname", ""));
        this.rank = -1;
        this.score = -1;
        Log.log((String)"Submitting...");
        conn.post();
    }

    public void enterState(StateBasedGame game) {
        Mouse.setGrabbed((boolean)false);
        this.rankTimer = -1;
        this.scoreTimer = -1;
        this.group.reset();
        this.rank = (int)Configuration.getGlobalValue("rank", -1.0f);
        this.score = (int)Configuration.getGlobalValue("score", 0.0f);
        if (this.rank == -1) {
            this.message = "Select Update Times to get";
            this.message2 = "your world wide ranking!";
        } else {
            this.updateMessage(this.rank, this.score);
        }
    }

    public void updateMessage(int rank, int score) {
        Configuration.setGlobalValue("rank", rank);
        Configuration.setGlobalValue("score", score);
        this.message = "Your Online Rank: #" + rank;
        this.message2 = "Your Online Score: " + score;
    }

    public void leaveState(StateBasedGame game) {
    }

    public void failed() {
        this.message = "Unable to contact servers";
        this.message2 = "Try again later";
    }

    public void reportLine(String line) {
        Log.log((String)("Recieved '" + line + "'"));
        try {
            if (this.score == -1) {
                this.score = Integer.parseInt(line);
            } else if (this.rank == -1) {
                this.rank = Integer.parseInt(line) + 1;
                this.updateMessage(this.rank, this.score);
                this.rankTimer = 500;
                this.scoreTimer = 1400;
            }
        }
        catch (NumberFormatException e) {
            Log.log((Throwable)e);
            this.failed();
        }
    }
}

