/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import java.nio.FloatBuffer;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.models.obj.ObjLoader;
import org.newdawn.render.models.obj.ObjModel;
import org.newdawn.render.particles.ParticleEngine;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.render.util.Color;
import org.newdawn.sound.Sound;
import org.newdawn.sound.SoundStore;
import org.newdawn.tilt.Configuration;
import org.newdawn.tilt.ExitItem;
import org.newdawn.tilt.Floor;
import org.newdawn.tilt.GlobalEmitter;
import org.newdawn.tilt.Map;
import org.newdawn.tilt.MapElement;
import org.newdawn.tilt.Teleport;
import org.newdawn.tilt.balls.BallType;
import org.newdawn.tilt.balls.BigBall;
import org.newdawn.tilt.balls.EyeBall;
import org.newdawn.tilt.balls.StandardBall;
import org.newdawn.tilt.effect.ParticleEffect;
import org.newdawn.tilt.effect.ParticleProvider;
import org.newdawn.tilt.geom.Circle;
import org.newdawn.tilt.geom.Shape;
import org.newdawn.tilt.physics.Body;
import org.newdawn.tilt.physics.DynamicBody;
import org.newdawn.tilt.util.FastTrig;
import org.newdawn.util.Log;

public class Ball
extends MapElement
implements ParticleEffect {
    private static final float FRICTION2 = 0.999f;
    private static Sound hit;
    private static Sound fall;
    private static Sound leave;
    private static Sound grow;
    private static Sound pop;
    private static Texture texture;
    private static Texture eye;
    private static Texture footieTexture;
    private static Texture beach;
    private static Texture eightBall;
    private static Texture puddingTexture;
    private static Texture maceTexture;
    private static ObjModel model;
    private static ObjModel facemodel;
    private static ObjModel footie;
    private static ObjModel pudding;
    private static ObjModel mace;
    private int hitCount;
    public static BallType[] renderers;
    public static Texture[] rendererIcons;
    private Circle bounds;
    private Circle center;
    private Circle edged;
    private float vz;
    private float z;
    private Map map;
    private boolean dead;
    private Quat4f rot;
    private FloatBuffer matBuf;
    private boolean complete;
    private ExitItem exit;
    private DynamicBody body;
    private float oldx;
    private float oldy;
    private boolean teleportOut;
    private boolean teleportIn;
    private float teleportScale = 1.0f;
    private Teleport teleport;
    private float teleportFlashIn;
    private float teleportStartX;
    private float teleportStartY;
    private boolean exploding;
    private GlobalEmitter emitter;
    private int explosionTimeout = 1500;
    private float ex;
    private float ey;
    private float size = 1.0f;
    private int shrinkTimer;
    private int shrinkEffect;
    private int speedUp;
    private boolean popping;
    private boolean popped;
    private int popTimer;
    private int powerPill = -100;
    private float lastMoveX;
    private float lastMoveY;
    private Matrix4f mat = new Matrix4f();
    private Quat4f change = new Quat4f();
    private AxisAngle4f axis = new AxisAngle4f();
    private BallType renderer;

    public static void init() throws IOException {
        model = ObjLoader.loadObj((String)"res/ball.obj");
        facemodel = ObjLoader.loadObj((String)"res/faceball.obj");
        footie = ObjLoader.loadObj((String)"res/football.obj");
        pudding = ObjLoader.loadObj((String)"res/pudding.obj");
        mace = ObjLoader.loadObj((String)"res/mace.obj");
        pop = SoundStore.get().getOgg("res/sounds/ballpop.ogg");
        grow = SoundStore.get().getOgg("res/sounds/shrink.ogg");
        hit = SoundStore.get().getOgg("res/sounds/tip2.ogg");
        leave = SoundStore.get().getOgg("res/sounds/leaving.ogg");
        fall = SoundStore.get().getOgg("res/sounds/falldown.ogg");
        texture = TextureLoader.get().getTextureLinear("res/ball.tga");
        eye = TextureLoader.get().getTextureLinear("res/eyeball.tga");
        beach = TextureLoader.get().getTextureLinear("res/beachball.tga");
        maceTexture = TextureLoader.get().getTextureLinear("res/metal.tga");
        footieTexture = TextureLoader.get().getTextureLinear("res/football.tga");
        eightBall = TextureLoader.get().getTextureLinear("res/ball8.tga");
        puddingTexture = TextureLoader.get().getTextureLinear("res/balls/pudding.tga");
        Ball.renderers[0] = new StandardBall(mace, maceTexture, "Naval Mine", hit, 0.3f, 0.95f, 0.993f);
        Ball.rendererIcons[0] = TextureLoader.get().getTextureLinear("res/balls/mineIcon.tga");
        Ball.renderers[1] = new EyeBall(facemodel, eye, "Gooey Eye Ball", hit);
        Ball.rendererIcons[1] = TextureLoader.get().getTextureLinear("res/balls/eyeball.tga");
        Ball.renderers[2] = new BigBall(model, beach, "Super Happy Fun Ball", hit);
        Ball.rendererIcons[2] = TextureLoader.get().getTextureLinear("res/balls/beach.tga");
        Ball.renderers[3] = new StandardBall(model, texture, "Standad Ball", hit, 0.4f, 0.95f, 0.995f);
        Ball.rendererIcons[3] = TextureLoader.get().getTextureLinear("res/balls/default.tga");
        Ball.renderers[4] = new StandardBall(footie, footieTexture, "Footie Ball", hit, 0.7f, 0.9f, 0.995f);
        Ball.rendererIcons[4] = TextureLoader.get().getTextureLinear("res/balls/footie.tga");
        Ball.renderers[5] = new StandardBall(facemodel, eightBall, "Magic Eight Ball", hit, 0.3f, 0.9f, 0.995f);
        Ball.rendererIcons[5] = TextureLoader.get().getTextureLinear("res/balls/eightball.tga");
        Ball.renderers[6] = new StandardBall(pudding, puddingTexture, "Xmas Pudding", hit, 0.4f, 1.0f, 0.995f);
        Ball.rendererIcons[6] = TextureLoader.get().getTextureLinear("res/balls/puddingIcon.tga");
    }

    public Ball(Map map, float x, float y) throws IOException {
        this.map = map;
        this.renderer = renderers[Configuration.getBallInUse()];
        this.rot = new Quat4f();
        this.rot.set(new AxisAngle4f(90.0f, 1.0f, 0.0f, 0.0f));
        this.matBuf = BufferUtils.createFloatBuffer((int)16);
        this.bounds = new Circle(x, y, 0.4f * this.renderer.getScale());
        this.center = new Circle(x, y, 0.1f * this.renderer.getScale());
        this.edged = new Circle(x, y, 0.01f * this.renderer.getScale());
        this.body = new DynamicBody(this.bounds, this.renderer.getBounce(), this.renderer.getFriction());
        this.oldx = x;
        this.oldy = y;
    }

    public void powerOn() {
        this.powerPill = 10000;
    }

    public boolean isPowerOn() {
        return this.powerPill > 0;
    }

    public float getX() {
        return this.body.getShape().getX();
    }

    public float getY() {
        return this.body.getShape().getY();
    }

    public Body getBody() {
        return this.body;
    }

    public Shape getShape() {
        return this.getBounds();
    }

    public Circle getBounds() {
        return this.bounds;
    }

    public void teleport(Teleport source) {
        if (this.teleportIn || this.teleportOut) {
            return;
        }
        this.teleport = source;
        this.teleportOut = true;
    }

    public Teleport getLastTeleport() {
        return this.teleport;
    }

    public void performTeleport() {
        this.teleport = this.map.getOtherTeleport(this.teleport);
        this.teleportOut = false;
        this.teleportIn = true;
    }

    public void shrink(int time) {
        this.size = 0.6f;
        this.shrinkTimer = time;
        this.shrinkEffect = 500;
    }

    public void speedUp(int time) {
        this.speedUp = time;
    }

    public void pop() {
        if (this.popping) {
            return;
        }
        pop.playAsSoundEffect(1.0f, 1.0f);
        this.popping = true;
        this.popTimer = 1000;
    }

    public void explode() {
        if (this.emitter == null) {
            return;
        }
        if (!this.exploding) {
            this.exploding = true;
            this.ex = this.bounds.getX();
            this.ey = this.bounds.getY();
        }
    }

    public void renderImpl(int delta, boolean reflection) {
        if (this.popping) {
            return;
        }
        if (reflection && this.complete) {
            return;
        }
        float x = this.body.getShape().getX();
        float y = this.body.getShape().getY();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.5f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-this.z));
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(this.size - 0.9f));
        if (this.teleportOut || this.teleportIn) {
            GL11.glRotatef((float)(this.teleportScale * 1000.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)this.teleportScale, (float)this.teleportScale, (float)this.teleportScale);
        }
        GL11.glScalef((float)this.size, (float)this.size, (float)this.size);
        if (this.exploding) {
            float scale = (float)this.explosionTimeout / 1000.0f;
            scale = Math.min(1.0f, scale);
            if (this.explosionTimeout < 0) {
                scale = 0.0f;
            }
            GL11.glScalef((float)scale, (float)scale, (float)scale);
        }
        this.mat.set(this.rot);
        this.matBuf.clear();
        for (int xo = 0; xo < 4; ++xo) {
            for (int yo = 0; yo < 4; ++yo) {
                this.matBuf.put(this.mat.getElement(xo, yo));
            }
        }
        this.matBuf.flip();
        GL11.glMultMatrix((FloatBuffer)this.matBuf);
        boolean outline = !this.exploding && !this.teleportIn && !this.teleportOut && !this.teleportIn;
        Color col = this.exploding ? Color.blue : null;
        this.renderer.preBall();
        Map.render(this.renderer.getTexture(), this.renderer.getModel(), col, outline && !reflection);
        this.renderer.postBall();
        if (this.exploding) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glPopMatrix();
    }

    public boolean isDead() {
        return this.dead;
    }

    public boolean fallComplete() {
        return this.z > 40.0f;
    }

    public boolean completed() {
        return this.z < -60.0f;
    }

    public boolean throughExit() {
        return this.complete;
    }

    public void complete(ExitItem exit) {
        this.map.removeBody(this.body);
        this.complete = true;
        leave.playAsSoundEffect(1.0f, 1.0f);
        this.exit = exit;
    }

    public void update(GlobalEmitter emitter, int delta, float brx, float bry) {
        float y;
        float x;
        float dy;
        float dx;
        float distance;
        this.hitCount -= delta;
        if (this.hitCount < 0) {
            this.hitCount = -1;
        }
        if (this.emitter == null) {
            this.emitter = emitter;
            emitter.addEffect(this);
        }
        if (this.powerPill > -1000) {
            this.powerPill -= delta;
        }
        if (this.shrinkEffect > -1000) {
            this.shrinkEffect -= delta;
        }
        if (this.speedUp > -1000) {
            this.speedUp -= delta;
        }
        if (this.shrinkTimer > 0) {
            this.shrinkTimer -= delta;
            if (this.shrinkTimer <= 0) {
                this.shrinkTimer = 0;
                this.bounds.setRadius(0.4f * this.renderer.getScale());
                if (this.map.clear(this, this.bounds)) {
                    this.size = 1.0f;
                    this.shrinkEffect = 500;
                    grow.playAsSoundEffect(1.0f, 1.0f);
                } else {
                    this.shrinkTimer = 1;
                }
            }
        }
        this.bounds.setRadius(0.4f * this.size * this.renderer.getScale());
        this.center.setRadius(0.2f * this.size * this.renderer.getScale());
        this.edged.setRadius(0.01f * this.size * this.renderer.getScale());
        if (this.popping) {
            this.popTimer -= delta;
            if (this.popTimer < 0) {
                this.dead = true;
                this.z = 100.0f;
            }
            this.body.setVelocity(0.0f, 0.0f);
        }
        if (this.exploding) {
            this.explosionTimeout -= delta;
            if (this.explosionTimeout <= -700) {
                this.dead = true;
                this.z = 100.0f;
            }
            this.body.setVelocity(0.0f, 0.0f);
            float xo = -0.05f + (float)(this.random() * (double)0.1f);
            float yo = -0.05f + (float)(this.random() * (double)0.1f);
            this.bounds.setX(this.ex + xo);
            this.bounds.setY(this.ey + yo);
            return;
        }
        if (this.teleportOut) {
            this.body.setVelocity(0.0f, 0.0f);
            this.body.getShape().setX(this.teleport.getX());
            this.body.getShape().setY(this.teleport.getY());
            this.teleportScale -= (float)delta * 0.002f;
            if (this.teleportScale < 0.0f) {
                this.teleportFlashIn = 0.0f;
                this.teleportStartX = this.teleport.getX();
                this.teleportStartY = this.teleport.getY();
                this.teleportScale = 0.0f;
                this.performTeleport();
            }
            return;
        }
        if (this.teleportIn) {
            this.body.setVelocity(0.0f, 0.0f);
            this.body.getShape().setX(10000.0f);
            this.body.getShape().setY(10000.0f);
            this.teleportFlashIn += (float)delta * 0.004f;
            if (this.teleportFlashIn >= 1.0f) {
                this.body.getShape().setX(this.teleport.getX());
                this.body.getShape().setY(this.teleport.getY());
                this.teleportFlashIn = 1.0f;
                this.teleportScale += (float)delta * 0.002f;
                if (this.teleportScale > 1.0f) {
                    this.teleportScale = 1.0f;
                    this.teleportIn = false;
                }
            }
            return;
        }
        if (this.teleport != null && (distance = (float)Math.sqrt((dx = this.teleport.getX() - this.body.getShape().getX()) * dx + (dy = this.teleport.getY() - this.body.getShape().getY()) * dy)) > 0.8f) {
            this.teleport = null;
        }
        if (this.dead) {
            this.z = (float)((double)this.z + (double)(this.vz * (float)delta) * 0.001);
            this.vz = (float)((double)this.vz + (double)delta * 0.098);
        } else if (this.complete) {
            this.z = (float)((double)this.z + (double)(this.vz * (float)delta) * 0.001);
            this.vz = (float)((double)this.vz - (double)delta * 0.2);
            this.body.stop();
            x = this.body.getShape().getX();
            y = this.body.getShape().getY();
            float mx = this.exit.getX() - x;
            float my = this.exit.getY() - y;
            this.body.getShape().setX(x += mx * (float)delta * 0.05f);
            this.body.getShape().setY(y += my * (float)delta * 0.05f);
        } else if (this.z < 0.0f) {
            this.vz = (float)((double)this.vz + (double)delta * 0.098);
        }
        if (!this.complete) {
            float len;
            x = this.body.getShape().getX();
            y = this.body.getShape().getY();
            float dx2 = x - this.oldx;
            float dy2 = y - this.oldy;
            this.lastMoveX = dx2;
            this.lastMoveY = dy2;
            Floor floor = this.map.getHighestFloor(this, this.center);
            if (floor != null) {
                dx2 -= floor.getLastMoveX();
                dy2 -= floor.getLastMoveY();
            }
            this.oldx = x;
            this.oldy = y;
            if ((len = (float)Math.sqrt((dx2 *= 120.0f) * dx2 + (dy2 *= 120.0f) * dy2)) != 0.0f) {
                this.axis.set(dy2 /= len, -(dx2 /= len), 0.0f, (float)Math.toRadians(len) * 1.3f);
                this.change.set(this.axis);
                this.rot.mul(this.change);
            }
            this.center.setX(x);
            this.center.setY(y);
            this.edged.setX(x);
            this.edged.setY(y);
            if (!this.dead) {
                if (!this.map.onFloor(this, this.center) && this.z == 0.0f) {
                    this.dead = true;
                    fall.playAsSoundEffect(1.0f, 1.0f);
                }
            } else if (this.map.onFloor(this, this.center)) {
                this.body.stop();
            }
        }
        if (!this.dead && !this.map.onFloor(this, this.edged)) {
            this.body.scaleVelocity(this.renderer.getSpeedFriction());
            this.body.scaleVelocity(this.renderer.getSpeedFriction());
            this.body.scaleVelocity(this.renderer.getSpeedFriction());
            this.body.scaleVelocity(this.renderer.getSpeedFriction());
        }
        if (this.speedUp > 0) {
            this.body.scaleVelocity(0.999f);
        } else {
            this.body.scaleVelocity(this.renderer.getSpeedFriction());
        }
    }

    public float getVelocityX() {
        return this.body.getVelocityX();
    }

    public float getVelocityY() {
        return this.body.getVelocityY();
    }

    public void adjustVelocity(float dx, float dy) {
        this.body.setVelocity(this.body.getVelocityX() + dx, this.body.getVelocityY() + dy);
    }

    public boolean hit(Ball other, float depth) {
        if (this.popping || this.exploding) {
            return false;
        }
        if (this.dead) {
            return false;
        }
        if (other == this && Math.abs(depth) > 0.02f) {
            this.renderer.getHitSound().playAsSoundEffect(1.0f, depth * 20.0f);
        }
        return false;
    }

    public MapElement copy(Map map) {
        try {
            return new Ball(map, this.body.getShape().getX(), this.body.getShape().getY());
        }
        catch (IOException e) {
            Log.log((Throwable)e);
            return null;
        }
    }

    public void createImpl() {
    }

    public void destroy() {
    }

    public void renderOtherImpl(int delta, boolean reflection) {
    }

    public void update(ParticleProvider provider, ParticleEngine engine, int delta) {
        float y;
        int p;
        float y2;
        float x;
        int i;
        this.renderer.update(this, provider, engine, delta);
        if (this.popping && !this.popped) {
            float yo;
            float xo;
            float ang;
            int p2;
            this.popped = true;
            for (i = 0; i < 100; ++i) {
                p2 = provider.getParticle(this, 300);
                if (p2 == -1) continue;
                x = this.bounds.getX();
                y2 = this.bounds.getY();
                ang = (float)(this.random() * Math.PI * 2.0);
                xo = (float)FastTrig.sin(ang) * 3.0f;
                yo = (float)FastTrig.cos(ang) * 3.0f;
                engine.setPos(p2, x, y2, 0.3f);
                engine.setSize(p2, 0.1f);
                engine.setColor(p2, 1.0f, 1.0f, 1.0f, 1.0f);
                engine.setVelocity(p2, xo, yo, -1.0f);
            }
            for (i = 0; i < 100; ++i) {
                p2 = provider.getParticle(this, 300);
                if (p2 == -1) continue;
                x = this.bounds.getX();
                y2 = this.bounds.getY();
                ang = (float)(this.random() * Math.PI * 2.0);
                xo = (float)FastTrig.sin(ang) * 1.5f;
                yo = (float)FastTrig.cos(ang) * 1.5f;
                engine.setPos(p2, x, y2, 0.3f);
                engine.setSize(p2, 0.1f);
                engine.setColor(p2, 1.0f, 1.0f, 1.0f, 1.0f);
                engine.setVelocity(p2, xo, yo, -1.0f);
            }
        }
        if (this.explosionTimeout > 0 && this.exploding && (p = provider.getParticle(this, 500)) != -1) {
            float x2 = this.bounds.getX();
            y = this.bounds.getY();
            float ang = (float)(this.random() * Math.PI * 2.0);
            float xo = (float)FastTrig.sin(ang) * 1.5f;
            float yo = (float)FastTrig.cos(ang) * 1.5f;
            engine.setPos(p, x2, y, 0.3f);
            engine.setSize(p, 0.3f);
            engine.setColor(p, 1.0f, 1.0f, 1.0f, 1.0f);
            engine.setVelocity(p, xo, yo, -1.0f + (float)(this.random() * 2.0));
        }
        if (this.teleportFlashIn > 0.0f && this.teleportFlashIn < 1.0f && (p = provider.getParticle(this, 350)) != -1) {
            float other = 1.0f - this.teleportFlashIn;
            x = this.teleportStartX * other + this.teleport.getX() * this.teleportFlashIn;
            y2 = this.teleportStartY * other + this.teleport.getY() * this.teleportFlashIn;
            engine.setPos(p, x, y2, 0.3f);
            engine.setSize(p, 0.3f);
            engine.setColor(p, 1.0f, 1.0f, 1.0f, 1.0f);
            engine.setVelocity(p, 0.0f, 0.0f, 0.0f);
        }
        if (this.shrinkEffect > 0 && (p = provider.getParticle(this, 350)) != -1) {
            float x3 = this.bounds.getX() - 0.2f + (float)(this.random() * (double)0.4f);
            y = this.bounds.getY() - 0.2f + (float)(this.random() * (double)0.4f);
            engine.setPos(p, x3, y, 0.3f);
            engine.setSize(p, 0.3f);
            engine.setColor(p, 1.0f, 1.0f, 1.0f, 1.0f);
            engine.setVelocity(p, 0.0f, 0.0f, 7.0f);
        }
        if (this.speedUp > 0 && (p = provider.getParticle(this, 350)) != -1) {
            float x4 = this.bounds.getX() - 0.2f + (float)(this.random() * (double)0.4f);
            y = this.bounds.getY() - 0.2f + (float)(this.random() * (double)0.4f);
            engine.setPos(p, x4, y, 0.3f + (float)(this.random() * (double)0.2f));
            engine.setSize(p, 0.4f);
            engine.setColor(p, 1.0f, 1.0f, 0.9f, 1.0f);
            engine.setVelocity(p, 0.0f, 0.0f, 3.0f);
        }
        if (this.powerPill > 0) {
            for (i = 0; i < 4; ++i) {
                int p3 = provider.getParticle(this, 600);
                if (p3 == -1) continue;
                float ang = (float)(this.random() * Math.PI * 2.0);
                float rad = (float)this.random() * 0.5f;
                float x5 = this.bounds.getX() + (float)(FastTrig.cos(ang) * (double)rad);
                float y3 = this.bounds.getY() + (float)(FastTrig.sin(ang) * (double)rad);
                engine.setPos(p3, x5, y3, (float)(this.random() * (double)0.3f));
                engine.setSize(p3, 0.06f);
                engine.setColor(p3, 1.0f, 1.0f, 1.0f, 1.0f);
                engine.setVelocity(p3, 0.0f, 0.0f, 3.0f);
            }
        }
        if (this.hitCount > 0 && (p = provider.getParticle(this, 100)) != -1) {
            float x6 = this.bounds.getX() - 0.3f + (float)(this.random() * (double)0.6f);
            y = this.bounds.getY() - 0.3f + (float)(this.random() * (double)0.6f);
            engine.setPos(p, x6, y, 0.3f + (float)(this.random() * (double)0.3f));
            engine.setSize(p, 0.05f);
            engine.setColor(p, 1.0f, 1.0f, 1.0f, 1.0f);
            engine.setVelocity(p, 0.0f, 0.0f, 3.0f);
        }
    }

    public void updateParticle(int index, int delta, ParticleEngine engine, int life) {
        if (this.teleportFlashIn > 0.0f && this.teleportFlashIn < 1.0f) {
            engine.adjustColor(index, 0.0f, 0.0f, -0.03f, -0.01f);
            engine.adjustSize(index, -1.0E-4f);
        } else if (this.exploding) {
            engine.adjustColor(index, -0.004f, -0.004f, 0.0f, -0.01f);
        } else if (this.popping) {
            engine.adjustColor(index, 0.0f, 0.0f, 0.0f, -0.02f);
        } else if (this.shrinkEffect > -400) {
            engine.adjustColor(index, 0.0f, -0.01f, 0.0f, -0.01f);
            engine.adjustSize(index, -0.002f);
        } else if (this.speedUp > -400) {
            engine.adjustColor(index, 0.0f, -0.007f, -0.01f, -0.01f);
            engine.adjustSize(index, -0.004f);
        } else if (this.powerPill > -1000) {
            engine.adjustColor(index, 0.0f, 0.0f, -0.05f, -0.01f);
            float nx = engine.getX(index) + this.lastMoveX;
            float ny = engine.getY(index) + this.lastMoveY;
            float nz = engine.getZ(index);
            engine.setPos(index, nx, ny, nz);
        } else {
            engine.adjustColor(index, -0.01f, -0.01f, -0.01f, -0.01f);
        }
    }

    public boolean finished() {
        return false;
    }

    private double random() {
        return Math.random();
    }

    static {
        renderers = new BallType[10];
        rendererIcons = new Texture[10];
    }
}

