/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.tilt;

import java.io.IOException;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.newdawn.render.texture.Texture;
import org.newdawn.render.texture.TextureLoader;
import org.newdawn.render.util.Color;
import org.newdawn.render.window.LWJGLWindow;
import org.newdawn.sound.SoundStore;
import org.newdawn.state.GameState;
import org.newdawn.state.StateBasedGame;
import org.newdawn.state.transitions.FadeInTransition;
import org.newdawn.state.transitions.FadeOutTransition;
import org.newdawn.state.transitions.Transition;
import org.newdawn.tilt.Configuration;
import org.newdawn.tilt.MouseOverArea;
import org.newdawn.tilt.MouseOverGroup;
import org.newdawn.tilt.SharedUI;
import org.newdawn.tilt.TiltController;

public class AudioSettingsState
implements GameState {
    public static final int ID = 23;
    private LWJGLWindow window;
    private Texture back;
    private Texture title;
    private Texture check;
    private Texture uncheck;
    private Texture soundfx;
    private Texture music;
    private Texture plus;
    private Texture minus;
    private Texture bar;
    private MouseOverArea backArea;
    private MouseOverArea soundfxArea;
    private MouseOverArea musicArea;
    private MouseOverArea plusArea1;
    private MouseOverArea minusArea1;
    private MouseOverArea plusArea2;
    private MouseOverArea minusArea2;
    private MouseOverGroup group;
    private int selected;
    private boolean musicOn;
    private boolean soundOn;
    private float musicVolume;
    private float soundVolume;
    private Color gray = new Color(0.0f, 0.0f, 0.0f, 0.5f);

    public AudioSettingsState(LWJGLWindow window) {
        this.window = window;
    }

    private void renderRectangle(float x, float y, float width, float height) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glEnd();
    }

    public void init(StateBasedGame game) throws IOException {
        this.title = TextureLoader.get().getTextureLinear("res/settings.tga");
        this.back = TextureLoader.get().getTextureLinear("res/backtomenu.tga");
        this.music = TextureLoader.get().getTextureLinear("res/music.tga");
        this.soundfx = TextureLoader.get().getTextureLinear("res/soundfx.tga");
        this.check = TextureLoader.get().getTextureLinear("res/check.tga");
        this.uncheck = TextureLoader.get().getTextureLinear("res/uncheck.tga");
        this.plus = TextureLoader.get().getTextureLinear("res/plus.tga");
        this.minus = TextureLoader.get().getTextureLinear("res/minus.tga");
        this.bar = TextureLoader.get().getTextureLinear("res/bar.tga");
        this.backArea = new MouseOverArea(this.window, 200.0f, 540.0f, 200.0f, 50.0f);
        this.musicArea = new MouseOverArea(this.window, 370.0f, 130.0f, 70.0f, 50.0f);
        this.soundfxArea = new MouseOverArea(this.window, 370.0f, 295.0f, 70.0f, 50.0f);
        this.minusArea1 = new MouseOverArea(this.window, 75.0f, 200.0f, 50.0f, 50.0f);
        this.plusArea1 = new MouseOverArea(this.window, 470.0f, 200.0f, 50.0f, 50.0f);
        this.minusArea2 = new MouseOverArea(this.window, 75.0f, 365.0f, 50.0f, 50.0f);
        this.plusArea2 = new MouseOverArea(this.window, 470.0f, 365.0f, 50.0f, 50.0f);
        this.group = new MouseOverGroup("audio");
        this.group.addArea(this.musicArea);
        this.group.addArea(this.minusArea1);
        this.group.addArea(this.plusArea1);
        this.group.addArea(this.soundfxArea);
        this.group.addArea(this.minusArea2);
        this.group.addArea(this.plusArea2);
        this.group.addArea(this.backArea);
    }

    public void reinit(StateBasedGame game) throws IOException {
    }

    public void render(StateBasedGame game, int delta) {
        this.window.enterOrtho(600, 600);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.title.bind();
        this.renderRectangle(184.0f, -15.0f, 256.0f, 128.0f);
        this.music.bind();
        this.renderRectangle(160.0f, 130.0f, 128.0f, 64.0f);
        this.soundfx.bind();
        this.renderRectangle(160.0f, 290.0f, 256.0f, 128.0f);
        float col = 0.75f + this.minusArea1.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.minus.bind();
        this.renderRectangle(75.0f, 215.0f, 64.0f, 32.0f);
        col = 0.75f + this.plusArea1.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.plus.bind();
        this.renderRectangle(470.0f, 200.0f, 64.0f, 64.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.bar.bind();
        this.renderRectangle(55.0f, 190.0f, 512.0f, 64.0f);
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.7f);
        Texture.bindNone();
        this.renderRectangle(150.0f, 210.0f, 300.0f * this.musicVolume, 27.0f);
        col = 0.75f + this.minusArea2.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.minus.bind();
        this.renderRectangle(75.0f, 370.0f, 64.0f, 32.0f);
        col = 0.75f + this.plusArea2.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.plus.bind();
        this.renderRectangle(470.0f, 360.0f, 64.0f, 64.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.bar.bind();
        this.renderRectangle(55.0f, 350.0f, 512.0f, 64.0f);
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.7f);
        Texture.bindNone();
        this.renderRectangle(150.0f, 370.0f, 300.0f * this.soundVolume, 27.0f);
        if (this.soundOn) {
            this.check.bind();
        } else {
            this.uncheck.bind();
        }
        col = 0.75f + this.soundfxArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.renderRectangle(350.0f, 290.0f, 128.0f, 64.0f);
        if (this.musicOn) {
            this.check.bind();
        } else {
            this.uncheck.bind();
        }
        col = 0.75f + this.musicArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.renderRectangle(350.0f, 130.0f, 128.0f, 64.0f);
        col = 0.75f + this.backArea.getValue();
        GL11.glColor3f((float)col, (float)col, (float)col);
        this.back.bind();
        this.renderRectangle(174.0f, 540.0f, 256.0f, 64.0f);
        if (!SoundStore.get().soundWorks()) {
            this.drawString(450, "Sound Initialisation Failed");
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        this.window.leaveOrtho();
    }

    private void drawString(int y, String text) {
        int x = (600 - SharedUI.smallFontO.getWidth(text)) / 2;
        SharedUI.smallFontO.drawString(x + 3, y + 3, text, this.gray);
        SharedUI.smallFontO.drawString(x, y, text, Color.white);
    }

    public void update(StateBasedGame game, int delta) {
        int oldSelected = this.selected;
        this.selected = 0;
        if (this.backArea.considerMouse(delta)) {
            this.selected = 1;
        }
        if (this.musicArea.considerMouse(delta)) {
            this.selected = 2;
        }
        if (this.soundfxArea.considerMouse(delta)) {
            this.selected = 3;
        }
        if (this.minusArea1.considerMouse(delta)) {
            this.selected = 4;
        }
        if (this.plusArea1.considerMouse(delta)) {
            this.selected = 5;
        }
        if (this.minusArea2.considerMouse(delta)) {
            this.selected = 6;
        }
        if (this.plusArea2.considerMouse(delta)) {
            this.selected = 7;
        }
        if (oldSelected != this.selected && this.selected != 0) {
            SharedUI.playOver();
        }
        this.group.update();
        if (TiltController.buttonPressed()) {
            this.selectOption(game);
        }
        while (Mouse.next()) {
            if (Mouse.getEventButton() < 0 || !Mouse.getEventButtonState()) continue;
            this.selectOption(game);
        }
    }

    private void selectOption(StateBasedGame game) {
        if (this.selected == 1) {
            SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
            game.changeToState(7, (Transition)new FadeOutTransition(Color.white), (Transition)new FadeInTransition(Color.white));
            return;
        }
        if (this.selected == 2) {
            if (SoundStore.get().soundWorks()) {
                SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
                this.musicOn = !this.musicOn;
                Configuration.setGlobalValue("musicon", this.musicOn ? 1.0f : 0.0f);
                SoundStore.get().setMusicOn(this.musicOn);
            } else {
                SharedUI.dud.playAsSoundEffect(1.0f, 1.0f);
            }
        }
        if (this.selected == 3) {
            if (SoundStore.get().soundWorks()) {
                SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
                this.soundOn = !this.soundOn;
                Configuration.setGlobalValue("soundon", this.soundOn ? 1.0f : 0.0f);
                SoundStore.get().setSoundsOn(this.soundOn);
            } else {
                SharedUI.dud.playAsSoundEffect(1.0f, 1.0f);
            }
        }
        if (this.selected == 6) {
            if (this.soundVolume > 0.0f) {
                this.soundVolume = (float)((double)this.soundVolume - 0.1);
                SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
                Configuration.setGlobalValue("soundvolume", this.soundVolume);
            } else {
                SharedUI.dud.playAsSoundEffect(1.0f, 1.0f);
            }
        }
        if (this.selected == 7) {
            if (this.soundVolume < 1.0f) {
                this.soundVolume = (float)((double)this.soundVolume + 0.1);
                SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
                Configuration.setGlobalValue("soundvolume", this.soundVolume);
            } else {
                SharedUI.dud.playAsSoundEffect(1.0f, 1.0f);
            }
        }
        if (this.selected == 4) {
            if (this.musicVolume > 0.0f) {
                SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
                this.musicVolume = (float)((double)this.musicVolume - 0.1);
                Configuration.setGlobalValue("musicvolume", this.musicVolume);
            } else {
                SharedUI.dud.playAsSoundEffect(1.0f, 1.0f);
            }
        }
        if (this.selected == 5) {
            if (this.musicVolume < 1.0f) {
                SharedUI.select.playAsSoundEffect(1.0f, 1.0f);
                this.musicVolume = (float)((double)this.musicVolume + 0.1);
                Configuration.setGlobalValue("musicvolume", this.musicVolume);
            } else {
                SharedUI.dud.playAsSoundEffect(1.0f, 1.0f);
            }
        }
        SoundStore.get().setMusicVolume(this.musicVolume);
        SoundStore.get().setSoundVolume(this.soundVolume);
    }

    public void enterState(StateBasedGame game) {
        Mouse.setGrabbed((boolean)false);
        this.musicOn = Configuration.getGlobalValue("musicon", 1.0f) == 1.0f;
        this.soundOn = Configuration.getGlobalValue("soundon", 1.0f) == 1.0f;
        this.musicVolume = Configuration.getGlobalValue("musicvolume", 0.5f);
        this.soundVolume = Configuration.getGlobalValue("soundvolume", 1.0f);
        this.group.reset();
    }

    public void leaveState(StateBasedGame game) {
    }
}

