/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.util.map;

import java.util.Arrays;
import org.newdawn.util.map.Path;
import org.newdawn.util.map.PathFinder;
import org.newdawn.util.map.TileMap;
import org.newdawn.util.map.TileSet;

public class DJKPathFinder
implements PathFinder {
    private TileMap map;
    private TileSet set;
    private int[] distance;
    private int maxsearch;
    private int sx;
    private int sy;
    private int bestPath = 10000;

    public DJKPathFinder(TileMap map, TileSet set) {
        this.map = map;
        this.set = set;
        this.distance = new int[map.getMapWidth() * map.getMapHeight()];
    }

    public void reset() {
        Arrays.fill(this.distance, 0);
    }

    public int[] getSearchData() {
        return this.distance;
    }

    public synchronized Path findPath(int sx, int sy, int dx, int dy, int maxsearch) {
        int depth = 1;
        this.sx = sx;
        this.sy = sy;
        this.bestPath = 10000;
        this.maxsearch = maxsearch;
        if (this.processNode(dx, dy, depth)) {
            Path path = new Path();
            this.findNextPoint(path, sx, sy, this.distance[sx + sy * this.map.getMapWidth()] - 1);
            return path;
        }
        return null;
    }

    private void findNextPoint(Path path, int x, int y, int d) {
        int sy;
        int sx;
        int yo;
        int xo;
        if (d < 0) {
            return;
        }
        path.addPoint(x, y);
        for (xo = -1; xo < 2; ++xo) {
            for (yo = -1; yo < 2; ++yo) {
                if (xo == 0 && yo == 0 || xo != 0 && yo != 0 || this.distance[(sx = x + xo) + (sy = y + yo) * this.map.getMapWidth()] != d) continue;
                this.findNextPoint(path, sx, sy, this.distance[sx + sy * this.map.getMapWidth()] - 1);
                return;
            }
        }
        for (xo = -1; xo < 2; ++xo) {
            for (yo = -1; yo < 2; ++yo) {
                if (xo == 0 || yo == 0 || this.distance[(sx = x + xo) + (sy = y + yo) * this.map.getMapWidth()] != d) continue;
                this.findNextPoint(path, sx, sy, this.distance[sx + sy * this.map.getMapWidth()] - 1);
                return;
            }
        }
    }

    private boolean processNode(int x, int y, int depth) {
        if (depth >= this.maxsearch) {
            return false;
        }
        if (depth >= this.bestPath) {
            return false;
        }
        if (x < 0 || y < 0 || x >= this.map.getMapWidth() || y >= this.map.getMapHeight()) {
            return false;
        }
        if (this.isBlocked(x, y)) {
            return false;
        }
        int val = this.distance[x + y * this.map.getMapWidth()];
        if (val != 0 && val <= depth) {
            return false;
        }
        this.distance[x + y * this.map.getMapWidth()] = depth;
        if (x == this.sx && y == this.sy) {
            this.bestPath = depth;
            return true;
        }
        boolean found = false;
        for (int xo = -1; xo < 2; ++xo) {
            for (int yo = -1; yo < 2; ++yo) {
                if (xo == 0 && yo == 0 || !this.validMove(x, y, xo, yo)) continue;
                found |= this.processNode(x + xo, y + yo, depth + 1);
            }
        }
        return found;
    }

    private boolean validMove(int x, int y, int xo, int yo) {
        if (xo == 0 || yo == 0) {
            return true;
        }
        if (this.isBlocked(x + xo, y)) {
            return false;
        }
        return !this.isBlocked(x, y + yo);
    }

    public boolean isBlocked(int x, int y) {
        if (this.map.isBlocked(x, y)) {
            return true;
        }
        return this.set.blocksMovement(this.map.getTileAt(x, y, 0));
    }
}

