/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.util.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.newdawn.util.map.Path;
import org.newdawn.util.map.PathFinder;
import org.newdawn.util.map.PathFinderCallback;
import org.newdawn.util.map.TileMap;
import org.newdawn.util.map.TileSet;

public strictfp class AStarPathFinder
implements PathFinder {
    private TileMap map;
    private TileSet set;
    private int[] distance;
    private int maxsearch;
    private int sx;
    private int sy;
    private PathFinderCallback callback;
    private ArrayList open = new ArrayList();

    public AStarPathFinder(TileMap map, TileSet set) {
        this(map, set, null);
    }

    public AStarPathFinder(TileMap map, TileSet set, PathFinderCallback callback) {
        this.map = map;
        this.set = set;
        this.callback = callback;
        this.distance = new int[map.getMapWidth() * map.getMapHeight()];
    }

    public void reset() {
        this.open.clear();
        Arrays.fill(this.distance, 0);
    }

    public int[] getSearchData() {
        return this.distance;
    }

    public synchronized Path findPath(int sx, int sy, int dx, int dy, int maxsearch) {
        boolean depth = true;
        this.sx = sx;
        this.sy = sy;
        this.maxsearch = maxsearch;
        Step step = new Step(null, dx, dy);
        this.open.add(step);
        return this.processNodes();
    }

    private Path processNodes() {
        Step step = this.findBest();
        while (!step.is(this.sx, this.sy)) {
            for (int x = -1; x < 2; ++x) {
                for (int y = -1; y < 2; ++y) {
                    if (x == 0 && y == 0) continue;
                    int xp = step.x + x;
                    int yp = step.y + y;
                    if (this.checkDiaganolBlock(step.x, step.y, x, y) || !this.validNode(xp, yp)) continue;
                    this.open.add(new Step(step, xp, yp));
                }
            }
            step = this.findBest();
            if (step == null) {
                return null;
            }
            if (this.callback == null) continue;
            this.distance[step.x + step.y * this.map.getMapWidth()] = 1;
            this.callback.fireNode(step.x, step.y);
        }
        Path path = new Path();
        while (step.parent != null) {
            path.addPoint(step.x, step.y);
            step = step.parent;
        }
        path.addPoint(step.x, step.y);
        return path;
    }

    private boolean checkDiaganolBlock(int x, int y, int xo, int yo) {
        if (xo == 0 || yo == 0) {
            return false;
        }
        if (this.isBlocked(x + xo, y)) {
            return true;
        }
        return this.isBlocked(x, y + yo);
    }

    private boolean validNode(int x, int y) {
        if (this.isBlocked(x, y)) {
            return false;
        }
        return this.distance[x + y * this.map.getMapWidth()] == 0;
    }

    private Step findBest() {
        Collections.sort(this.open);
        if (this.open.size() == 0) {
            return null;
        }
        Step best = (Step)this.open.get(0);
        ++best.count;
        if (best.count > 9 || best.depth > this.maxsearch) {
            this.open.remove(best);
            return this.findBest();
        }
        return best;
    }

    private int evalH(int x, int y) {
        return Math.abs(this.sx - x) + Math.abs(this.sy - y);
    }

    public boolean isBlocked(int x, int y) {
        if (this.map.isBlocked(x, y)) {
            return true;
        }
        return this.set.blocksMovement(this.map.getTileAt(x, y, 0));
    }

    private strictfp class Step
    implements Comparable {
        public int x;
        public int y;
        public int h;
        public int count;
        public int depth;
        public Step parent;

        public Step(Step parent, int x, int y) {
            this.x = x;
            this.y = y;
            this.parent = parent;
            this.depth = parent != null ? parent.depth + 1 : 0;
            this.h = Math.abs(AStarPathFinder.this.sx - x) + Math.abs(AStarPathFinder.this.sy - y);
            if (this.depth <= AStarPathFinder.this.maxsearch) {
                ((AStarPathFinder)AStarPathFinder.this).distance[x + y * ((AStarPathFinder)AStarPathFinder.this).map.getMapWidth()] = 2;
            }
        }

        public boolean is(int x, int y) {
            return x == this.x && y == this.y;
        }

        public int compareTo(Object o) {
            return this.h - ((Step)o).h;
        }
    }
}

