/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.util.input;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.newdawn.util.input.Mouse;

public class AWTMouse
extends Mouse
implements MouseMotionListener,
MouseListener {
    private int x;
    private int y;
    private int dx;
    private int dy;
    private boolean first = true;
    private Component component;
    private boolean[] buttons = new boolean[3];

    public AWTMouse(Component component) {
        this.component = component;
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    public int getDX() {
        int temp = this.dx;
        this.dx = 0;
        return temp;
    }

    public int getDY() {
        int temp = this.dy;
        this.dy = 0;
        return temp;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isButtonDown(int button) {
        return this.buttons[button];
    }

    private void updateMouseLocation(MouseEvent e) {
        if (!this.first) {
            this.dx = e.getX() - this.x;
            this.dy = this.component.getHeight() - e.getY() - this.y;
        }
        this.x = e.getX();
        this.y = this.component.getHeight() - e.getY();
        this.first = false;
    }

    public void mouseDragged(MouseEvent e) {
        e.consume();
        this.updateMouseLocation(e);
    }

    public void mouseMoved(MouseEvent e) {
        e.consume();
        this.updateMouseLocation(e);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.buttons[e.getButton() - 1] = true;
    }

    public void mouseReleased(MouseEvent e) {
        this.buttons[e.getButton() - 1] = false;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

