/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.util.controller;

import org.lwjgl.LWJGLException;
import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.newdawn.util.Log;
import org.newdawn.util.controller.ControllerAdapter;

public class Controls {
    private static int mx = 0;
    private static int my = 0;
    private static boolean m1 = false;
    private static boolean m2 = false;
    private static boolean m3 = false;
    private static boolean[] keys = new boolean[256];
    private static char lastchar = '\u0000';
    private static int wheel = 0;
    private static Controller gamepad = null;

    public static void create() {
        Log.log("creating input stuff");
        try {
            Controllers.create();
            int count = Controllers.getControllerCount();
            int targetIndex = -1;
            Log.log(count + " Controllers Found");
            for (int i = 0; i < count; ++i) {
                Controller controller = Controllers.getController((int)i);
                if (targetIndex >= 0 || controller.getButtonCount() < 3) continue;
                targetIndex = i;
            }
            gamepad = count > 0 && targetIndex >= 0 ? (Controllers.getController((int)targetIndex).getButtonCount() >= 3 ? Controllers.getController((int)targetIndex) : new ControllerAdapter()) : new ControllerAdapter();
        }
        catch (LWJGLException e) {
            Log.log("Unable to create Controllers - using dummy adapter");
            gamepad = new ControllerAdapter();
        }
    }

    public static void update() {
        mx = Mouse.getX();
        my = Mouse.getY();
        m1 = Mouse.isButtonDown((int)0);
        m2 = Mouse.isButtonDown((int)1);
        m3 = Mouse.isButtonDown((int)2);
        wheel = Mouse.getDWheel();
        lastchar = '\u0000';
        while (Keyboard.next()) {
            boolean state = Keyboard.getEventKeyState();
            int key = Keyboard.getEventKey();
            if (!keys[key] && state) {
                lastchar = Keyboard.getEventCharacter();
            }
            Controls.keys[key] = state;
        }
        Controllers.clearEvents();
    }

    public static int getXAxisState() {
        int x = 0;
        if (keys[205] || gamepad.getXAxisValue() > 0.5f || gamepad.getPovX() > 0.5f) {
            ++x;
        }
        if (keys[203] || gamepad.getXAxisValue() < -0.5f || gamepad.getPovX() < -0.5f) {
            --x;
        }
        return x;
    }

    public static int getYAxisState() {
        int y = 0;
        if (keys[208] || gamepad.getYAxisValue() > 0.5f || gamepad.getPovY() > 0.5f) {
            ++y;
        }
        if (keys[200] || gamepad.getYAxisValue() < -0.5f || gamepad.getPovY() < -0.5f) {
            --y;
        }
        return y;
    }

    public static boolean isButton1Pressed() {
        return keys[29] || keys[44] || keys[30] || gamepad.isButtonPressed(0);
    }

    public static boolean isButton2Pressed() {
        return keys[56] || keys[45] || keys[31] || gamepad.isButtonPressed(1);
    }

    public static boolean isButton3Pressed() {
        return keys[57] || keys[46] || keys[32] || gamepad.isButtonPressed(2);
    }

    public static boolean clearKey(int key) {
        boolean val = keys[key];
        Controls.keys[key] = false;
        return val;
    }

    public static char getLastChar() {
        return lastchar;
    }
}

